/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.genetics;

import com.hazelcast.shaded.org.apache.commons.math3.genetics.AbstractListChromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.BinaryChromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.BinaryMutation;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.Chromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.CrossoverPolicy;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.ElitisticListPopulation;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.FixedGenerationCount;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.GeneticAlgorithm;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.MutationPolicy;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.OnePointCrossover;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.Population;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.SelectionPolicy;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.StoppingCondition;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.TournamentSelection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GeneticAlgorithmTestBinary {
    private static final int DIMENSION = 50;
    private static final int POPULATION_SIZE = 50;
    private static final int NUM_GENERATIONS = 50;
    private static final double ELITISM_RATE = 0.2;
    private static final double CROSSOVER_RATE = 1.0;
    private static final double MUTATION_RATE = 0.1;
    private static final int TOURNAMENT_ARITY = 2;

    @Test
    public void test() {
        GeneticAlgorithm ga = new GeneticAlgorithm((CrossoverPolicy)new OnePointCrossover(), 1.0, (MutationPolicy)new BinaryMutation(), 0.1, (SelectionPolicy)new TournamentSelection(2));
        Assert.assertEquals((long)0L, (long)ga.getGenerationsEvolved());
        ElitisticListPopulation initial = GeneticAlgorithmTestBinary.randomPopulation();
        FixedGenerationCount stopCond = new FixedGenerationCount(50);
        Chromosome bestInitial = initial.getFittestChromosome();
        Population finalPopulation = ga.evolve((Population)initial, (StoppingCondition)stopCond);
        Chromosome bestFinal = finalPopulation.getFittestChromosome();
        Assert.assertTrue((bestFinal.compareTo(bestInitial) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)50L, (long)ga.getGenerationsEvolved());
    }

    private static ElitisticListPopulation randomPopulation() {
        LinkedList<FindOnes> popList = new LinkedList<FindOnes>();
        for (int i = 0; i < 50; ++i) {
            FindOnes randChrom = new FindOnes(BinaryChromosome.randomBinaryRepresentation((int)50));
            popList.add(randChrom);
        }
        return new ElitisticListPopulation(popList, popList.size(), 0.2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindOnes
    extends BinaryChromosome {
        public FindOnes(List<Integer> representation) {
            super(representation);
        }

        public double fitness() {
            int num = 0;
            Iterator i$ = this.getRepresentation().iterator();
            while (i$.hasNext()) {
                int val = (Integer)i$.next();
                if (val == 0) continue;
                ++num;
            }
            return num;
        }

        public AbstractListChromosome<Integer> newFixedLengthChromosome(List<Integer> chromosomeRepresentation) {
            return new FindOnes(chromosomeRepresentation);
        }
    }
}

