/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares;

import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.StatisticalReferenceDataset;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StatisticalReferenceDatasetFactory {
    private StatisticalReferenceDatasetFactory() {
    }

    public static BufferedReader createBufferedReaderFromResource(String name) throws IOException {
        InputStream resourceAsStream = StatisticalReferenceDatasetFactory.class.getResourceAsStream(name);
        if (resourceAsStream == null) {
            throw new IOException("could not find resource " + name);
        }
        return new BufferedReader(new InputStreamReader(resourceAsStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticalReferenceDataset createKirby2() throws IOException {
        BufferedReader in = StatisticalReferenceDatasetFactory.createBufferedReaderFromResource("Kirby2.dat");
        StatisticalReferenceDataset dataset = null;
        try {
            dataset = new StatisticalReferenceDataset(in){

                public double getModelValue(double x, double[] a) {
                    double p = a[0] + x * (a[1] + x * a[2]);
                    double q = 1.0 + x * (a[3] + x * a[4]);
                    return p / q;
                }

                public double[] getModelDerivatives(double x, double[] a) {
                    double[] dy = new double[5];
                    double p = a[0] + x * (a[1] + x * a[2]);
                    double q = 1.0 + x * (a[3] + x * a[4]);
                    dy[0] = 1.0 / q;
                    dy[1] = x / q;
                    dy[2] = x * dy[1];
                    dy[3] = -x * p / (q * q);
                    dy[4] = x * dy[3];
                    return dy;
                }
            };
        }
        finally {
            in.close();
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticalReferenceDataset createHahn1() throws IOException {
        BufferedReader in = StatisticalReferenceDatasetFactory.createBufferedReaderFromResource("Hahn1.dat");
        StatisticalReferenceDataset dataset = null;
        try {
            dataset = new StatisticalReferenceDataset(in){

                public double getModelValue(double x, double[] a) {
                    double p = a[0] + x * (a[1] + x * (a[2] + x * a[3]));
                    double q = 1.0 + x * (a[4] + x * (a[5] + x * a[6]));
                    return p / q;
                }

                public double[] getModelDerivatives(double x, double[] a) {
                    double[] dy = new double[7];
                    double p = a[0] + x * (a[1] + x * (a[2] + x * a[3]));
                    double q = 1.0 + x * (a[4] + x * (a[5] + x * a[6]));
                    dy[0] = 1.0 / q;
                    dy[1] = x * dy[0];
                    dy[2] = x * dy[1];
                    dy[3] = x * dy[2];
                    dy[4] = -x * p / (q * q);
                    dy[5] = x * dy[4];
                    dy[6] = x * dy[5];
                    return dy;
                }
            };
        }
        finally {
            in.close();
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticalReferenceDataset createMGH17() throws IOException {
        BufferedReader in = StatisticalReferenceDatasetFactory.createBufferedReaderFromResource("MGH17.dat");
        StatisticalReferenceDataset dataset = null;
        try {
            dataset = new StatisticalReferenceDataset(in){

                public double getModelValue(double x, double[] a) {
                    return a[0] + a[1] * FastMath.exp((double)(-a[3] * x)) + a[2] * FastMath.exp((double)(-a[4] * x));
                }

                public double[] getModelDerivatives(double x, double[] a) {
                    double[] dy;
                    dy = new double[]{1.0, FastMath.exp((double)(-x * a[3])), FastMath.exp((double)(-x * a[4])), -x * a[1] * dy[1], -x * a[2] * dy[2]};
                    return dy;
                }
            };
        }
        finally {
            in.close();
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatisticalReferenceDataset createLanczos1() throws IOException {
        BufferedReader in = StatisticalReferenceDatasetFactory.createBufferedReaderFromResource("Lanczos1.dat");
        StatisticalReferenceDataset dataset = null;
        try {
            dataset = new StatisticalReferenceDataset(in){

                public double getModelValue(double x, double[] a) {
                    System.out.println(a[0] + ", " + a[1] + ", " + a[2] + ", " + a[3] + ", " + a[4] + ", " + a[5]);
                    return a[0] * FastMath.exp((double)(-a[3] * x)) + a[1] * FastMath.exp((double)(-a[4] * x)) + a[2] * FastMath.exp((double)(-a[5] * x));
                }

                public double[] getModelDerivatives(double x, double[] a) {
                    double[] dy;
                    dy = new double[]{FastMath.exp((double)(-x * a[3])), FastMath.exp((double)(-x * a[4])), FastMath.exp((double)(-x * a[5])), -x * a[0] * dy[0], -x * a[1] * dy[1], -x * a[2] * dy[2]};
                    return dy;
                }
            };
        }
        finally {
            in.close();
        }
        return dataset;
    }

    public StatisticalReferenceDataset[] createAll() throws IOException {
        return new StatisticalReferenceDataset[]{StatisticalReferenceDatasetFactory.createKirby2(), StatisticalReferenceDatasetFactory.createMGH17()};
    }
}

