/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateVectorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalStateException;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.LeastSquaresFactory;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.StatisticalReferenceDataset;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.StatisticalReferenceDatasetFactory;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.ValueAndJacobianFunction;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DiagonalMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.SingularMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Pair;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class EvaluationTest {
    public LeastSquaresBuilder builder(StatisticalReferenceDataset dataset) {
        StatisticalReferenceDataset.LeastSquaresProblem problem = dataset.getLeastSquaresProblem();
        double[] start = dataset.getParameters();
        double[] observed = dataset.getData()[1];
        double[] weights = new double[observed.length];
        Arrays.fill(weights, 1.0);
        return new LeastSquaresBuilder().model(problem.getModelFunction(), problem.getModelFunctionJacobian()).target(observed).weight((RealMatrix)new DiagonalMatrix(weights)).start(start);
    }

    @Test
    public void testComputeResiduals() {
        ArrayRealVector point = new ArrayRealVector(2);
        LeastSquaresProblem.Evaluation evaluation = new LeastSquaresBuilder().target((RealVector)new ArrayRealVector(new double[]{3.0, -1.0})).model(new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector point) {
                return new Pair((Object)new ArrayRealVector(new double[]{1.0, 2.0}), (Object)MatrixUtils.createRealIdentityMatrix((int)2));
            }
        }).weight(MatrixUtils.createRealIdentityMatrix((int)2)).build().evaluate((RealVector)point);
        Assert.assertArrayEquals((double[])evaluation.getResiduals().toArray(), (double[])new double[]{2.0, -3.0}, (double)Precision.EPSILON);
    }

    @Test
    public void testComputeCovariance() throws IOException {
        ArrayRealVector point = new ArrayRealVector(2);
        LeastSquaresProblem.Evaluation evaluation = new LeastSquaresBuilder().model(new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector point) {
                return new Pair((Object)new ArrayRealVector(2), (Object)MatrixUtils.createRealDiagonalMatrix((double[])new double[]{1.0, 0.01}));
            }
        }).weight(MatrixUtils.createRealDiagonalMatrix((double[])new double[]{1.0, 1.0})).target((RealVector)new ArrayRealVector(2)).build().evaluate((RealVector)point);
        TestUtils.assertEquals("covariance", evaluation.getCovariances(FastMath.nextAfter((double)1.0E-4, (double)0.0)), MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0}, {0.0, 10000.0}}), Precision.EPSILON);
        try {
            evaluation.getCovariances(FastMath.nextAfter((double)1.0E-4, (double)1.0));
            Assert.fail((String)"Expected Exception");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testComputeValueAndJacobian() {
        ArrayRealVector point = new ArrayRealVector(new double[]{1.0, 2.0});
        LeastSquaresProblem.Evaluation evaluation = new LeastSquaresBuilder().weight((RealMatrix)new DiagonalMatrix(new double[]{16.0, 4.0})).model(new MultivariateJacobianFunction((RealVector)point){
            final /* synthetic */ RealVector val$point;
            {
                this.val$point = realVector;
            }

            public Pair<RealVector, RealMatrix> value(RealVector actualPoint) {
                Assert.assertArrayEquals((double[])this.val$point.toArray(), (double[])actualPoint.toArray(), (double)Precision.EPSILON);
                return new Pair((Object)new ArrayRealVector(new double[]{3.0, 4.0}), (Object)MatrixUtils.createRealMatrix((double[][])new double[][]{{5.0, 6.0}, {7.0, 8.0}}));
            }
        }).target(new double[2]).build().evaluate((RealVector)point);
        RealVector residuals = evaluation.getResiduals();
        RealMatrix jacobian = evaluation.getJacobian();
        Assert.assertArrayEquals((double[])evaluation.getPoint().toArray(), (double[])point.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])new double[]{-12.0, -8.0}, (double[])residuals.toArray(), (double)Precision.EPSILON);
        TestUtils.assertEquals("jacobian", jacobian, MatrixUtils.createRealMatrix((double[][])new double[][]{{20.0, 24.0}, {14.0, 16.0}}), Precision.EPSILON);
    }

    @Test
    public void testComputeCost() throws IOException {
        StatisticalReferenceDataset dataset = StatisticalReferenceDatasetFactory.createKirby2();
        LeastSquaresProblem lsp = this.builder(dataset).build();
        double expected = dataset.getResidualSumOfSquares();
        double cost = lsp.evaluate(lsp.getStart()).getCost();
        double actual = cost * cost;
        Assert.assertEquals((String)dataset.getName(), (double)expected, (double)actual, (double)(1.0E-11 * expected));
    }

    @Test
    public void testComputeRMS() throws IOException {
        StatisticalReferenceDataset dataset = StatisticalReferenceDatasetFactory.createKirby2();
        LeastSquaresProblem lsp = this.builder(dataset).build();
        double expected = FastMath.sqrt((double)(dataset.getResidualSumOfSquares() / (double)dataset.getNumObservations()));
        double actual = lsp.evaluate(lsp.getStart()).getRMS();
        Assert.assertEquals((String)dataset.getName(), (double)expected, (double)actual, (double)(1.0E-11 * expected));
    }

    @Test
    public void testComputeSigma() throws IOException {
        StatisticalReferenceDataset dataset = StatisticalReferenceDatasetFactory.createKirby2();
        LeastSquaresProblem lsp = this.builder(dataset).build();
        double[] expected = dataset.getParametersStandardDeviations();
        LeastSquaresProblem.Evaluation evaluation = lsp.evaluate(lsp.getStart());
        double cost = evaluation.getCost();
        RealVector sig = evaluation.getSigma(1.0E-14);
        int dof = lsp.getObservationSize() - lsp.getParameterSize();
        for (int i = 0; i < sig.getDimension(); ++i) {
            double actual = FastMath.sqrt((double)(cost * cost / (double)dof)) * sig.getEntry(i);
            Assert.assertEquals((String)(dataset.getName() + ", parameter #" + i), (double)expected[i], (double)actual, (double)(1.0E-6 * expected[i]));
        }
    }

    @Test
    public void testEvaluateCopiesPoint() throws IOException {
        StatisticalReferenceDataset dataset = StatisticalReferenceDatasetFactory.createKirby2();
        LeastSquaresProblem lsp = this.builder(dataset).build();
        ArrayRealVector point = new ArrayRealVector(lsp.getParameterSize());
        LeastSquaresProblem.Evaluation evaluation = lsp.evaluate((RealVector)point);
        Assert.assertNotSame((Object)point, (Object)evaluation.getPoint());
        point.setEntry(0, 1.0);
        Assert.assertEquals((double)evaluation.getPoint().getEntry(0), (double)0.0, (double)0.0);
    }

    @Test
    public void testLazyEvaluation() {
        ArrayRealVector dummy = new ArrayRealVector(new double[]{0.0});
        LeastSquaresProblem p = LeastSquaresFactory.create((MultivariateJacobianFunction)LeastSquaresFactory.model((MultivariateVectorFunction)this.dummyModel(), (MultivariateMatrixFunction)this.dummyJacobian()), (RealVector)dummy, (RealVector)dummy, null, null, (int)0, (int)0, (boolean)true, null);
        LeastSquaresProblem.Evaluation eval = p.evaluate((RealVector)dummy);
        try {
            eval.getResiduals();
            Assert.fail((String)"Exception expected");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"dummyModel", (Object)e.getMessage());
        }
        try {
            eval.getJacobian();
            Assert.fail((String)"Exception expected");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"dummyJacobian", (Object)e.getMessage());
        }
    }

    @Test
    public void testLazyEvaluationPrecondition() {
        ArrayRealVector dummy = new ArrayRealVector(new double[]{0.0});
        MultivariateJacobianFunction m1 = new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector notUsed) {
                return new Pair(null, null);
            }
        };
        try {
            LeastSquaresFactory.create((MultivariateJacobianFunction)m1, (RealVector)dummy, (RealVector)dummy, null, null, (int)0, (int)0, (boolean)true, null);
            Assert.fail((String)"Expecting MathIllegalStateException");
        }
        catch (MathIllegalStateException mathIllegalStateException) {
            // empty catch block
        }
        ValueAndJacobianFunction m2 = new ValueAndJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector notUsed) {
                return new Pair(null, null);
            }

            public RealVector computeValue(double[] params) {
                return null;
            }

            public RealMatrix computeJacobian(double[] params) {
                return null;
            }
        };
        LeastSquaresFactory.create((MultivariateJacobianFunction)m2, (RealVector)dummy, (RealVector)dummy, null, null, (int)0, (int)0, (boolean)true, null);
    }

    @Test
    public void testDirectEvaluation() {
        ArrayRealVector dummy = new ArrayRealVector(new double[]{0.0});
        LeastSquaresProblem p = LeastSquaresFactory.create((MultivariateJacobianFunction)LeastSquaresFactory.model((MultivariateVectorFunction)this.dummyModel(), (MultivariateMatrixFunction)this.dummyJacobian()), (RealVector)dummy, (RealVector)dummy, null, null, (int)0, (int)0, (boolean)false, null);
        try {
            p.evaluate((RealVector)dummy);
            Assert.fail((String)"Exception expected");
        }
        catch (RuntimeException e) {
            String msg = e.getMessage();
            Assert.assertTrue((msg.equals("dummyModel") || msg.equals("dummyJacobian") ? 1 : 0) != 0);
        }
    }

    private MultivariateVectorFunction dummyModel() {
        return new MultivariateVectorFunction(){

            public double[] value(double[] p) {
                throw new RuntimeException("dummyModel");
            }
        };
    }

    private MultivariateMatrixFunction dummyJacobian() {
        return new MultivariateMatrixFunction(){

            public double[][] value(double[] p) {
                throw new RuntimeException("dummyJacobian");
            }
        };
    }
}

