/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares;

import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.EvaluationRmsChecker;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import org.junit.Assert;
import org.junit.Test;

public class EvaluationRmsCheckerTest {
    @Test
    public void testConverged() {
        EvaluationRmsChecker checker = new EvaluationRmsChecker(0.1, 1.0);
        LeastSquaresProblem.Evaluation e200 = EvaluationRmsCheckerTest.mockEvaluation(200.0);
        LeastSquaresProblem.Evaluation e1 = EvaluationRmsCheckerTest.mockEvaluation(1.0);
        Assert.assertEquals((Object)true, (Object)checker.converged(0, (Object)e200, (Object)EvaluationRmsCheckerTest.mockEvaluation(210.0)));
        Assert.assertEquals((Object)true, (Object)checker.converged(0, (Object)e1, (Object)EvaluationRmsCheckerTest.mockEvaluation(1.9)));
        Assert.assertEquals((Object)true, (Object)checker.converged(0, (Object)e1, (Object)EvaluationRmsCheckerTest.mockEvaluation(1.01)));
        Assert.assertEquals((Object)false, (Object)checker.converged(0, (Object)e200, (Object)EvaluationRmsCheckerTest.mockEvaluation(300.0)));
    }

    private static LeastSquaresProblem.Evaluation mockEvaluation(final double rms) {
        return new LeastSquaresProblem.Evaluation(){

            public RealMatrix getCovariances(double threshold) {
                return null;
            }

            public RealVector getSigma(double covarianceSingularityThreshold) {
                return null;
            }

            public double getRMS() {
                return rms;
            }

            public RealMatrix getJacobian() {
                return null;
            }

            public double getCost() {
                return 0.0;
            }

            public RealVector getResiduals() {
                return null;
            }

            public RealVector getPoint() {
                return null;
            }
        };
    }
}

