/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fitting;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.SimpleCurveFitter;
import com.hazelcast.shaded.org.apache.commons.math3.fitting.WeightedObservedPoints;
import java.util.Collection;
import java.util.Random;
import org.junit.Test;

public class SimpleCurveFitterTest {
    @Test
    public void testPolynomialFit() {
        Random randomizer = new Random(53882150042L);
        UniformRealDistribution rng = new UniformRealDistribution(-100.0, 100.0);
        rng.reseedRandomGenerator(64925784252L);
        double[] coeff = new double[]{12.9, -3.4, 2.1};
        PolynomialFunction f = new PolynomialFunction(coeff);
        WeightedObservedPoints obs = new WeightedObservedPoints();
        for (int i = 0; i < 100; ++i) {
            double x = rng.sample();
            obs.add(x, f.value(x) + 0.1 * randomizer.nextGaussian());
        }
        PolynomialFunction.Parametric function = new PolynomialFunction.Parametric();
        SimpleCurveFitter fitter = SimpleCurveFitter.create((ParametricUnivariateFunction)function, (double[])new double[]{-1.0E20, 3.0E15, -5.0E25});
        double[] best = fitter.fit((Collection)obs.toList());
        TestUtils.assertEquals("best != coeff", coeff, best, 0.02);
    }
}

