/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.junit.Assert;
import org.junit.Test;

public class UniformRealDistributionTest
extends RealDistributionAbstractTest {
    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-4);
    }

    public UniformRealDistribution makeDistribution() {
        return new UniformRealDistribution(-0.5, 1.25);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-0.5001, -0.5, -0.4999, -0.25, -1.0E-4, 0.0, 1.0E-4, 0.25, 1.0, 1.2499, 1.25, 1.2501};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.0, 1.0E-4, 0.14285714285714285, 0.2856571428571429, 0.2857142857142857, 0.28577142857142857, 0.42857142857142855, 0.8571428571428571, 0.9999428571428571, 1.0, 1.0};
    }

    public double[] makeDensityTestValues() {
        double d = 0.5714285714285714;
        return new double[]{0.0, d, d, d, d, d, d, d, d, d, d, 0.0};
    }

    @Test
    public void testGetLowerBound() {
        UniformRealDistribution distribution = this.makeDistribution();
        Assert.assertEquals((double)-0.5, (double)distribution.getSupportLowerBound(), (double)0.0);
    }

    @Test
    public void testGetUpperBound() {
        UniformRealDistribution distribution = this.makeDistribution();
        Assert.assertEquals((double)1.25, (double)distribution.getSupportUpperBound(), (double)0.0);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testPreconditions1() {
        new UniformRealDistribution(0.0, 0.0);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testPreconditions2() {
        new UniformRealDistribution(1.0, 0.0);
    }

    @Test
    public void testMeanVariance() {
        UniformRealDistribution dist = new UniformRealDistribution(0.0, 1.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.5, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.08333333333333333, (double)0.0);
        dist = new UniformRealDistribution(-1.5, 0.6);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)-0.45, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.3675, (double)0.0);
        dist = new UniformRealDistribution(-0.5, 1.25);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.375, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.2552083333333333, (double)0.0);
    }

    @Test
    public void testInverseCumulativeDistribution() {
        UniformRealDistribution dist = new UniformRealDistribution(0.0, 1.0E-9);
        Assert.assertEquals((double)2.5E-10, (double)dist.inverseCumulativeProbability(0.25), (double)0.0);
    }
}

