/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.LogNormalDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.junit.Assert;
import org.junit.Test;

public class LogNormalDistributionTest
extends RealDistributionAbstractTest {
    public LogNormalDistribution makeDistribution() {
        return new LogNormalDistribution(2.1, 1.4);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-2.226325228634938, -1.156887023657177, -0.643949578356075, -0.2027950777320613, 0.305827808237559, 6.42632522863494, 5.35688702365718, 4.843949578356074, 4.40279507773206, 3.89417219176244};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.00948199951485, 0.432056525076, 0.381648158697, 0.354555726206, 0.329513316888, 0.298422824228};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.0, 0.0, 0.0, 0.0594218160072, 0.0436977691036, 0.0508364857798, 0.054873528325, 0.0587182664085, 0.0636229042785};
    }

    public double[] makeInverseCumulativeTestPoints() {
        double[] points = this.makeCumulativeTestValues();
        double[] points2 = new double[points.length - 4];
        System.arraycopy(points, 4, points2, 0, points2.length - 4);
        return points2;
    }

    public double[] makeInverseCumulativeTestValues() {
        double[] points = this.makeCumulativeTestPoints();
        double[] points2 = new double[points.length - 4];
        System.arraycopy(points, 4, points2, 0, points2.length - 4);
        return points2;
    }

    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-9);
    }

    private void verifyQuantiles() {
        LogNormalDistribution distribution = (LogNormalDistribution)this.getDistribution();
        double mu = distribution.getScale();
        double sigma = distribution.getShape();
        this.setCumulativeTestPoints(new double[]{mu - 2.0 * sigma, mu - sigma, mu, mu + sigma, mu + 2.0 * sigma, mu + 3.0 * sigma, mu + 4.0 * sigma, mu + 5.0 * sigma});
        this.verifyCumulativeProbabilities();
    }

    @Test
    public void testQuantiles() {
        this.setCumulativeTestValues(new double[]{0.0, 0.0396495152787, 0.16601209243, 0.272533253269, 0.357618409638, 0.426488363093, 0.483255136841, 0.530823013877});
        this.setDensityTestValues(new double[]{0.0, 0.0873055825147, 0.0847676303432, 0.0677935186237, 0.0544105523058, 0.0444614628804, 0.0369750288945, 0.0312206409653});
        this.verifyQuantiles();
        this.verifyDensities();
        this.setDistribution((RealDistribution)new LogNormalDistribution(0.0, 1.0));
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 0.5, 0.755891404214, 0.864031392359, 0.917171480998, 0.946239689548});
        this.setDensityTestValues(new double[]{0.0, 0.0, 0.0, 0.398942280401, 0.156874019279, 0.07272825614, 0.0381534565119, 0.0218507148303});
        this.verifyQuantiles();
        this.verifyDensities();
        this.setDistribution((RealDistribution)new LogNormalDistribution(0.0, 0.1));
        this.setCumulativeTestValues(new double[]{0.0, 0.0, 0.0, 1.28417563064E-117, 1.39679883412E-58, 1.09839325447E-33, 2.52587961726E-20, 2.0824223487E-12});
        this.setDensityTestValues(new double[]{0.0, 0.0, 0.0, 2.96247992535E-114, 1.1283370232E-55, 4.43812313223E-31, 5.85346445002E-18, 2.9446618076E-10});
        this.verifyQuantiles();
        this.verifyDensities();
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{0.0, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testGetScale() {
        LogNormalDistribution distribution = (LogNormalDistribution)this.getDistribution();
        Assert.assertEquals((double)2.1, (double)distribution.getScale(), (double)0.0);
    }

    @Test
    public void testGetShape() {
        LogNormalDistribution distribution = (LogNormalDistribution)this.getDistribution();
        Assert.assertEquals((double)1.4, (double)distribution.getShape(), (double)0.0);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions() {
        new LogNormalDistribution(1.0, 0.0);
    }

    @Test
    public void testDensity() {
        double[] x = new double[]{-2.0, -1.0, 0.0, 1.0, 2.0};
        this.checkDensity(0.0, 1.0, x, new double[]{0.0, 0.0, 0.0, 0.3989422804, 0.1568740193});
        this.checkDensity(1.1, 1.0, x, new double[]{0.0, 0.0, 0.0, 0.217852177, 0.1836267118});
    }

    private void checkDensity(double scale, double shape, double[] x, double[] expected) {
        LogNormalDistribution d = new LogNormalDistribution(scale, shape);
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)d.density(x[i]), (double)1.0E-9);
        }
    }

    @Test
    public void testExtremeValues() {
        LogNormalDistribution d = new LogNormalDistribution(0.0, 1.0);
        int i = 0;
        while ((double)i < 100000.0) {
            double upperTail = d.cumulativeProbability((double)i);
            if (i <= 72) {
                Assert.assertTrue((upperTail < 1.0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((upperTail > 0.99999 ? 1 : 0) != 0);
            }
            ++i;
        }
        Assert.assertEquals((double)d.cumulativeProbability(Double.MAX_VALUE), (double)1.0, (double)0.0);
        Assert.assertEquals((double)d.cumulativeProbability(-1.7976931348623157E308), (double)0.0, (double)0.0);
        Assert.assertEquals((double)d.cumulativeProbability(Double.POSITIVE_INFINITY), (double)1.0, (double)0.0);
        Assert.assertEquals((double)d.cumulativeProbability(Double.NEGATIVE_INFINITY), (double)0.0, (double)0.0);
    }

    @Test
    public void testMeanVariance() {
        double tol = 1.0E-9;
        LogNormalDistribution dist = new LogNormalDistribution(0.0, 1.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)1.6487212707001282, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)4.670774270471604, (double)1.0E-9);
        dist = new LogNormalDistribution(2.2, 1.4);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)24.046753552064498, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)3526.913651880464, (double)1.0E-9);
        dist = new LogNormalDistribution(-2000.9, 10.4);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.0, (double)1.0E-9);
    }

    @Test
    public void testTinyVariance() {
        LogNormalDistribution dist = new LogNormalDistribution(0.0, 1.0E-9);
        double t = dist.getNumericalVariance();
        Assert.assertEquals((double)1.0E-18, (double)t, (double)1.0E-20);
    }
}

