/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.ExponentialDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class ExponentialDistributionTest
extends RealDistributionAbstractTest {
    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-9);
    }

    public ExponentialDistribution makeDistribution() {
        return new ExponentialDistribution(5.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{0.00500250166792, 0.0502516792675, 0.126589039921, 0.256466471938, 0.526802578289, 34.5387763949, 23.0258509299, 18.4443972706, 14.9786613678, 11.512925465};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.1998, 0.198, 0.195, 0.19, 0.18, 2.0E-4, 0.00200000000002, 0.00499999999997, 0.00999999999994, 0.0199999999999};
    }

    @Test
    public void testCumulativeProbabilityExtremes() {
        this.setCumulativeTestPoints(new double[]{-2.0, 0.0});
        this.setCumulativeTestValues(new double[]{0.0, 0.0});
        this.verifyCumulativeProbabilities();
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{0.0, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testCumulativeProbability2() {
        double actual = this.getDistribution().cumulativeProbability(0.25, 0.75);
        Assert.assertEquals((double)0.0905214, (double)actual, (double)0.001);
    }

    @Test
    public void testDensity() {
        ExponentialDistribution d1 = new ExponentialDistribution(1.0);
        Assert.assertTrue((boolean)Precision.equals((double)0.0, (double)d1.density(-1.0E-9), (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)1.0, (double)d1.density(0.0), (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)0.0, (double)d1.density(1000.0), (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)FastMath.exp((double)-1.0), (double)d1.density(1.0), (int)1));
        Assert.assertTrue((boolean)Precision.equals((double)FastMath.exp((double)-2.0), (double)d1.density(2.0), (int)1));
        ExponentialDistribution d2 = new ExponentialDistribution(3.0);
        Assert.assertTrue((boolean)Precision.equals((double)0.3333333333333333, (double)d2.density(0.0), (int)1));
        Assert.assertEquals((double)0.2388437702, (double)d2.density(1.0), (double)1.0E-8);
        Assert.assertEquals((double)0.1711390397, (double)d2.density(2.0), (double)1.0E-8);
    }

    @Test
    public void testMeanAccessors() {
        ExponentialDistribution distribution = (ExponentialDistribution)this.getDistribution();
        Assert.assertEquals((double)5.0, (double)distribution.getMean(), (double)Double.MIN_VALUE);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions() {
        new ExponentialDistribution(0.0);
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        ExponentialDistribution dist = new ExponentialDistribution(11.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)11.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)121.0, (double)1.0E-9);
        dist = new ExponentialDistribution(10.5);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)10.5, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)110.25, (double)1.0E-9);
    }
}

