/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.EnumeratedIntegerDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotANumberException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotFiniteNumberException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class EnumeratedIntegerDistributionTest {
    private final EnumeratedIntegerDistribution testDistribution = new EnumeratedIntegerDistribution(new int[]{3, -1, 3, 7, -2, 8}, new double[]{0.2, 0.2, 0.3, 0.3, 0.0, 0.0});

    @Test
    public void testExceptions() {
        Object invalid = null;
        try {
            new EnumeratedIntegerDistribution(new int[]{1, 2}, new double[]{0.0});
            Assert.fail((String)"Expected DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            new EnumeratedIntegerDistribution(new int[]{1, 2}, new double[]{0.0, -1.0});
            Assert.fail((String)"Expected NotPositiveException");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
        try {
            new EnumeratedIntegerDistribution(new int[]{1, 2}, new double[]{0.0, 0.0});
            Assert.fail((String)"Expected MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            new EnumeratedIntegerDistribution(new int[]{1, 2}, new double[]{0.0, Double.NaN});
            Assert.fail((String)"Expected NotANumberException");
        }
        catch (NotANumberException notANumberException) {
            // empty catch block
        }
        try {
            new EnumeratedIntegerDistribution(new int[]{1, 2}, new double[]{0.0, Double.POSITIVE_INFINITY});
            Assert.fail((String)"Expected NotFiniteNumberException");
        }
        catch (NotFiniteNumberException notFiniteNumberException) {
            // empty catch block
        }
        Assert.assertNull((String)"Expected non-initialized DiscreteRealDistribution", invalid);
    }

    @Test
    public void testProbability() {
        int[] points = new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8};
        double[] results = new double[]{0.0, 0.2, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.3, 0.0};
        for (int p = 0; p < points.length; ++p) {
            double probability = this.testDistribution.probability(points[p]);
            Assert.assertEquals((double)results[p], (double)probability, (double)0.0);
        }
    }

    @Test
    public void testCumulativeProbability() {
        int[] points = new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8};
        double[] results = new double[]{0.0, 0.2, 0.2, 0.2, 0.2, 0.7, 0.7, 0.7, 0.7, 1.0, 1.0};
        for (int p = 0; p < points.length; ++p) {
            double probability = this.testDistribution.cumulativeProbability(points[p]);
            Assert.assertEquals((double)results[p], (double)probability, (double)1.0E-10);
        }
    }

    @Test
    public void testGetNumericalMean() {
        Assert.assertEquals((double)3.4, (double)this.testDistribution.getNumericalMean(), (double)1.0E-10);
    }

    @Test
    public void testGetNumericalVariance() {
        Assert.assertEquals((double)7.84, (double)this.testDistribution.getNumericalVariance(), (double)1.0E-10);
    }

    @Test
    public void testGetSupportLowerBound() {
        Assert.assertEquals((long)-1L, (long)this.testDistribution.getSupportLowerBound());
    }

    @Test
    public void testGetSupportUpperBound() {
        Assert.assertEquals((long)7L, (long)this.testDistribution.getSupportUpperBound());
    }

    @Test
    public void testIsSupportConnected() {
        Assert.assertTrue((boolean)this.testDistribution.isSupportConnected());
    }

    @Test
    public void testSample() {
        int n = 1000000;
        this.testDistribution.reseedRandomGenerator(-334759360L);
        int[] samples = this.testDistribution.sample(1000000);
        Assert.assertEquals((long)1000000L, (long)samples.length);
        double sum = 0.0;
        double sumOfSquares = 0.0;
        for (int i = 0; i < samples.length; ++i) {
            sum += (double)samples[i];
            sumOfSquares += (double)(samples[i] * samples[i]);
        }
        Assert.assertEquals((double)this.testDistribution.getNumericalMean(), (double)(sum / 1000000.0), (double)0.01);
        Assert.assertEquals((double)this.testDistribution.getNumericalVariance(), (double)(sumOfSquares / 1000000.0 - FastMath.pow((double)(sum / 1000000.0), (int)2)), (double)0.01);
    }

    @Test
    public void testCreateFromIntegers() {
        int[] data = new int[]{0, 1, 1, 2, 2, 2};
        EnumeratedIntegerDistribution distribution = new EnumeratedIntegerDistribution(data);
        Assert.assertEquals((double)0.5, (double)distribution.probability(2), (double)Precision.EPSILON);
        Assert.assertEquals((double)0.5, (double)distribution.cumulativeProbability(1), (double)Precision.EPSILON);
    }
}

