/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.junit.Assert;
import org.junit.Test;

public class AbstractIntegerDistributionTest {
    protected final DiceDistribution diceDistribution = new DiceDistribution();
    protected final double p = this.diceDistribution.probability(1);

    @Test
    public void testInverseCumulativeProbabilityMethod() {
        double precision = 1.0E-15;
        Assert.assertEquals((long)1L, (long)this.diceDistribution.inverseCumulativeProbability(0.0));
        Assert.assertEquals((long)1L, (long)this.diceDistribution.inverseCumulativeProbability(0.16666666666666666));
        Assert.assertEquals((long)2L, (long)this.diceDistribution.inverseCumulativeProbability((1.0 + precision) / 6.0));
        Assert.assertEquals((long)2L, (long)this.diceDistribution.inverseCumulativeProbability(0.3333333333333333));
        Assert.assertEquals((long)3L, (long)this.diceDistribution.inverseCumulativeProbability((2.0 + precision) / 6.0));
        Assert.assertEquals((long)3L, (long)this.diceDistribution.inverseCumulativeProbability(0.5));
        Assert.assertEquals((long)4L, (long)this.diceDistribution.inverseCumulativeProbability((3.0 + precision) / 6.0));
        Assert.assertEquals((long)4L, (long)this.diceDistribution.inverseCumulativeProbability(0.6666666666666666));
        Assert.assertEquals((long)5L, (long)this.diceDistribution.inverseCumulativeProbability((4.0 + precision) / 6.0));
        Assert.assertEquals((long)5L, (long)this.diceDistribution.inverseCumulativeProbability((5.0 - precision) / 6.0));
        Assert.assertEquals((long)6L, (long)this.diceDistribution.inverseCumulativeProbability((5.0 + precision) / 6.0));
        Assert.assertEquals((long)6L, (long)this.diceDistribution.inverseCumulativeProbability((6.0 - precision) / 6.0));
        Assert.assertEquals((long)6L, (long)this.diceDistribution.inverseCumulativeProbability(1.0));
    }

    @Test
    public void testCumulativeProbabilitiesSingleArguments() {
        for (int i = 1; i < 7; ++i) {
            Assert.assertEquals((double)(this.p * (double)i), (double)this.diceDistribution.cumulativeProbability(i), (double)Double.MIN_VALUE);
        }
        Assert.assertEquals((double)0.0, (double)this.diceDistribution.cumulativeProbability(0), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)this.diceDistribution.cumulativeProbability(7), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCumulativeProbabilitiesRangeArguments() {
        int i;
        int lower = 0;
        int upper = 6;
        for (i = 0; i < 2; ++i) {
            Assert.assertEquals((double)(1.0 - this.p * 2.0 * (double)i), (double)this.diceDistribution.cumulativeProbability(lower, upper), (double)1.0E-12);
            ++lower;
            --upper;
        }
        for (i = 0; i < 6; ++i) {
            Assert.assertEquals((double)this.p, (double)this.diceDistribution.cumulativeProbability(i, i + 1), (double)1.0E-12);
        }
    }

    class DiceDistribution
    extends AbstractIntegerDistribution {
        public static final long serialVersionUID = 23734213L;
        private final double p = 0.16666666666666666;

        public DiceDistribution() {
            super(null);
            this.p = 0.16666666666666666;
        }

        public double probability(int x) {
            if (x < 1 || x > 6) {
                return 0.0;
            }
            return 0.16666666666666666;
        }

        public double cumulativeProbability(int x) {
            if (x < 1) {
                return 0.0;
            }
            if (x >= 6) {
                return 1.0;
            }
            return 0.16666666666666666 * (double)x;
        }

        public double getNumericalMean() {
            return 3.5;
        }

        public double getNumericalVariance() {
            return 2.0;
        }

        public int getSupportLowerBound() {
            return 1;
        }

        public int getSupportUpperBound() {
            return 6;
        }

        public final boolean isSupportConnected() {
            return true;
        }
    }
}

