/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.dfp;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.AllowedSolution;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.BracketingNthOrderBrentSolverDFP;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.Dfp;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.DfpField;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.DfpMath;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.UnivariateDfpFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathInternalError;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public final class BracketingNthOrderBrentSolverDFPTest {
    private DfpField field;
    private Dfp absoluteAccuracy;
    private Dfp relativeAccuracy;
    private Dfp functionValueAccuracy;

    @Test(expected=NumberIsTooSmallException.class)
    public void testInsufficientOrder3() {
        new BracketingNthOrderBrentSolverDFP(this.relativeAccuracy, this.absoluteAccuracy, this.functionValueAccuracy, 1);
    }

    @Test
    public void testConstructorOK() {
        BracketingNthOrderBrentSolverDFP solver = new BracketingNthOrderBrentSolverDFP(this.relativeAccuracy, this.absoluteAccuracy, this.functionValueAccuracy, 2);
        Assert.assertEquals((long)2L, (long)solver.getMaximalOrder());
    }

    @Test
    public void testConvergenceOnFunctionAccuracy() {
        BracketingNthOrderBrentSolverDFP solver = new BracketingNthOrderBrentSolverDFP(this.relativeAccuracy, this.absoluteAccuracy, this.field.newDfp(1.0E-20), 20);
        UnivariateDfpFunction f = new UnivariateDfpFunction(){

            public Dfp value(Dfp x) {
                Dfp one = BracketingNthOrderBrentSolverDFPTest.this.field.getOne();
                Dfp oneHalf = one.divide(2);
                Dfp xMo = x.subtract(one);
                Dfp xMh = x.subtract(oneHalf);
                Dfp xPh = x.add(oneHalf);
                Dfp xPo = x.add(one);
                return xMo.multiply(xMh).multiply(x).multiply(xPh).multiply(xPo);
            }
        };
        Dfp result = solver.solve(20, f, this.field.newDfp(0.2), this.field.newDfp(0.9), this.field.newDfp(0.4), AllowedSolution.BELOW_SIDE);
        Assert.assertTrue((boolean)f.value(result).abs().lessThan(solver.getFunctionValueAccuracy()));
        Assert.assertTrue((boolean)f.value(result).negativeOrNull());
        Assert.assertTrue((boolean)result.subtract(this.field.newDfp(0.5)).subtract(solver.getAbsoluteAccuracy()).positiveOrNull());
        result = solver.solve(20, f, this.field.newDfp(-0.9), this.field.newDfp(-0.2), this.field.newDfp(-0.4), AllowedSolution.ABOVE_SIDE);
        Assert.assertTrue((boolean)f.value(result).abs().lessThan(solver.getFunctionValueAccuracy()));
        Assert.assertTrue((boolean)f.value(result).positiveOrNull());
        Assert.assertTrue((boolean)result.add(this.field.newDfp(0.5)).subtract(solver.getAbsoluteAccuracy()).negativeOrNull());
    }

    @Test
    public void testNeta() {
        for (AllowedSolution allowed : AllowedSolution.values()) {
            this.check(new UnivariateDfpFunction(){

                public Dfp value(Dfp x) {
                    return DfpMath.sin((Dfp)x).subtract(x.divide(2));
                }
            }, 200, -2.0, 2.0, allowed);
            this.check(new UnivariateDfpFunction(){

                public Dfp value(Dfp x) {
                    return DfpMath.pow((Dfp)x, (int)5).add(x).subtract(BracketingNthOrderBrentSolverDFPTest.this.field.newDfp(10000));
                }
            }, 200, -5.0, 10.0, allowed);
            this.check(new UnivariateDfpFunction(){

                public Dfp value(Dfp x) {
                    return x.sqrt().subtract(BracketingNthOrderBrentSolverDFPTest.this.field.getOne().divide(x)).subtract(BracketingNthOrderBrentSolverDFPTest.this.field.newDfp(3));
                }
            }, 200, 0.001, 10.0, allowed);
            this.check(new UnivariateDfpFunction(){

                public Dfp value(Dfp x) {
                    return DfpMath.exp((Dfp)x).add(x).subtract(BracketingNthOrderBrentSolverDFPTest.this.field.newDfp(20));
                }
            }, 200, -5.0, 5.0, allowed);
            this.check(new UnivariateDfpFunction(){

                public Dfp value(Dfp x) {
                    return DfpMath.log((Dfp)x).add(x.sqrt()).subtract(BracketingNthOrderBrentSolverDFPTest.this.field.newDfp(5));
                }
            }, 200, 0.001, 10.0, allowed);
            this.check(new UnivariateDfpFunction(){

                public Dfp value(Dfp x) {
                    return x.subtract(BracketingNthOrderBrentSolverDFPTest.this.field.getOne()).multiply(x).multiply(x).subtract(BracketingNthOrderBrentSolverDFPTest.this.field.getOne());
                }
            }, 200, -0.5, 1.5, allowed);
        }
    }

    private void check(UnivariateDfpFunction f, int maxEval, double min, double max, AllowedSolution allowedSolution) {
        BracketingNthOrderBrentSolverDFP solver = new BracketingNthOrderBrentSolverDFP(this.relativeAccuracy, this.absoluteAccuracy, this.functionValueAccuracy, 20);
        Dfp xResult = solver.solve(maxEval, f, this.field.newDfp(min), this.field.newDfp(max), allowedSolution);
        Dfp yResult = f.value(xResult);
        switch (allowedSolution) {
            case ANY_SIDE: {
                Assert.assertTrue((boolean)yResult.abs().lessThan(this.functionValueAccuracy.multiply(2)));
                break;
            }
            case LEFT_SIDE: {
                boolean increasing = f.value(xResult).add(this.absoluteAccuracy).greaterThan(yResult);
                Assert.assertTrue((boolean)(increasing ? yResult.negativeOrNull() : yResult.positiveOrNull()));
                break;
            }
            case RIGHT_SIDE: {
                boolean increasing = f.value(xResult).add(this.absoluteAccuracy).greaterThan(yResult);
                Assert.assertTrue((boolean)(increasing ? yResult.positiveOrNull() : yResult.negativeOrNull()));
                break;
            }
            case BELOW_SIDE: {
                Assert.assertTrue((boolean)yResult.negativeOrNull());
                break;
            }
            case ABOVE_SIDE: {
                Assert.assertTrue((boolean)yResult.positiveOrNull());
                break;
            }
            default: {
                throw new MathInternalError(null);
            }
        }
    }

    @Before
    public void setUp() {
        this.field = new DfpField(50);
        this.absoluteAccuracy = this.field.newDfp(1.0E-45);
        this.relativeAccuracy = this.field.newDfp(1.0E-45);
        this.functionValueAccuracy = this.field.newDfp(1.0E-45);
    }
}

