/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.IterativeLegendreGaussIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialsUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.CombinatoricsUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class PolynomialsUtilsTest {
    @Test
    public void testFirstChebyshevPolynomials() {
        this.checkPolynomial(PolynomialsUtils.createChebyshevPolynomial((int)3), "-3 x + 4 x^3");
        this.checkPolynomial(PolynomialsUtils.createChebyshevPolynomial((int)2), "-1 + 2 x^2");
        this.checkPolynomial(PolynomialsUtils.createChebyshevPolynomial((int)1), "x");
        this.checkPolynomial(PolynomialsUtils.createChebyshevPolynomial((int)0), "1");
        this.checkPolynomial(PolynomialsUtils.createChebyshevPolynomial((int)7), "-7 x + 56 x^3 - 112 x^5 + 64 x^7");
        this.checkPolynomial(PolynomialsUtils.createChebyshevPolynomial((int)6), "-1 + 18 x^2 - 48 x^4 + 32 x^6");
        this.checkPolynomial(PolynomialsUtils.createChebyshevPolynomial((int)5), "5 x - 20 x^3 + 16 x^5");
        this.checkPolynomial(PolynomialsUtils.createChebyshevPolynomial((int)4), "1 - 8 x^2 + 8 x^4");
    }

    @Test
    public void testChebyshevBounds() {
        for (int k = 0; k < 12; ++k) {
            PolynomialFunction Tk = PolynomialsUtils.createChebyshevPolynomial((int)k);
            for (double x = -1.0; x <= 1.0; x += 0.02) {
                Assert.assertTrue((String)(k + " " + Tk.value(x)), (FastMath.abs((double)Tk.value(x)) < 1.000000000001 ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testChebyshevDifferentials() {
        for (int k = 0; k < 12; ++k) {
            PolynomialFunction Tk0 = PolynomialsUtils.createChebyshevPolynomial((int)k);
            PolynomialFunction Tk1 = Tk0.polynomialDerivative();
            PolynomialFunction Tk2 = Tk1.polynomialDerivative();
            PolynomialFunction g0 = new PolynomialFunction(new double[]{k * k});
            PolynomialFunction g1 = new PolynomialFunction(new double[]{0.0, -1.0});
            PolynomialFunction g2 = new PolynomialFunction(new double[]{1.0, 0.0, -1.0});
            PolynomialFunction Tk0g0 = Tk0.multiply(g0);
            PolynomialFunction Tk1g1 = Tk1.multiply(g1);
            PolynomialFunction Tk2g2 = Tk2.multiply(g2);
            this.checkNullPolynomial(Tk0g0.add(Tk1g1.add(Tk2g2)));
        }
    }

    @Test
    public void testChebyshevOrthogonality() {
        UnivariateFunction weight = new UnivariateFunction(){

            public double value(double x) {
                return 1.0 / FastMath.sqrt((double)(1.0 - x * x));
            }
        };
        for (int i = 0; i < 10; ++i) {
            PolynomialFunction pi = PolynomialsUtils.createChebyshevPolynomial((int)i);
            for (int j = 0; j <= i; ++j) {
                PolynomialFunction pj = PolynomialsUtils.createChebyshevPolynomial((int)j);
                this.checkOrthogonality(pi, pj, weight, -0.9999, 0.9999, 1.5, 0.03);
            }
        }
    }

    @Test
    public void testFirstHermitePolynomials() {
        this.checkPolynomial(PolynomialsUtils.createHermitePolynomial((int)3), "-12 x + 8 x^3");
        this.checkPolynomial(PolynomialsUtils.createHermitePolynomial((int)2), "-2 + 4 x^2");
        this.checkPolynomial(PolynomialsUtils.createHermitePolynomial((int)1), "2 x");
        this.checkPolynomial(PolynomialsUtils.createHermitePolynomial((int)0), "1");
        this.checkPolynomial(PolynomialsUtils.createHermitePolynomial((int)7), "-1680 x + 3360 x^3 - 1344 x^5 + 128 x^7");
        this.checkPolynomial(PolynomialsUtils.createHermitePolynomial((int)6), "-120 + 720 x^2 - 480 x^4 + 64 x^6");
        this.checkPolynomial(PolynomialsUtils.createHermitePolynomial((int)5), "120 x - 160 x^3 + 32 x^5");
        this.checkPolynomial(PolynomialsUtils.createHermitePolynomial((int)4), "12 - 48 x^2 + 16 x^4");
    }

    @Test
    public void testHermiteDifferentials() {
        for (int k = 0; k < 12; ++k) {
            PolynomialFunction Hk0 = PolynomialsUtils.createHermitePolynomial((int)k);
            PolynomialFunction Hk1 = Hk0.polynomialDerivative();
            PolynomialFunction Hk2 = Hk1.polynomialDerivative();
            PolynomialFunction g0 = new PolynomialFunction(new double[]{2 * k});
            PolynomialFunction g1 = new PolynomialFunction(new double[]{0.0, -2.0});
            PolynomialFunction g2 = new PolynomialFunction(new double[]{1.0});
            PolynomialFunction Hk0g0 = Hk0.multiply(g0);
            PolynomialFunction Hk1g1 = Hk1.multiply(g1);
            PolynomialFunction Hk2g2 = Hk2.multiply(g2);
            this.checkNullPolynomial(Hk0g0.add(Hk1g1.add(Hk2g2)));
        }
    }

    @Test
    public void testHermiteOrthogonality() {
        UnivariateFunction weight = new UnivariateFunction(){

            public double value(double x) {
                return FastMath.exp((double)(-x * x));
            }
        };
        for (int i = 0; i < 10; ++i) {
            PolynomialFunction pi = PolynomialsUtils.createHermitePolynomial((int)i);
            for (int j = 0; j <= i; ++j) {
                PolynomialFunction pj = PolynomialsUtils.createHermitePolynomial((int)j);
                this.checkOrthogonality(pi, pj, weight, -50.0, 50.0, 1.5, 1.0E-8);
            }
        }
    }

    @Test
    public void testFirstLaguerrePolynomials() {
        this.checkPolynomial(PolynomialsUtils.createLaguerrePolynomial((int)3), 6L, "6 - 18 x + 9 x^2 - x^3");
        this.checkPolynomial(PolynomialsUtils.createLaguerrePolynomial((int)2), 2L, "2 - 4 x + x^2");
        this.checkPolynomial(PolynomialsUtils.createLaguerrePolynomial((int)1), 1L, "1 - x");
        this.checkPolynomial(PolynomialsUtils.createLaguerrePolynomial((int)0), 1L, "1");
        this.checkPolynomial(PolynomialsUtils.createLaguerrePolynomial((int)7), 5040L, "5040 - 35280 x + 52920 x^2 - 29400 x^3 + 7350 x^4 - 882 x^5 + 49 x^6 - x^7");
        this.checkPolynomial(PolynomialsUtils.createLaguerrePolynomial((int)6), 720L, "720 - 4320 x + 5400 x^2 - 2400 x^3 + 450 x^4 - 36 x^5 + x^6");
        this.checkPolynomial(PolynomialsUtils.createLaguerrePolynomial((int)5), 120L, "120 - 600 x + 600 x^2 - 200 x^3 + 25 x^4 - x^5");
        this.checkPolynomial(PolynomialsUtils.createLaguerrePolynomial((int)4), 24L, "24 - 96 x + 72 x^2 - 16 x^3 + x^4");
    }

    @Test
    public void testLaguerreDifferentials() {
        for (int k = 0; k < 12; ++k) {
            PolynomialFunction Lk0 = PolynomialsUtils.createLaguerrePolynomial((int)k);
            PolynomialFunction Lk1 = Lk0.polynomialDerivative();
            PolynomialFunction Lk2 = Lk1.polynomialDerivative();
            PolynomialFunction g0 = new PolynomialFunction(new double[]{k});
            PolynomialFunction g1 = new PolynomialFunction(new double[]{1.0, -1.0});
            PolynomialFunction g2 = new PolynomialFunction(new double[]{0.0, 1.0});
            PolynomialFunction Lk0g0 = Lk0.multiply(g0);
            PolynomialFunction Lk1g1 = Lk1.multiply(g1);
            PolynomialFunction Lk2g2 = Lk2.multiply(g2);
            this.checkNullPolynomial(Lk0g0.add(Lk1g1.add(Lk2g2)));
        }
    }

    @Test
    public void testLaguerreOrthogonality() {
        UnivariateFunction weight = new UnivariateFunction(){

            public double value(double x) {
                return FastMath.exp((double)(-x));
            }
        };
        for (int i = 0; i < 10; ++i) {
            PolynomialFunction pi = PolynomialsUtils.createLaguerrePolynomial((int)i);
            for (int j = 0; j <= i; ++j) {
                PolynomialFunction pj = PolynomialsUtils.createLaguerrePolynomial((int)j);
                this.checkOrthogonality(pi, pj, weight, 0.0, 100.0, 0.99999, 1.0E-13);
            }
        }
    }

    @Test
    public void testFirstLegendrePolynomials() {
        this.checkPolynomial(PolynomialsUtils.createLegendrePolynomial((int)3), 2L, "-3 x + 5 x^3");
        this.checkPolynomial(PolynomialsUtils.createLegendrePolynomial((int)2), 2L, "-1 + 3 x^2");
        this.checkPolynomial(PolynomialsUtils.createLegendrePolynomial((int)1), 1L, "x");
        this.checkPolynomial(PolynomialsUtils.createLegendrePolynomial((int)0), 1L, "1");
        this.checkPolynomial(PolynomialsUtils.createLegendrePolynomial((int)7), 16L, "-35 x + 315 x^3 - 693 x^5 + 429 x^7");
        this.checkPolynomial(PolynomialsUtils.createLegendrePolynomial((int)6), 16L, "-5 + 105 x^2 - 315 x^4 + 231 x^6");
        this.checkPolynomial(PolynomialsUtils.createLegendrePolynomial((int)5), 8L, "15 x - 70 x^3 + 63 x^5");
        this.checkPolynomial(PolynomialsUtils.createLegendrePolynomial((int)4), 8L, "3 - 30 x^2 + 35 x^4");
    }

    @Test
    public void testLegendreDifferentials() {
        for (int k = 0; k < 12; ++k) {
            PolynomialFunction Pk0 = PolynomialsUtils.createLegendrePolynomial((int)k);
            PolynomialFunction Pk1 = Pk0.polynomialDerivative();
            PolynomialFunction Pk2 = Pk1.polynomialDerivative();
            PolynomialFunction g0 = new PolynomialFunction(new double[]{k * (k + 1)});
            PolynomialFunction g1 = new PolynomialFunction(new double[]{0.0, -2.0});
            PolynomialFunction g2 = new PolynomialFunction(new double[]{1.0, 0.0, -1.0});
            PolynomialFunction Pk0g0 = Pk0.multiply(g0);
            PolynomialFunction Pk1g1 = Pk1.multiply(g1);
            PolynomialFunction Pk2g2 = Pk2.multiply(g2);
            this.checkNullPolynomial(Pk0g0.add(Pk1g1.add(Pk2g2)));
        }
    }

    @Test
    public void testLegendreOrthogonality() {
        UnivariateFunction weight = new UnivariateFunction(){

            public double value(double x) {
                return 1.0;
            }
        };
        for (int i = 0; i < 10; ++i) {
            PolynomialFunction pi = PolynomialsUtils.createLegendrePolynomial((int)i);
            for (int j = 0; j <= i; ++j) {
                PolynomialFunction pj = PolynomialsUtils.createLegendrePolynomial((int)j);
                this.checkOrthogonality(pi, pj, weight, -1.0, 1.0, 0.1, 1.0E-13);
            }
        }
    }

    @Test
    public void testHighDegreeLegendre() {
        PolynomialsUtils.createLegendrePolynomial((int)40);
        double[] l40 = PolynomialsUtils.createLegendrePolynomial((int)40).getCoefficients();
        double denominator = 2.74877906944E11;
        double[] numerators = new double[]{3.4461632205E10, -2.82585384081E13, 3.84787097990295E15, -2.077850329147593E17, 5.92929433210331E18, -1.0330148347486655E20, 1.197358103913226E21, -9.763073770369382E21, 5.817164788178423E22, -2.6006148464797657E23, 8.883152817712462E23, -2.3457676271881395E24, 4.8190226254191124E24, -7.71043620067058E24, 9.566652323054239E24, -9.104813935044723E24, 6.516550296251767E24, -3.391858621221954E24, 1.2113780790078407E24, -2.6536589497469058E23, 2.6876802183334046E22};
        for (int i = 0; i < l40.length; ++i) {
            if (i % 2 == 0) {
                double ci = numerators[i / 2] / denominator;
                Assert.assertEquals((double)ci, (double)l40[i], (double)(FastMath.abs((double)ci) * 1.0E-15));
                continue;
            }
            Assert.assertEquals((double)0.0, (double)l40[i], (double)0.0);
        }
    }

    @Test
    public void testJacobiLegendre() {
        for (int i = 0; i < 10; ++i) {
            PolynomialFunction legendre = PolynomialsUtils.createLegendrePolynomial((int)i);
            PolynomialFunction jacobi = PolynomialsUtils.createJacobiPolynomial((int)i, (int)0, (int)0);
            this.checkNullPolynomial(legendre.subtract(jacobi));
        }
    }

    @Test
    public void testJacobiEvaluationAt1() {
        for (int v = 0; v < 10; ++v) {
            for (int w = 0; w < 10; ++w) {
                for (int i = 0; i < 10; ++i) {
                    PolynomialFunction jacobi = PolynomialsUtils.createJacobiPolynomial((int)i, (int)v, (int)w);
                    double binomial = CombinatoricsUtils.binomialCoefficient((int)(v + i), (int)i);
                    Assert.assertTrue((boolean)Precision.equals((double)binomial, (double)jacobi.value(1.0), (int)1));
                }
            }
        }
    }

    @Test
    public void testJacobiOrthogonality() {
        for (int v = 0; v < 5; ++v) {
            for (int w = v; w < 5; ++w) {
                final int vv = v;
                final int ww = w;
                UnivariateFunction weight = new UnivariateFunction(){

                    public double value(double x) {
                        return FastMath.pow((double)(1.0 - x), (int)vv) * FastMath.pow((double)(1.0 + x), (int)ww);
                    }
                };
                for (int i = 0; i < 10; ++i) {
                    PolynomialFunction pi = PolynomialsUtils.createJacobiPolynomial((int)i, (int)v, (int)w);
                    for (int j = 0; j <= i; ++j) {
                        PolynomialFunction pj = PolynomialsUtils.createJacobiPolynomial((int)j, (int)v, (int)w);
                        this.checkOrthogonality(pi, pj, weight, -1.0, 1.0, 0.1, 1.0E-12);
                    }
                }
            }
        }
    }

    @Test
    public void testShift() {
        PolynomialFunction f1x = new PolynomialFunction(new double[]{1.0, 1.0, 2.0});
        PolynomialFunction f1x1 = new PolynomialFunction(PolynomialsUtils.shift((double[])f1x.getCoefficients(), (double)1.0));
        this.checkPolynomial(f1x1, "4 + 5 x + 2 x^2");
        PolynomialFunction f1xM1 = new PolynomialFunction(PolynomialsUtils.shift((double[])f1x.getCoefficients(), (double)-1.0));
        this.checkPolynomial(f1xM1, "2 - 3 x + 2 x^2");
        PolynomialFunction f1x3 = new PolynomialFunction(PolynomialsUtils.shift((double[])f1x.getCoefficients(), (double)3.0));
        this.checkPolynomial(f1x3, "22 + 13 x + 2 x^2");
        PolynomialFunction f2x = new PolynomialFunction(new double[]{2.0, 0.0, 3.0, 8.0, 0.0, 121.0});
        PolynomialFunction f2x1 = new PolynomialFunction(PolynomialsUtils.shift((double[])f2x.getCoefficients(), (double)1.0));
        this.checkPolynomial(f2x1, "134 + 635 x + 1237 x^2 + 1218 x^3 + 605 x^4 + 121 x^5");
        PolynomialFunction f2x3 = new PolynomialFunction(PolynomialsUtils.shift((double[])f2x.getCoefficients(), (double)3.0));
        this.checkPolynomial(f2x3, "29648 + 49239 x + 32745 x^2 + 10898 x^3 + 1815 x^4 + 121 x^5");
    }

    private void checkPolynomial(PolynomialFunction p, long denominator, String reference) {
        PolynomialFunction q = new PolynomialFunction(new double[]{denominator});
        Assert.assertEquals((Object)reference, (Object)p.multiply(q).toString());
    }

    private void checkPolynomial(PolynomialFunction p, String reference) {
        Assert.assertEquals((Object)reference, (Object)p.toString());
    }

    private void checkNullPolynomial(PolynomialFunction p) {
        for (double coefficient : p.getCoefficients()) {
            Assert.assertEquals((double)0.0, (double)coefficient, (double)1.0E-13);
        }
    }

    private void checkOrthogonality(final PolynomialFunction p1, final PolynomialFunction p2, final UnivariateFunction weight, double a, double b, double nonZeroThreshold, double zeroThreshold) {
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                return weight.value(x) * p1.value(x) * p2.value(x);
            }
        };
        double dotProduct = new IterativeLegendreGaussIntegrator(5, 1.0E-9, 1.0E-8, 2, 15).integrate(1000000, f, a, b);
        if (p1.degree() == p2.degree()) {
            Assert.assertTrue((String)("I(" + p1.degree() + ", " + p2.degree() + ") = " + dotProduct), (FastMath.abs((double)dotProduct) > nonZeroThreshold ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)("I(" + p1.degree() + ", " + p2.degree() + ") = " + dotProduct), (double)0.0, (double)FastMath.abs((double)dotProduct), (double)zeroThreshold);
        }
    }
}

