/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.BivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.PiecewiseBicubicSplineInterpolatingFunction;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.InsufficientDataException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937c;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public final class PiecewiseBicubicSplineInterpolatingFunctionTest {
    @Test
    public void testPreconditions() {
        double[] yval12;
        double[] xval12;
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5, 7.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5, 3.5};
        double[][] zval = new double[xval.length][yval.length];
        PiecewiseBicubicSplineInterpolatingFunction bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval, yval, zval);
        try {
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(null, yval, zval);
            Assert.fail((String)"Failed to detect x null pointer");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval, null, zval);
            Assert.fail((String)"Failed to detect y null pointer");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval, yval, (double[][])null);
            Assert.fail((String)"Failed to detect z null pointer");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            xval12 = new double[]{0.0, 1.0, 2.0, 3.0};
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval12, yval, zval);
            Assert.fail((String)"Failed to detect insufficient x data");
        }
        catch (InsufficientDataException xval12) {
            // empty catch block
        }
        try {
            yval12 = new double[]{0.0, 1.0, 2.0, 3.0};
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval, yval12, zval);
            Assert.fail((String)"Failed to detect insufficient y data");
        }
        catch (InsufficientDataException yval12) {
            // empty catch block
        }
        try {
            double[][] zval1 = new double[4][4];
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval, yval, zval1);
            Assert.fail((String)"Failed to detect insufficient z data");
        }
        catch (InsufficientDataException zval1) {
            // empty catch block
        }
        try {
            xval12 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval12, yval, zval);
            Assert.fail((String)"Failed to detect data set array with different sizes.");
        }
        catch (DimensionMismatchException xval13) {
            // empty catch block
        }
        try {
            yval12 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval, yval12, zval);
            Assert.fail((String)"Failed to detect data set array with different sizes.");
        }
        catch (DimensionMismatchException yval13) {
            // empty catch block
        }
        try {
            xval12 = new double[]{0.0, 1.0, 0.5, 7.0, 3.5};
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval12, yval, zval);
            Assert.fail((String)"Failed to detect unsorted x arguments.");
        }
        catch (NonMonotonicSequenceException xval14) {
            // empty catch block
        }
        try {
            yval12 = new double[]{0.0, 1.0, 1.5, 0.0, 3.0};
            bcf = new PiecewiseBicubicSplineInterpolatingFunction(xval, yval12, zval);
            Assert.fail((String)"Failed to detect unsorted y arguments.");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
    }

    @Test
    public void testPlane() {
        int numberOfElements = 10;
        double minimumX = -10.0;
        double maximumX = 10.0;
        double minimumY = -10.0;
        double maximumY = 10.0;
        int numberOfSamples = 100;
        double interpolationTolerance = 7.0E-15;
        double maxTolerance = 6.0E-14;
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x - 3.0 * y + 5.0;
            }
        };
        this.testInterpolation(-10.0, 10.0, -10.0, 10.0, 10, 100, f, 7.0E-15, 6.0E-14);
    }

    @Test
    public void testParabaloid() {
        int numberOfElements = 10;
        double minimumX = -10.0;
        double maximumX = 10.0;
        double minimumY = -10.0;
        double maximumY = 10.0;
        int numberOfSamples = 100;
        double interpolationTolerance = 2.0E-14;
        double maxTolerance = 6.0E-14;
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x * x - 3.0 * y * y + 4.0 * x * y - 5.0;
            }
        };
        this.testInterpolation(-10.0, 10.0, -10.0, 10.0, 10, 100, f, 2.0E-14, 6.0E-14);
    }

    private void testInterpolation(double minimumX, double maximumX, double minimumY, double maximumY, int numberOfElements, int numberOfSamples, BivariateFunction f, double meanTolerance, double maxTolerance) {
        double actual;
        double expected;
        double currentY;
        double currentX;
        double deltaX = (maximumX - minimumX) / (double)numberOfElements;
        double deltaY = (maximumY - minimumY) / (double)numberOfElements;
        double[] xValues = new double[numberOfElements];
        double[] yValues = new double[numberOfElements];
        double[][] zValues = new double[numberOfElements][numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            xValues[i] = minimumX + deltaX * (double)i;
            for (int j = 0; j < numberOfElements; ++j) {
                yValues[j] = minimumY + deltaY * (double)j;
                zValues[i][j] = f.value(xValues[i], yValues[j]);
            }
        }
        PiecewiseBicubicSplineInterpolatingFunction interpolation = new PiecewiseBicubicSplineInterpolatingFunction(xValues, yValues, zValues);
        for (int i = 0; i < numberOfElements; ++i) {
            currentX = xValues[i];
            for (int j = 0; j < numberOfElements; ++j) {
                currentY = yValues[j];
                expected = f.value(currentX, currentY);
                actual = interpolation.value(currentX, currentY);
                Assert.assertTrue((boolean)Precision.equals((double)expected, (double)actual));
            }
        }
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xValues[0], xValues[xValues.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yValues[0], yValues[yValues.length - 1]);
        double sumError = 0.0;
        for (int i = 0; i < numberOfSamples; ++i) {
            currentX = distX.sample();
            currentY = distY.sample();
            expected = f.value(currentX, currentY);
            actual = interpolation.value(currentX, currentY);
            sumError += FastMath.abs((double)(actual - expected));
            Assert.assertEquals((double)expected, (double)actual, (double)maxTolerance);
        }
        double meanError = sumError / (double)numberOfSamples;
        Assert.assertEquals((double)0.0, (double)meanError, (double)meanTolerance);
    }
}

