/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937c;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class AkimaSplineInterpolatorTest {
    @Test
    public void testIllegalArguments() {
        double[] yval;
        double[] xval3;
        AkimaSplineInterpolator i = new AkimaSplineInterpolator();
        try {
            double[] yval2 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
            i.interpolate(null, yval2);
            Assert.fail((String)"Failed to detect x null pointer");
        }
        catch (NullArgumentException yval2) {
            // empty catch block
        }
        try {
            xval3 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
            i.interpolate(xval3, null);
            Assert.fail((String)"Failed to detect y null pointer");
        }
        catch (NullArgumentException xval2) {
            // empty catch block
        }
        try {
            xval3 = new double[]{0.0, 1.0, 2.0, 3.0};
            yval = new double[]{0.0, 1.0, 2.0, 3.0};
            i.interpolate(xval3, yval);
            Assert.fail((String)"Failed to detect insufficient data");
        }
        catch (NumberIsTooSmallException xval3) {
            // empty catch block
        }
        try {
            xval3 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0};
            yval = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
            i.interpolate(xval3, yval);
            Assert.fail((String)"Failed to detect data set array with different sizes.");
        }
        catch (DimensionMismatchException xval4) {
            // empty catch block
        }
        try {
            xval3 = new double[]{0.0, 1.0, 0.5, 7.0, 3.5, 2.2, 8.0};
            yval = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
            i.interpolate(xval3, yval);
            Assert.fail((String)"Failed to detect unsorted arguments.");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
    }

    @Test
    public void testInterpolateLine() {
        int numberOfElements = 10;
        double minimumX = -10.0;
        double maximumX = 10.0;
        int numberOfSamples = 100;
        double interpolationTolerance = 1.0E-15;
        double maxTolerance = 1.0E-15;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                return 2.0 * x - 5.0;
            }
        };
        this.testInterpolation(-10.0, 10.0, 10, 100, f, 1.0E-15, 1.0E-15);
    }

    @Test
    public void testInterpolateParabola() {
        int numberOfElements = 10;
        double minimumX = -10.0;
        double maximumX = 10.0;
        int numberOfSamples = 100;
        double interpolationTolerance = 7.0E-15;
        double maxTolerance = 6.0E-14;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                return 3.0 * x * x - 5.0 * x + 7.0;
            }
        };
        this.testInterpolation(-10.0, 10.0, 10, 100, f, 7.0E-15, 6.0E-14);
    }

    @Test
    public void testInterpolateCubic() {
        int numberOfElements = 10;
        double minimumX = -3.0;
        double maximumX = 3.0;
        int numberOfSamples = 100;
        double interpolationTolerance = 0.37;
        double maxTolerance = 3.8;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                return 3.0 * x * x * x - 0.5 * x * x + 1.0 * x - 1.0;
            }
        };
        this.testInterpolation(-3.0, 3.0, 10, 100, f, 0.37, 3.8);
    }

    private void testInterpolation(double minimumX, double maximumX, int numberOfElements, int numberOfSamples, UnivariateFunction f, double tolerance, double maxTolerance) {
        double actual;
        double expected;
        double currentX;
        double delta = (maximumX - minimumX) / (double)numberOfElements;
        double[] xValues = new double[numberOfElements];
        double[] yValues = new double[numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            xValues[i] = minimumX + delta * (double)i;
            yValues[i] = f.value(xValues[i]);
        }
        PolynomialSplineFunction interpolation = new AkimaSplineInterpolator().interpolate(xValues, yValues);
        for (int i = 0; i < numberOfElements; ++i) {
            currentX = xValues[i];
            expected = f.value(currentX);
            actual = interpolation.value(currentX);
            Assert.assertTrue((boolean)Precision.equals((double)expected, (double)actual));
        }
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xValues[0], xValues[xValues.length - 1]);
        double sumError = 0.0;
        for (int i = 0; i < numberOfSamples; ++i) {
            currentX = distX.sample();
            expected = f.value(currentX);
            actual = interpolation.value(currentX);
            sumError += FastMath.abs((double)(actual - expected));
            Assert.assertEquals((double)expected, (double)actual, (double)maxTolerance);
        }
        Assert.assertEquals((double)0.0, (double)(sumError / (double)numberOfSamples), (double)tolerance);
    }
}

