/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.integration;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.QuinticFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.LegendreGaussIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.TooManyEvaluationsException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class LegendreGaussIntegratorTest {
    @Test
    public void testSinFunction() {
        Sin f = new Sin();
        LegendreGaussIntegrator integrator = new LegendreGaussIntegrator(5, 1.0E-14, 1.0E-10, 2, 15);
        double min = 0.0;
        double max = Math.PI;
        double expected = 2.0;
        double tolerance = FastMath.max((double)integrator.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * integrator.getRelativeAccuracy())));
        double result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        min = -1.0471975511965976;
        max = 0.0;
        expected = -0.5;
        tolerance = FastMath.max((double)integrator.getAbsoluteAccuracy(), (double)FastMath.abs((double)(expected * integrator.getRelativeAccuracy())));
        result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
    }

    @Test
    public void testQuinticFunction() {
        QuinticFunction f = new QuinticFunction();
        LegendreGaussIntegrator integrator = new LegendreGaussIntegrator(3, 1.0E-6, 1.0E-15, 3, 64);
        double min = 0.0;
        double max = 1.0;
        double expected = -0.020833333333333332;
        double result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)1.0E-16);
        min = 0.0;
        max = 0.5;
        expected = 0.014322916666666666;
        result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)1.0E-16);
        min = -1.0;
        max = 4.0;
        expected = 604.6875;
        result = integrator.integrate(10000, (UnivariateFunction)f, min, max);
        Assert.assertEquals((double)expected, (double)result, (double)1.0E-16);
    }

    @Test
    public void testExactIntegration() {
        Random random = new Random(86343623467878363L);
        for (int n = 2; n < 6; ++n) {
            LegendreGaussIntegrator integrator = new LegendreGaussIntegrator(n, 1.0E-6, 1.0E-15, 3, 64);
            for (int degree = 0; degree <= 2 * n - 1; ++degree) {
                for (int i = 0; i < 10; ++i) {
                    double[] coeff = new double[degree + 1];
                    for (int k = 0; k < coeff.length; ++k) {
                        coeff[k] = 2.0 * random.nextDouble() - 1.0;
                    }
                    PolynomialFunction p = new PolynomialFunction(coeff);
                    double result = integrator.integrate(10000, (UnivariateFunction)p, -5.0, 15.0);
                    double reference = this.exactIntegration(p, -5.0, 15.0);
                    Assert.assertEquals((String)(n + " " + degree + " " + i), (double)reference, (double)result, (double)(1.0E-12 * (1.0 + FastMath.abs((double)reference))));
                }
            }
        }
    }

    @Test
    public void testIssue464() {
        double value = 0.2;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                return x >= 0.0 && x <= 5.0 ? 0.2 : 0.0;
            }
        };
        LegendreGaussIntegrator gauss = new LegendreGaussIntegrator(5, 3, 100);
        double maxX = 0.32462367623786326;
        Assert.assertEquals((double)(maxX * 0.2), (double)gauss.integrate(Integer.MAX_VALUE, f, -10.0, maxX), (double)1.0E-7);
        Assert.assertTrue((gauss.getEvaluations() > 37000000 ? 1 : 0) != 0);
        Assert.assertTrue((gauss.getIterations() < 30 ? 1 : 0) != 0);
        try {
            gauss.integrate(1000, f, -10.0, maxX);
            Assert.fail((String)"expected TooManyEvaluationsException");
        }
        catch (TooManyEvaluationsException tmee) {
            Assert.assertEquals((Object)1000, (Object)tmee.getMax());
        }
        double sum1 = gauss.integrate(1000, f, -10.0, 0.0);
        int eval1 = gauss.getEvaluations();
        double sum2 = gauss.integrate(1000, f, 0.0, maxX);
        int eval2 = gauss.getEvaluations();
        Assert.assertEquals((double)(maxX * 0.2), (double)(sum1 + sum2), (double)1.0E-7);
        Assert.assertTrue((eval1 + eval2 < 200 ? 1 : 0) != 0);
    }

    private double exactIntegration(PolynomialFunction p, double a, double b) {
        double yb;
        double[] coeffs = p.getCoefficients();
        double ya = yb = coeffs[coeffs.length - 1] / (double)coeffs.length;
        for (int i = coeffs.length - 2; i >= 0; --i) {
            yb = yb * b + coeffs[i] / (double)(i + 1);
            ya = ya * a + coeffs[i] / (double)(i + 1);
        }
        return yb * b - ya * a;
    }
}

