/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.function;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.FunctionUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Logit;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sigmoid;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well1024a;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class LogitTest {
    private final double EPS = Math.ulp(1.0);

    @Test(expected=OutOfRangeException.class)
    public void testPreconditions1() {
        double lo = -1.0;
        double hi = 2.0;
        Logit f = new Logit(-1.0, 2.0);
        f.value(-2.0);
    }

    @Test(expected=OutOfRangeException.class)
    public void testPreconditions2() {
        double lo = -1.0;
        double hi = 2.0;
        Logit f = new Logit(-1.0, 2.0);
        f.value(3.0);
    }

    @Test
    public void testSomeValues() {
        double lo = 1.0;
        double hi = 2.0;
        Logit f = new Logit(1.0, 2.0);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)f.value(1.0), (double)this.EPS);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)f.value(2.0), (double)this.EPS);
        Assert.assertEquals((double)0.0, (double)f.value(1.5), (double)this.EPS);
    }

    @Test
    public void testDerivative() {
        double lo = 1.0;
        double hi = 2.0;
        Logit f = new Logit(1.0, 2.0);
        DerivativeStructure f15 = f.value(new DerivativeStructure(1, 1, 0, 1.5));
        Assert.assertEquals((double)4.0, (double)f15.getPartialDerivative(new int[]{1}), (double)this.EPS);
    }

    @Test
    public void testDerivativeLargeArguments() {
        Logit f = new Logit(1.0, 2.0);
        for (double arg : new double[]{Double.NEGATIVE_INFINITY, -1.7976931348623157E308, -1.0E155, 1.0E155, Double.MAX_VALUE, Double.POSITIVE_INFINITY}) {
            try {
                f.value(new DerivativeStructure(1, 1, 0, arg));
                Assert.fail((String)"an exception should have been thrown");
            }
            catch (OutOfRangeException outOfRangeException) {
            }
            catch (Exception e) {
                Assert.fail((String)("wrong exception caught: " + e.getMessage()));
            }
        }
    }

    @Test
    public void testDerivativesHighOrder() {
        DerivativeStructure l = new Logit(1.0, 3.0).value(new DerivativeStructure(1, 5, 0, 1.2));
        Assert.assertEquals((double)-2.1972245773362196, (double)l.getPartialDerivative(new int[]{0}), (double)1.0E-16);
        Assert.assertEquals((double)5.555555555555555, (double)l.getPartialDerivative(new int[]{1}), (double)9.0E-16);
        Assert.assertEquals((double)-24.691358024691358, (double)l.getPartialDerivative(new int[]{2}), (double)2.0E-14);
        Assert.assertEquals((double)250.3429355281207, (double)l.getPartialDerivative(new int[]{3}), (double)2.0E-13);
        Assert.assertEquals((double)-3749.4284407864657, (double)l.getPartialDerivative(new int[]{4}), (double)4.0E-12);
        Assert.assertEquals((double)75001.27013158564, (double)l.getPartialDerivative(new int[]{5}), (double)8.0E-11);
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage1() {
        Logit.Parametric g = new Logit.Parametric();
        g.value(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage2() {
        Logit.Parametric g = new Logit.Parametric();
        g.value(0.0, new double[]{0.0});
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage3() {
        Logit.Parametric g = new Logit.Parametric();
        g.gradient(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage4() {
        Logit.Parametric g = new Logit.Parametric();
        g.gradient(0.0, new double[]{0.0});
    }

    @Test(expected=OutOfRangeException.class)
    public void testParametricUsage5() {
        Logit.Parametric g = new Logit.Parametric();
        g.value(-1.0, new double[]{0.0, 1.0});
    }

    @Test(expected=OutOfRangeException.class)
    public void testParametricUsage6() {
        Logit.Parametric g = new Logit.Parametric();
        g.value(2.0, new double[]{0.0, 1.0});
    }

    @Test
    public void testParametricValue() {
        double lo = 2.0;
        double hi = 3.0;
        Logit f = new Logit(2.0, 3.0);
        Logit.Parametric g = new Logit.Parametric();
        Assert.assertEquals((double)f.value(2.0), (double)g.value(2.0, new double[]{2.0, 3.0}), (double)0.0);
        Assert.assertEquals((double)f.value(2.34567), (double)g.value(2.34567, new double[]{2.0, 3.0}), (double)0.0);
        Assert.assertEquals((double)f.value(3.0), (double)g.value(3.0, new double[]{2.0, 3.0}), (double)0.0);
    }

    @Test
    public void testValueWithInverseFunction() {
        double lo = 2.0;
        double hi = 3.0;
        Logit f = new Logit(2.0, 3.0);
        Sigmoid g = new Sigmoid(2.0, 3.0);
        Well1024a random = new Well1024a(5301102751131602357L);
        UnivariateDifferentiableFunction id = FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{g, f});
        for (int i = 0; i < 10; ++i) {
            double x = 2.0 + random.nextDouble() * 1.0;
            Assert.assertEquals((double)x, (double)id.value(new DerivativeStructure(1, 1, 0, x)).getValue(), (double)this.EPS);
        }
        Assert.assertEquals((double)2.0, (double)id.value(new DerivativeStructure(1, 1, 0, 2.0)).getValue(), (double)this.EPS);
        Assert.assertEquals((double)3.0, (double)id.value(new DerivativeStructure(1, 1, 0, 3.0)).getValue(), (double)this.EPS);
    }

    @Test
    public void testDerivativesWithInverseFunction() {
        double[] epsilon = new double[]{1.0E-20, 4.0E-16, 3.0E-15, 2.0E-11, 3.0E-9, 1.0E-6};
        double lo = 2.0;
        double hi = 3.0;
        Logit f = new Logit(2.0, 3.0);
        Sigmoid g = new Sigmoid(2.0, 3.0);
        Well1024a random = new Well1024a(-7599720346551202139L);
        UnivariateDifferentiableFunction id = FunctionUtils.compose((UnivariateDifferentiableFunction[])new UnivariateDifferentiableFunction[]{g, f});
        for (int maxOrder = 0; maxOrder < 6; ++maxOrder) {
            double max = 0.0;
            for (int i = 0; i < 10; ++i) {
                double x = 2.0 + random.nextDouble() * 1.0;
                DerivativeStructure dsX = new DerivativeStructure(1, maxOrder, 0, x);
                max = FastMath.max((double)max, (double)FastMath.abs((double)(dsX.getPartialDerivative(new int[]{maxOrder}) - id.value(dsX).getPartialDerivative(new int[]{maxOrder}))));
                Assert.assertEquals((double)dsX.getPartialDerivative(new int[]{maxOrder}), (double)id.value(dsX).getPartialDerivative(new int[]{maxOrder}), (double)epsilon[maxOrder]);
            }
            DerivativeStructure dsLo = new DerivativeStructure(1, maxOrder, 0, 2.0);
            if (maxOrder == 0) {
                Assert.assertTrue((boolean)Double.isInfinite(f.value(dsLo).getPartialDerivative(new int[]{maxOrder})));
                Assert.assertEquals((double)2.0, (double)id.value(dsLo).getPartialDerivative(new int[]{maxOrder}), (double)epsilon[maxOrder]);
            } else if (maxOrder == 1) {
                Assert.assertTrue((boolean)Double.isInfinite(f.value(dsLo).getPartialDerivative(new int[]{maxOrder})));
                Assert.assertTrue((boolean)Double.isNaN(id.value(dsLo).getPartialDerivative(new int[]{maxOrder})));
            } else {
                Assert.assertTrue((boolean)Double.isNaN(f.value(dsLo).getPartialDerivative(new int[]{maxOrder})));
                Assert.assertTrue((boolean)Double.isNaN(id.value(dsLo).getPartialDerivative(new int[]{maxOrder})));
            }
            DerivativeStructure dsHi = new DerivativeStructure(1, maxOrder, 0, 3.0);
            if (maxOrder == 0) {
                Assert.assertTrue((boolean)Double.isInfinite(f.value(dsHi).getPartialDerivative(new int[]{maxOrder})));
                Assert.assertEquals((double)3.0, (double)id.value(dsHi).getPartialDerivative(new int[]{maxOrder}), (double)epsilon[maxOrder]);
                continue;
            }
            if (maxOrder == 1) {
                Assert.assertTrue((boolean)Double.isInfinite(f.value(dsHi).getPartialDerivative(new int[]{maxOrder})));
                Assert.assertTrue((boolean)Double.isNaN(id.value(dsHi).getPartialDerivative(new int[]{maxOrder})));
                continue;
            }
            Assert.assertTrue((boolean)Double.isNaN(f.value(dsHi).getPartialDerivative(new int[]{maxOrder})));
            Assert.assertTrue((boolean)Double.isNaN(id.value(dsHi).getPartialDerivative(new int[]{maxOrder})));
        }
    }
}

