/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well1024a;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendedFieldElementAbstractTest<T extends RealFieldElement<T>> {
    protected abstract T build(double var1);

    @Test
    public void testAddField() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(x + y, (RealFieldElement)this.build(x).add(this.build(y)));
            }
        }
    }

    @Test
    public void testAddDouble() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(x + y, (RealFieldElement)this.build(x).add(y));
            }
        }
    }

    @Test
    public void testSubtractField() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(x - y, (RealFieldElement)this.build(x).subtract(this.build(y)));
            }
        }
    }

    @Test
    public void testSubtractDouble() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(x - y, (RealFieldElement)this.build(x).subtract(y));
            }
        }
    }

    @Test
    public void testMultiplyField() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(x * y, (RealFieldElement)this.build(x).multiply(this.build(y)));
            }
        }
    }

    @Test
    public void testMultiplyDouble() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(x * y, (RealFieldElement)this.build(x).multiply(y));
            }
        }
    }

    @Test
    public void testMultiplyInt() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (int y = -10; y < 10; ++y) {
                this.checkRelative(x * (double)y, (RealFieldElement)this.build(x).multiply(y));
            }
        }
    }

    @Test
    public void testDivideField() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(x / y, (RealFieldElement)this.build(x).divide(this.build(y)));
            }
        }
    }

    @Test
    public void testDivideDouble() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(x / y, (RealFieldElement)this.build(x).divide(y));
            }
        }
    }

    @Test
    public void testRemainderField() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(FastMath.IEEEremainder((double)x, (double)y), (RealFieldElement)this.build(x).remainder(this.build(y)));
            }
        }
    }

    @Test
    public void testRemainderDouble() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.2; y < 3.2; y += 0.25) {
                this.checkRelative(FastMath.IEEEremainder((double)x, (double)y), (RealFieldElement)this.build(x).remainder(y));
            }
        }
    }

    @Test
    public void testCos() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.cos((double)x), (RealFieldElement)this.build(x).cos());
        }
    }

    @Test
    public void testAcos() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.acos((double)x), (RealFieldElement)this.build(x).acos());
        }
    }

    @Test
    public void testSin() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.sin((double)x), (RealFieldElement)this.build(x).sin());
        }
    }

    @Test
    public void testAsin() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.asin((double)x), (RealFieldElement)this.build(x).asin());
        }
    }

    @Test
    public void testTan() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.tan((double)x), (RealFieldElement)this.build(x).tan());
        }
    }

    @Test
    public void testAtan() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.atan((double)x), (RealFieldElement)this.build(x).atan());
        }
    }

    @Test
    public void testAtan2() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(FastMath.atan2((double)x, (double)y), (RealFieldElement)this.build(x).atan2(this.build(y)));
            }
        }
    }

    @Test
    public void testCosh() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.cosh((double)x), (RealFieldElement)this.build(x).cosh());
        }
    }

    @Test
    public void testAcosh() {
        for (double x = 1.1; x < 5.0; x += 0.05) {
            this.checkRelative(FastMath.acosh((double)x), (RealFieldElement)this.build(x).acosh());
        }
    }

    @Test
    public void testSinh() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.sinh((double)x), (RealFieldElement)this.build(x).sinh());
        }
    }

    @Test
    public void testAsinh() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.asinh((double)x), (RealFieldElement)this.build(x).asinh());
        }
    }

    @Test
    public void testTanh() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.tanh((double)x), (RealFieldElement)this.build(x).tanh());
        }
    }

    @Test
    public void testAtanh() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.atanh((double)x), (RealFieldElement)this.build(x).atanh());
        }
    }

    @Test
    public void testSqrt() {
        for (double x = 0.01; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.sqrt((double)x), (RealFieldElement)this.build(x).sqrt());
        }
    }

    @Test
    public void testCbrt() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.cbrt((double)x), (RealFieldElement)this.build(x).cbrt());
        }
    }

    @Test
    public void testHypot() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(FastMath.hypot((double)x, (double)y), (RealFieldElement)this.build(x).hypot(this.build(y)));
            }
        }
    }

    @Test
    public void testRootN() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            for (int n = 1; n < 5; ++n) {
                if (x < 0.0) {
                    if (n % 2 != 1) continue;
                    this.checkRelative(-FastMath.pow((double)(-x), (double)(1.0 / (double)n)), (RealFieldElement)this.build(x).rootN(n));
                    continue;
                }
                this.checkRelative(FastMath.pow((double)x, (double)(1.0 / (double)n)), (RealFieldElement)this.build(x).rootN(n));
            }
        }
    }

    @Test
    public void testPowField() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            for (double y = 0.1; y < 4.0; y += 0.2) {
                this.checkRelative(FastMath.pow((double)x, (double)y), (RealFieldElement)this.build(x).pow(this.build(y)));
            }
        }
    }

    @Test
    public void testPowDouble() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            for (double y = 0.1; y < 4.0; y += 0.2) {
                this.checkRelative(FastMath.pow((double)x, (double)y), (RealFieldElement)this.build(x).pow(y));
            }
        }
    }

    @Test
    public void testPowInt() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            for (int n = 0; n < 5; ++n) {
                this.checkRelative(FastMath.pow((double)x, (int)n), (RealFieldElement)this.build(x).pow(n));
            }
        }
    }

    @Test
    public void testExp() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.exp((double)x), (RealFieldElement)this.build(x).exp());
        }
    }

    @Test
    public void testExpm1() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.expm1((double)x), (RealFieldElement)this.build(x).expm1());
        }
    }

    @Test
    public void testLog() {
        for (double x = 0.01; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.log((double)x), (RealFieldElement)this.build(x).log());
        }
    }

    @Test
    public void testLog1p() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.log1p((double)x), (RealFieldElement)this.build(x).log1p());
        }
    }

    @Test
    public void testAbs() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.abs((double)x), (RealFieldElement)this.build(x).abs());
        }
    }

    @Test
    public void testCeil() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.ceil((double)x), (RealFieldElement)this.build(x).ceil());
        }
    }

    @Test
    public void testFloor() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.floor((double)x), (RealFieldElement)this.build(x).floor());
        }
    }

    @Test
    public void testRint() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.rint((double)x), (RealFieldElement)this.build(x).rint());
        }
    }

    @Test
    public void testRound() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            Assert.assertEquals((long)FastMath.round((double)x), (long)this.build(x).round());
        }
    }

    @Test
    public void testSignum() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            this.checkRelative(FastMath.signum((double)x), (RealFieldElement)this.build(x).signum());
        }
    }

    @Test
    public void testCopySignField() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(FastMath.copySign((double)x, (double)y), (RealFieldElement)this.build(x).copySign(this.build(y)));
            }
        }
    }

    @Test
    public void testCopySignDouble() {
        for (double x = -3.0; x < 3.0; x += 0.2) {
            for (double y = -3.0; y < 3.0; y += 0.2) {
                this.checkRelative(FastMath.copySign((double)x, (double)y), (RealFieldElement)this.build(x).copySign(y));
            }
        }
    }

    @Test
    public void testScalb() {
        for (double x = -0.9; x < 0.9; x += 0.05) {
            for (int n = -100; n < 100; ++n) {
                this.checkRelative(FastMath.scalb((double)x, (int)n), (RealFieldElement)this.build(x).scalb(n));
            }
        }
    }

    @Test
    public void testLinearCombinationFaFa() {
        Well1024a r = new Well1024a(64250L);
        for (int i = 0; i < 50; ++i) {
            double[] aD = this.generateDouble((RandomGenerator)r, 10);
            double[] bD = this.generateDouble((RandomGenerator)r, 10);
            Object[] aF = this.toFieldArray(aD);
            Object[] bF = this.toFieldArray(bD);
            this.checkRelative(MathArrays.linearCombination((double[])aD, (double[])bD), (RealFieldElement)aF[0].linearCombination(aF, bF));
        }
    }

    @Test
    public void testLinearCombinationDaFa() {
        Well1024a r = new Well1024a(56058L);
        for (int i = 0; i < 50; ++i) {
            double[] aD = this.generateDouble((RandomGenerator)r, 10);
            double[] bD = this.generateDouble((RandomGenerator)r, 10);
            Object[] bF = this.toFieldArray(bD);
            this.checkRelative(MathArrays.linearCombination((double[])aD, (double[])bD), (RealFieldElement)bF[0].linearCombination(aD, bF));
        }
    }

    @Test
    public void testLinearCombinationFF2() {
        Well1024a r = new Well1024a(4082L);
        for (int i = 0; i < 50; ++i) {
            double[] aD = this.generateDouble((RandomGenerator)r, 2);
            double[] bD = this.generateDouble((RandomGenerator)r, 2);
            RealFieldElement[] aF = this.toFieldArray(aD);
            RealFieldElement[] bF = this.toFieldArray(bD);
            this.checkRelative(MathArrays.linearCombination((double)aD[0], (double)bD[0], (double)aD[1], (double)bD[1]), (RealFieldElement)aF[0].linearCombination((Object)aF[0], (Object)bF[0], (Object)aF[1], (Object)bF[1]));
        }
    }

    @Test
    public void testLinearCombinationDF2() {
        Well1024a r = new Well1024a(3570L);
        for (int i = 0; i < 50; ++i) {
            double[] aD = this.generateDouble((RandomGenerator)r, 2);
            double[] bD = this.generateDouble((RandomGenerator)r, 2);
            RealFieldElement[] bF = this.toFieldArray(bD);
            this.checkRelative(MathArrays.linearCombination((double)aD[0], (double)bD[0], (double)aD[1], (double)bD[1]), (RealFieldElement)bF[0].linearCombination(aD[0], (Object)bF[0], aD[1], (Object)bF[1]));
        }
    }

    @Test
    public void testLinearCombinationFF3() {
        Well1024a r = new Well1024a(4083L);
        for (int i = 0; i < 50; ++i) {
            double[] aD = this.generateDouble((RandomGenerator)r, 3);
            double[] bD = this.generateDouble((RandomGenerator)r, 3);
            RealFieldElement[] aF = this.toFieldArray(aD);
            RealFieldElement[] bF = this.toFieldArray(bD);
            this.checkRelative(MathArrays.linearCombination((double)aD[0], (double)bD[0], (double)aD[1], (double)bD[1], (double)aD[2], (double)bD[2]), (RealFieldElement)aF[0].linearCombination((Object)aF[0], (Object)bF[0], (Object)aF[1], (Object)bF[1], (Object)aF[2], (Object)bF[2]));
        }
    }

    @Test
    public void testLinearCombinationDF3() {
        Well1024a r = new Well1024a(3571L);
        for (int i = 0; i < 50; ++i) {
            double[] aD = this.generateDouble((RandomGenerator)r, 3);
            double[] bD = this.generateDouble((RandomGenerator)r, 3);
            RealFieldElement[] bF = this.toFieldArray(bD);
            this.checkRelative(MathArrays.linearCombination((double)aD[0], (double)bD[0], (double)aD[1], (double)bD[1], (double)aD[2], (double)bD[2]), (RealFieldElement)bF[0].linearCombination(aD[0], (Object)bF[0], aD[1], (Object)bF[1], aD[2], (Object)bF[2]));
        }
    }

    @Test
    public void testLinearCombinationFF4() {
        Well1024a r = new Well1024a(4084L);
        for (int i = 0; i < 50; ++i) {
            double[] aD = this.generateDouble((RandomGenerator)r, 4);
            double[] bD = this.generateDouble((RandomGenerator)r, 4);
            RealFieldElement[] aF = this.toFieldArray(aD);
            RealFieldElement[] bF = this.toFieldArray(bD);
            this.checkRelative(MathArrays.linearCombination((double)aD[0], (double)bD[0], (double)aD[1], (double)bD[1], (double)aD[2], (double)bD[2], (double)aD[3], (double)bD[3]), (RealFieldElement)aF[0].linearCombination((Object)aF[0], (Object)bF[0], (Object)aF[1], (Object)bF[1], (Object)aF[2], (Object)bF[2], (Object)aF[3], (Object)bF[3]));
        }
    }

    @Test
    public void testLinearCombinationDF4() {
        Well1024a r = new Well1024a(3572L);
        for (int i = 0; i < 50; ++i) {
            double[] aD = this.generateDouble((RandomGenerator)r, 4);
            double[] bD = this.generateDouble((RandomGenerator)r, 4);
            RealFieldElement[] bF = this.toFieldArray(bD);
            this.checkRelative(MathArrays.linearCombination((double)aD[0], (double)bD[0], (double)aD[1], (double)bD[1], (double)aD[2], (double)bD[2], (double)aD[3], (double)bD[3]), (RealFieldElement)bF[0].linearCombination(aD[0], (Object)bF[0], aD[1], (Object)bF[1], aD[2], (Object)bF[2], aD[3], (Object)bF[3]));
        }
    }

    @Test
    public void testGetField() {
        this.checkRelative(1.0, (RealFieldElement)this.build(-10.0).getField().getOne());
        this.checkRelative(0.0, (RealFieldElement)this.build(-10.0).getField().getZero());
    }

    private void checkRelative(double expected, T obtained) {
        Assert.assertEquals((double)expected, (double)obtained.getReal(), (double)(1.0E-15 * (1.0 + FastMath.abs((double)expected))));
    }

    @Test
    public void testEquals() {
        T t1a = this.build(1.0);
        T t1b = this.build(1.0);
        T t2 = this.build(2.0);
        Assert.assertTrue((boolean)t1a.equals(t1a));
        Assert.assertTrue((boolean)t1a.equals(t1b));
        Assert.assertFalse((boolean)t1a.equals(t2));
        Assert.assertFalse((boolean)t1a.equals(new Object()));
    }

    @Test
    public void testHash() {
        T t1a = this.build(1.0);
        T t1b = this.build(1.0);
        T t2 = this.build(2.0);
        Assert.assertEquals((long)t1a.hashCode(), (long)t1b.hashCode());
        Assert.assertTrue((t1a.hashCode() != t2.hashCode() ? 1 : 0) != 0);
    }

    private double[] generateDouble(RandomGenerator r, int n) {
        double[] a = new double[n];
        for (int i = 0; i < n; ++i) {
            a[i] = r.nextDouble();
        }
        return a;
    }

    private T[] toFieldArray(double[] a) {
        RealFieldElement[] f = (RealFieldElement[])MathArrays.buildArray((Field)this.build(0.0).getField(), (int)a.length);
        for (int i = 0; i < a.length; ++i) {
            f[i] = this.build(a[i]);
        }
        return f;
    }
}

