/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.jet.sql.impl.validate.types.HazelcastObjectType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class HazelcastObjectTypeTest {
    private static final HazelcastTypeFactory TYPE_FACTORY = HazelcastTypeFactory.INSTANCE;

    @Test
    public void testDigestEscaping() {
        HazelcastObjectType person = new HazelcastObjectType("P(e:r=s,o)n");
        person.addField(new HazelcastObjectType.Field("name", 0, HazelcastObjectTypeTest.nullable(SqlTypeName.VARCHAR)));
        person.addField(new HazelcastObjectType.Field("(:fri=end,)", 1, (RelDataType)person));
        HazelcastObjectType.finalizeFields(List.of(person));
        Assert.assertEquals((Object)"P\\(e\\:r=s\\,o\\)n(name:VARCHAR CHARACTER SET \"UTF-16LE\", \\(\\:fri=end\\,\\):P\\(e\\:r=s\\,o\\)n)", (Object)person.getFullTypeString());
    }

    @Test
    public void testFinalization() {
        HazelcastObjectType person = new HazelcastObjectType("Person");
        person.addField(new HazelcastObjectType.Field("name", 0, HazelcastObjectTypeTest.nullable(SqlTypeName.VARCHAR)));
        person.addField(new HazelcastObjectType.Field("age", 1, HazelcastObjectTypeTest.nullable(SqlTypeName.INTEGER)));
        Assertions.assertThatThrownBy(() -> ((HazelcastObjectType)person).getFieldList()).hasMessage("Type fields are not finalized");
        Assertions.assertThatThrownBy(() -> person.getField("name", false, false)).hasMessage("Type fields are not finalized");
        Assertions.assertThatThrownBy(() -> ((HazelcastObjectType)person).getFieldNames()).hasMessage("Type fields are not finalized");
        Assertions.assertThatThrownBy(() -> ((HazelcastObjectType)person).getFieldCount()).hasMessage("Type fields are not finalized");
        HazelcastObjectType.finalizeFields(List.of(person));
        Assertions.assertThat((List)person.getFieldList()).hasSize(2);
        Assertions.assertThat((Object)person.getField("name", false, false)).isNotNull();
        Assertions.assertThat((List)person.getFieldNames()).containsExactly((Object[])new String[]{"name", "age"});
        Assertions.assertThat((int)person.getFieldCount()).isEqualTo(2);
        Assertions.assertThatThrownBy(() -> person.addField(new HazelcastObjectType.Field("friend", 2, (RelDataType)person))).hasMessage("Type fields are already finalized");
        Assertions.assertThatThrownBy(() -> HazelcastObjectType.finalizeFields(List.of(person))).hasMessage("Type fields are already finalized");
    }

    private static RelDataType nullable(SqlTypeName typeName) {
        return TYPE_FACTORY.createTypeWithNullability(TYPE_FACTORY.createSqlType(typeName), true);
    }
}

