/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.type.BasicNestedFieldsTest;
import com.hazelcast.map.IMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class CyclicUDTAreNotAllowedByDefaultTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() throws Exception {
        CyclicUDTAreNotAllowedByDefaultTest.initializeWithClient((int)1, null, null);
    }

    @Test
    public void test_defaultBehaviorFailsOnCycles() {
        CyclicUDTAreNotAllowedByDefaultTest.createType("AType", "name VARCHAR", "b BType");
        CyclicUDTAreNotAllowedByDefaultTest.createType("BType", "name VARCHAR", "c CType");
        CyclicUDTAreNotAllowedByDefaultTest.createType("CType", "name VARCHAR", "a AType");
        BasicNestedFieldsTest.A a = new BasicNestedFieldsTest.A("a");
        BasicNestedFieldsTest.B b = new BasicNestedFieldsTest.B("b");
        BasicNestedFieldsTest.C c = new BasicNestedFieldsTest.C("c");
        a.b = b;
        b.c = c;
        c.a = a;
        BasicNestedFieldsTest.createJavaMapping(CyclicUDTAreNotAllowedByDefaultTest.client(), "test", BasicNestedFieldsTest.A.class, "this AType");
        IMap map = CyclicUDTAreNotAllowedByDefaultTest.client().getMap("test");
        map.put((Object)1L, (Object)a);
        Assertions.assertThatThrownBy(() -> CyclicUDTAreNotAllowedByDefaultTest.instance().getSql().execute("SELECT * FROM test", new Object[0])).hasMessageContaining("Experimental feature of using cyclic custom types isn't enabled.");
        Assertions.assertThatThrownBy(() -> CyclicUDTAreNotAllowedByDefaultTest.instance().getSql().execute("SELECT * FROM test AS t", new Object[0])).hasMessageContaining("Experimental feature of using cyclic custom types isn't enabled.");
    }

    @Test
    public void test_defaultJoinBehaviorFailsOnCycles() {
        CyclicUDTAreNotAllowedByDefaultTest.createType("AType", "name VARCHAR", "b BType");
        CyclicUDTAreNotAllowedByDefaultTest.createType("BType", "name VARCHAR", "c CType");
        CyclicUDTAreNotAllowedByDefaultTest.createType("CType", "name VARCHAR", "a AType");
        CyclicUDTAreNotAllowedByDefaultTest.createType("SimpleType", "name VARCHAR");
        BasicNestedFieldsTest.A a = new BasicNestedFieldsTest.A("a");
        BasicNestedFieldsTest.B b = new BasicNestedFieldsTest.B("b");
        BasicNestedFieldsTest.C c = new BasicNestedFieldsTest.C("c");
        a.b = b;
        b.c = c;
        c.a = a;
        BasicNestedFieldsTest.createJavaMapping(CyclicUDTAreNotAllowedByDefaultTest.client(), "test", BasicNestedFieldsTest.A.class, "this AType");
        BasicNestedFieldsTest.createJavaMapping(CyclicUDTAreNotAllowedByDefaultTest.client(), "simple_test", SimpleType.class, "this SimpleType");
        IMap map = CyclicUDTAreNotAllowedByDefaultTest.client().getMap("test");
        map.put((Object)1L, (Object)a);
        Assertions.assertThatThrownBy(() -> CyclicUDTAreNotAllowedByDefaultTest.instance().getSql().execute("SELECT * FROM simple_test as t1 JOIN test as t2 on t1.this.name = t2.this.name", new Object[0])).hasMessageContaining("Experimental feature of using cyclic custom types isn't enabled.");
    }

    private static void createType(String name, String ... fields) {
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType(name).fields(fields)).create(CyclicUDTAreNotAllowedByDefaultTest.client());
    }

    static class SimpleType {
        String name;

        SimpleType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

