/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.impl.compact.DeserializedGenericRecord;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.jet.sql.impl.connector.map.model.AllTypesValue;
import com.hazelcast.jet.sql.impl.type.CompactNestedFieldsTest;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
public class BasicNestedFieldsTest
extends SqlTestSupport {
    @Parameterized.Parameter
    public boolean useClient;

    @Parameterized.Parameters(name="useClient:{0}")
    public static Object[] parameters() {
        return new Object[]{false, true};
    }

    @BeforeClass
    public static void beforeClass() {
        BasicNestedFieldsTest.initializeWithClient((int)3, null, null);
    }

    private HazelcastInstance testInstance() {
        return this.useClient ? BasicNestedFieldsTest.client() : BasicNestedFieldsTest.instance();
    }

    static void createJavaMapping(HazelcastInstance instance, String name, Class<?> valueClass, String ... valueFields) {
        ((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).fields(new String[]{"__key BIGINT"})).fields(valueFields)).options(new Object[]{"keyFormat", "bigint", "valueFormat", "java", "valueJavaClass", valueClass.getName()})).create(instance);
    }

    private void createJavaMapping(String name, Class<?> valueClass, String ... valueFields) {
        BasicNestedFieldsTest.createJavaMapping(this.testInstance(), name, valueClass, valueFields);
    }

    private void createType(String name, String ... fields) {
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType(name).fields(fields)).create(this.testInstance());
    }

    private SqlResult execute(String sql, Object ... args) {
        return this.testInstance().getSql().execute(sql, args);
    }

    private User initDefault() {
        this.createType("UserType", "id BIGINT", "name VARCHAR", "organization OrganizationType");
        this.createType("OrganizationType", "id BIGINT", "name VARCHAR", "office OfficeType");
        this.createType("OfficeType", "id BIGINT", "name VARCHAR");
        IMap testMap = this.testInstance().getMap("test");
        this.createJavaMapping("test", User.class, "this UserType");
        Office office = new Office(3L, "office1");
        Organization organization = new Organization(2L, "organization1", office);
        User user = new User(1L, "user1", organization);
        testMap.put((Object)1L, (Object)user);
        return user;
    }

    @Test
    public void test_simpleNestedColumnSelect() {
        this.initDefault();
        String sql = "SELECT test.this.name AS user_name, test.this.organization.name AS org_name, test.this.organization.office.name AS office_name, test.this.organization.office.id AS office_id FROM test";
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT test.this.name AS user_name, test.this.organization.name AS org_name, test.this.organization.office.name AS office_name, test.this.organization.office.id AS office_id FROM test", BasicNestedFieldsTest.rows(4, "user1", "organization1", "office1", 3L));
    }

    @Test
    public void test_complexProjections() {
        this.initDefault();
        String sql = "SELECT ABS((this).id) * 2 AS C1, FLOOR(CAST(((this).organization).id AS REAL) * 5.0 / 2.0) AS c2 FROM test";
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT ABS((this).id) * 2 AS C1, FLOOR(CAST(((this).organization).id AS REAL) * 5.0 / 2.0) AS c2 FROM test", BasicNestedFieldsTest.rows(2, 2L, Float.valueOf(5.0f)));
    }

    @Test
    public void test_wholeObjectSelect() {
        User user = this.initDefault();
        Organization organization = user.getOrganization();
        Office office = organization.getOffice();
        String sql = "SELECT test.this.organization, test.this.organization.office FROM test";
        SqlResult res = this.execute("SELECT test.this.organization, test.this.organization.office FROM test", new Object[0]);
        Assert.assertEquals((Object)SqlColumnType.OBJECT, (Object)res.getRowMetadata().getColumn(0).getType());
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT test.this.organization, test.this.organization.office FROM test", BasicNestedFieldsTest.rows(2, organization, office));
    }

    @Test
    public void test_objectComparison() {
        User user = this.initDefault();
        Organization organization = user.getOrganization();
        Office office = organization.getOffice();
        String sql = "SELECT test.this.organization, test.this.organization.office FROM test WHERE test.this.organization.office = ?";
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT test.this.organization, test.this.organization.office FROM test WHERE test.this.organization.office = ?", Collections.singletonList(office), BasicNestedFieldsTest.rows(2, organization, office));
    }

    @Test
    public void test_fullInsert() {
        this.initDefault();
        Office office = new Office(5L, "office2");
        Organization organization = new Organization(4L, "organization2", office);
        User user = new User(2L, "user1", organization);
        this.execute("INSERT INTO test (__key, this) VALUES (?, ?)", 2L, new User(2L, "user2", user.organization));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT test.this.organization, test.this.organization.office FROM test WHERE __key = 2", BasicNestedFieldsTest.rows(2, organization, office));
    }

    @Test
    public void test_update() {
        User oldUser = this.initDefault();
        User newUser = new User(1L, "new-name", oldUser.organization);
        this.execute("UPDATE test SET this = ? WHERE __key = 1", newUser);
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT test.this.id, test.this.name, test.this.organization FROM test WHERE __key = 1", BasicNestedFieldsTest.rows(3, 1L, "new-name", oldUser.organization));
    }

    @Test
    public void test_deepInsert() {
        this.initDefault();
        this.execute("INSERT INTO test VALUES (2, (2, 'user2', (2, 'organization2', (2, 'office2'))))", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT test.this.name, test.this.organization.name, test.this.organization.office.name FROM test WHERE __key = 2", BasicNestedFieldsTest.rows(3, "user2", "organization2", "office2"));
    }

    @Test
    public void test_deepUpdate() {
        this.initDefault();
        this.execute("UPDATE test SET this = ((this).id, (this).name, ((this).organization.id, (this).organization.name, ((this).organization.office.id,'new-office-name')))WHERE __key = 1", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder("SELECT (this).organization.office.name FROM test WHERE __key = 1", BasicNestedFieldsTest.rows(1, "new-office-name"));
    }

    @Test
    public void test_mixedModeQuerying() {
        this.createType("NestedType", new String[0]);
        this.createJavaMapping("test", RegularPOJO.class, "name VARCHAR", "child NestedType");
        this.testInstance().getMap("test").put((Object)1L, (Object)new RegularPOJO("parentPojo", new NestedPOJO(1L, "childPojo")));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT name, (child).name FROM test", BasicNestedFieldsTest.rows(2, "parentPojo", "childPojo"));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT child FROM test", BasicNestedFieldsTest.rows(1, new NestedPOJO(1L, "childPojo")));
    }

    @Test
    public void test_mixedModeAliasQuerying() {
        this.createType("NestedType", new String[0]);
        this.createJavaMapping("test", RegularPOJO.class, "parentName VARCHAR EXTERNAL NAME \"name\"", "childObj NestedType EXTERNAL NAME \"child\"");
        this.testInstance().getMap("test").put((Object)1L, (Object)new RegularPOJO("parentPojo", new NestedPOJO(1L, "childPojo")));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT parentName, (childObj).name FROM (SELECT * FROM test)", BasicNestedFieldsTest.rows(2, "parentPojo", "childPojo"));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT childObj FROM test", BasicNestedFieldsTest.rows(1, new NestedPOJO(1L, "childPojo")));
    }

    @Test
    public void test_mixedModeUpsert() {
        this.createType("NestedType", new String[0]);
        this.createJavaMapping("test", RegularPOJO.class, "name VARCHAR", "child NestedType");
        this.execute("INSERT INTO test (__key, name, child) VALUES (1, 'parent', (1, 'child'))", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT name, test.child.name FROM test", BasicNestedFieldsTest.rows(2, "parent", "child"));
        this.execute("UPDATE test SET child = (2, 'child2')", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT test.child.id, test.child.name FROM test", BasicNestedFieldsTest.rows(2, 2L, "child2"));
    }

    @Test
    public void test_typeCoercionUpserts() {
        this.createType("AllTypesValue", new String[0]);
        this.createJavaMapping("test", AllTypesParent.class, "name VARCHAR", "child AllTypesValue");
        String allTypesValueRowLiteral = "(1,1,true,1,'1970-01-01T00:00:00Z','A','1970-01-01T00:00:00Z',1.0,1.0,'1970-01-01T00:00:00Z',1,'1970-01-01','1970-01-01T00:00:00','00:00:00',1,null,null,'1970-01-01T00:00:00Z',1,'test','1970-01-01T00:00:00Z')";
        this.execute("INSERT INTO test (__key, name, child) VALUES (1, 'parent', (1,1,true,1,'1970-01-01T00:00:00Z','A','1970-01-01T00:00:00Z',1.0,1.0,'1970-01-01T00:00:00Z',1,'1970-01-01','1970-01-01T00:00:00','00:00:00',1,null,null,'1970-01-01T00:00:00Z',1,'test','1970-01-01T00:00:00Z'))", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT test.child.bigDecimal,test.child.bigInteger,test.child.byte0,test.child.boolean0,test.child.calendar,test.child.character0,test.child.\"date\",test.child.double0,test.child.float0,test.child.instant,test.child.int0,test.child.localDate,test.child.localDateTime,test.child.\"localTime\",test.child.long0,test.child.map,test.child.object,test.child.offsetDateTime,test.child.short0,test.child.string,test.child.zonedDateTime FROM test", BasicNestedFieldsTest.rows(21, new BigDecimal(1L), new BigDecimal("1"), (byte)1, true, OffsetDateTime.from(ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC)), "A", OffsetDateTime.ofInstant(Date.from(Instant.ofEpochMilli(0L)).toInstant(), ZoneId.systemDefault()), 1.0, Float.valueOf(1.0f), OffsetDateTime.ofInstant(Instant.ofEpochMilli(0L), ZoneOffset.systemDefault()), 1, LocalDate.of(1970, 1, 1), LocalDateTime.of(1970, 1, 1, 0, 0, 0), LocalTime.of(0, 0, 0), 1L, null, null, OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC), (short)1, "test", OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC)));
    }

    @Test
    public void test_compoundAliases() {
        this.initDefault();
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT ((org).office).name FROM (SELECT (this).organization as org FROM (SELECT * FROM test))", BasicNestedFieldsTest.rows(1, "office1"));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT (((this).organization).office).name FROM (SELECT * FROM test)", BasicNestedFieldsTest.rows(1, "office1"));
    }

    @Test
    public void test_newDotOperatorSyntax() {
        this.initDefault();
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT (((this).organization).office).name FROM test", BasicNestedFieldsTest.rows(1, "office1"));
    }

    @Test
    public void test_joins() {
        this.initDefault();
        this.createJavaMapping("test2", User.class, "this UserType");
        this.execute("INSERT INTO test2 VALUES (1, (1, 'user2', (1, 'organization2', (1, 'office2'))))", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT (((t1.this).organization).office).name, (((t2.this).organization).office).name FROM test AS t1 JOIN test2 AS t2 ON t1.__key = t2.__key", BasicNestedFieldsTest.rows(2, "office1", "office2"));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT (((this).organization).office).name FROM (SELECT t1.this FROM test AS t1 JOIN test2 AS t2 ON t1.__key = t2.__key)", BasicNestedFieldsTest.rows(1, "office1"));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT (((this).organization).office).name FROM (SELECT t2.this FROM test AS t1 JOIN test2 AS t2 ON t1.__key = t2.__key)", BasicNestedFieldsTest.rows(1, "office2"));
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT (((this1).organization).office).name, (((this2).organization).office).name FROM (SELECT t1.this as this1, t2.this AS this2       FROM test AS t1 JOIN test2 AS t2 ON t1.__key = t2.__key)", BasicNestedFieldsTest.rows(2, "office1", "office2"));
    }

    @Test
    public void test_joinsOnNestedFields() {
        this.initDefault();
        this.createJavaMapping("test2", User.class, "this UserType");
        this.execute("INSERT INTO test2 VALUES (1, (1, 'user2', (1, 'organization2', (1, 'office2'))))", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder(this.testInstance(), "SELECT t1.this.organization.office.name, t2.this.organization.office.name FROM test AS t1 JOIN test2 AS t2 ON ABS(t1.this.id) = t2.this.id AND t1.this.id = t2.this.id", BasicNestedFieldsTest.rows(2, "office1", "office2"));
    }

    @Test
    public void test_missingType() {
        this.createType("UserType", "id BIGINT", "name VARCHAR", "organization OrganizationType");
        Assertions.assertThatThrownBy(() -> this.createJavaMapping("test", User.class, "this UserType")).hasMessage("Encountered type 'OrganizationType', which doesn't exist");
    }

    @Test
    public void test_nullValueInRow() {
        this.createType("Office", "id BIGINT", "name VARCHAR");
        this.createType("Organization", "id BIGINT", "name VARCHAR", "office Office");
        CompactNestedFieldsTest.createCompactMapping(this.testInstance(), "test", "UserCompactType", "organization Organization");
        this.execute("INSERT INTO test VALUES (1, (2, 'orgName', null))", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder("SELECT (organization).office FROM test", BasicNestedFieldsTest.rows(1, new Object[]{null}));
    }

    @Test
    public void test_customOptions() {
        ((SqlTestSupport.SqlType)((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("Organization").fields(new String[]{"name VARCHAR", "governmentFunded BOOLEAN"})).options(new Object[]{"javaClass", NonprofitOrganization.class.getName(), "compactTypeName", "NonprofitOrganization"})).create(this.testInstance());
        this.createJavaMapping("Users", User.class, "name VARCHAR", "organization Organization");
        this.execute("INSERT INTO Users VALUES (1, 'Alice', ('Doctors Without Borders', true))", new Object[0]);
        BasicNestedFieldsTest.assertRowsAnyOrder("SELECT name, (organization).name, (organization).governmentFunded FROM Users", BasicNestedFieldsTest.rows(3, "Alice", "Doctors Without Borders", true));
        CompactNestedFieldsTest.createCompactMapping(this.testInstance(), "Users2", "Users", "name VARCHAR", "organization Organization");
        this.execute("INSERT INTO Users2 VALUES (1, 'Alice', ('Doctors Without Borders', true))", new Object[0]);
        SqlResult result = this.execute("SELECT this FROM Users2", new Object[0]);
        DeserializedGenericRecord record = (DeserializedGenericRecord)((SqlRow)result.iterator().next()).getObject(0);
        Assert.assertEquals((Object)"Users", (Object)record.getSchema().getTypeName());
        Assert.assertEquals((Object)"NonprofitOrganization", (Object)((DeserializedGenericRecord)record.getObject("organization")).getSchema().getTypeName());
    }

    public static class User
    implements Serializable {
        private Long id;
        private String name;
        private Organization organization;

        public User() {
        }

        public User(Long id, String name, Organization organization) {
            this.id = id;
            this.name = name;
            this.organization = organization;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Organization getOrganization() {
            return this.organization;
        }

        public void setOrganization(Organization organization) {
            this.organization = organization;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return Objects.equals(this.id, user.id) && Objects.equals(this.name, user.name) && Objects.equals(this.organization, user.organization);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.organization);
        }

        public String toString() {
            return "User{id=" + this.id + ", name='" + this.name + "', organization=" + String.valueOf(this.organization) + "}";
        }
    }

    public static class Office
    implements Serializable,
    Comparable<Office> {
        private Long id;
        private String name;

        public Office() {
        }

        public Office(Long id, String name) {
            this.id = id;
            this.name = name;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Office office = (Office)o;
            return Objects.equals(this.id, office.id) && Objects.equals(this.name, office.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        @Override
        public int compareTo(Office o) {
            return this.hashCode() - o.hashCode();
        }

        public String toString() {
            return "Office{id=" + this.id + ", name='" + this.name + "'}";
        }
    }

    public static class Organization
    implements Serializable,
    Comparable<Organization> {
        protected Long id;
        protected String name;
        protected Office office;

        public Organization() {
        }

        public Organization(Long id, String name, Office office) {
            this.id = id;
            this.name = name;
            this.office = office;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Office getOffice() {
            return this.office;
        }

        public void setOffice(Office office) {
            this.office = office;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Organization that = (Organization)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.office, that.office);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.office);
        }

        @Override
        public int compareTo(Organization o) {
            return this.hashCode() - o.hashCode();
        }

        public String toString() {
            return "Organization{id=" + this.id + ", name='" + this.name + "', office=" + String.valueOf(this.office) + "}";
        }
    }

    public static class RegularPOJO
    implements Serializable {
        private String name;
        private NestedPOJO child;

        public RegularPOJO() {
        }

        public RegularPOJO(String name, NestedPOJO child) {
            this.name = name;
            this.child = child;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public NestedPOJO getChild() {
            return this.child;
        }

        public void setChild(NestedPOJO child) {
            this.child = child;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegularPOJO that = (RegularPOJO)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.child, that.child);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.child);
        }
    }

    public static class NestedPOJO
    implements Serializable {
        private Long id;
        private String name;

        public NestedPOJO() {
        }

        public NestedPOJO(Long id, String name) {
            this.id = id;
            this.name = name;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedPOJO that = (NestedPOJO)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }
    }

    public static class AllTypesParent
    implements Serializable {
        private String name;
        private AllTypesValue child;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public AllTypesValue getChild() {
            return this.child;
        }

        public void setChild(AllTypesValue child) {
            this.child = child;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllTypesParent that = (AllTypesParent)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.child, that.child);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.child);
        }
    }

    public static class NonprofitOrganization
    extends Organization {
        private Boolean governmentFunded;

        public Boolean isGovernmentFunded() {
            return this.governmentFunded;
        }

        public void setGovernmentFunded(Boolean governmentFunded) {
            this.governmentFunded = governmentFunded;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonprofitOrganization that = (NonprofitOrganization)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.office, that.office) && Objects.equals(this.governmentFunded, that.governmentFunded);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.id, this.name, this.office, this.governmentFunded);
        }

        @Override
        public String toString() {
            return "Organization{id=" + this.id + ", name='" + this.name + "', office=" + String.valueOf(this.office) + ", governmentFunded=" + this.governmentFunded + "}";
        }
    }

    public static class SelfRef
    implements Serializable {
        public Long id;
        public String name;
        public SelfRef other;

        public SelfRef() {
        }

        public SelfRef(Long id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static class C
    implements Serializable {
        public String name;
        public A a;

        public C() {
        }

        public C(String name) {
            this.name = name;
        }
    }

    public static class B
    implements Serializable {
        public String name;
        public C c;

        public B() {
        }

        public B(String name) {
            this.name = name;
        }
    }

    public static class A
    implements Serializable {
        public String name;
        public B b;

        public A() {
        }

        public A(String name) {
            this.name = name;
        }
    }
}

