/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.support.expressions;

import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import java.util.function.Predicate;
import org.junit.Assert;

public final class ExpressionPredicates {
    private ExpressionPredicates() {
    }

    public static Predicate<ExpressionValue> eq(Object operand) {
        return new ComparePredicate(Comparison.EQ, operand, true);
    }

    public static Predicate<ExpressionValue> eq_2(Object operand) {
        return new ComparePredicate(Comparison.EQ, operand, false);
    }

    public static Predicate<ExpressionValue> neq(Object operand) {
        return new ComparePredicate(Comparison.NEQ, operand, true);
    }

    public static Predicate<ExpressionValue> neq_2(Object operand) {
        return new ComparePredicate(Comparison.NEQ, operand, false);
    }

    public static Predicate<ExpressionValue> gt(Object operand) {
        return new ComparePredicate(Comparison.GT, operand, true);
    }

    public static Predicate<ExpressionValue> gt_2(Object operand) {
        return new ComparePredicate(Comparison.GT, operand, false);
    }

    public static Predicate<ExpressionValue> gte(Object operand) {
        return new ComparePredicate(Comparison.GTE, operand, true);
    }

    public static Predicate<ExpressionValue> gte_2(Object operand) {
        return new ComparePredicate(Comparison.GTE, operand, false);
    }

    public static Predicate<ExpressionValue> lt(Object operand) {
        return new ComparePredicate(Comparison.LT, operand, true);
    }

    public static Predicate<ExpressionValue> lt_2(Object operand) {
        return new ComparePredicate(Comparison.LT, operand, false);
    }

    public static Predicate<ExpressionValue> lte(Object operand) {
        return new ComparePredicate(Comparison.LTE, operand, true);
    }

    public static Predicate<ExpressionValue> lte_2(Object operand) {
        return new ComparePredicate(Comparison.LTE, operand, false);
    }

    public static Predicate<ExpressionValue> isNull() {
        return new NullPredicate(true);
    }

    public static Predicate<ExpressionValue> isNull_2() {
        return new NullPredicate(false);
    }

    public static Predicate<ExpressionValue> isNotNull() {
        return new NotNullPredicate(true);
    }

    public static Predicate<ExpressionValue> isNotNull_2() {
        return new NotNullPredicate(false);
    }

    public static Predicate<ExpressionValue> or(Predicate<ExpressionValue> ... predicates) {
        return new OrPredicate(predicates);
    }

    public static Predicate<ExpressionValue> and(Predicate<ExpressionValue> ... predicates) {
        return new AndPredicate(predicates);
    }

    public static class ComparePredicate
    implements Predicate<ExpressionValue> {
        private final Comparison comparison;
        private final Object operand;
        private final boolean firstField;

        public ComparePredicate(Comparison comparison, Object operand, boolean firstField) {
            Assert.assertNotNull((String)"Use IsNullPredicate to compare with null", (Object)operand);
            this.comparison = comparison;
            this.operand = operand;
            this.firstField = firstField;
        }

        @Override
        public boolean test(ExpressionValue value) {
            Object field;
            Object object = field = this.firstField ? value.field1() : ((ExpressionBiValue)value).field2();
            if (field == null) {
                return false;
            }
            int res = ((Comparable)field).compareTo(this.operand);
            switch (this.comparison) {
                case GT: {
                    return res > 0;
                }
                case GTE: {
                    return res >= 0;
                }
                case LT: {
                    return res < 0;
                }
                case LTE: {
                    return res <= 0;
                }
                case NEQ: {
                    return res != 0;
                }
            }
            return res == 0;
        }
    }

    private static enum Comparison {
        EQ,
        NEQ,
        GT,
        GTE,
        LT,
        LTE;

    }

    public static class NullPredicate
    implements Predicate<ExpressionValue> {
        private final boolean firstField;

        public NullPredicate(boolean firstField) {
            this.firstField = firstField;
        }

        @Override
        public boolean test(ExpressionValue value) {
            Object field = this.firstField ? value.field1() : ((ExpressionBiValue)value).field2();
            return field == null;
        }
    }

    public static class NotNullPredicate
    implements Predicate<ExpressionValue> {
        private final boolean firstField;

        public NotNullPredicate(boolean firstField) {
            this.firstField = firstField;
        }

        @Override
        public boolean test(ExpressionValue value) {
            Object field = this.firstField ? value.field1() : ((ExpressionBiValue)value).field2();
            return field != null;
        }
    }

    public static class OrPredicate
    implements Predicate<ExpressionValue> {
        private final Predicate[] predicates;

        public OrPredicate(Predicate ... predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean test(ExpressionValue value) {
            for (Predicate predicate : this.predicates) {
                if (!predicate.test(value)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AndPredicate
    implements Predicate<ExpressionValue> {
        private final Predicate[] predicates;

        public AndPredicate(Predicate ... predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean test(ExpressionValue value) {
            for (Predicate predicate : this.predicates) {
                if (predicate.test(value)) continue;
                return false;
            }
            return true;
        }
    }
}

