/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.SimpleTestInClusterSupport;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.view.View;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class RelationsStorageTest
extends SimpleTestInClusterSupport {
    private RelationsStorage storage;

    @BeforeClass
    public static void setUpClass() {
        RelationsStorageTest.initialize((int)1, null);
    }

    @Before
    public void before() {
        this.storage = new RelationsStorage((NodeEngine)Accessors.getNodeEngineImpl((HazelcastInstance)RelationsStorageTest.instance()));
    }

    @Test
    public void when_put_then_isPresentInValues() {
        String name = RelationsStorageTest.randomName();
        this.storage.put(name, RelationsStorageTest.mapping(name, "type"));
        Assertions.assertThat(this.storage.mappingNames().stream().filter(m -> m.equals(name))).isNotEmpty();
    }

    @Test
    public void when_put_then_overridesPrevious() {
        String name = RelationsStorageTest.randomName();
        Mapping originalMapping = RelationsStorageTest.mapping(name, "type1");
        Mapping updatedMapping = RelationsStorageTest.mapping(name, "type2");
        this.storage.put(name, originalMapping);
        this.storage.put(name, updatedMapping);
        Assert.assertTrue((boolean)this.storage.allObjects().stream().noneMatch(m -> m.equals(originalMapping)));
        Assert.assertTrue((boolean)this.storage.allObjects().stream().anyMatch(m -> m.equals(updatedMapping)));
    }

    @Test
    public void when_putIfAbsent_then_doesNotOverwrite() {
        String name = RelationsStorageTest.randomName();
        Assertions.assertThat((boolean)this.storage.putIfAbsent(name, RelationsStorageTest.mapping(name, "type-1"))).isTrue();
        Assertions.assertThat((boolean)this.storage.putIfAbsent(name, RelationsStorageTest.mapping(name, "type-2"))).isFalse();
        Assert.assertTrue((boolean)this.storage.allObjects().stream().anyMatch(m -> m instanceof Mapping && ((Mapping)m).connectorType().equals("type-1")));
        Assert.assertTrue((boolean)this.storage.allObjects().stream().noneMatch(m -> m instanceof Mapping && ((Mapping)m).connectorType().equals("type-2")));
    }

    @Test
    public void when_removeMapping_then_isNotPresentInValues() {
        String name = RelationsStorageTest.randomName();
        this.storage.put(name, RelationsStorageTest.mapping(name, "type"));
        Assertions.assertThat((Object)this.storage.removeMapping(name)).isNotNull();
        Assert.assertTrue((boolean)this.storage.mappingNames().stream().noneMatch(m -> m.equals(name)));
    }

    @Test
    public void when_removeView_then_isNotPresentInValues() {
        String name = RelationsStorageTest.randomName();
        this.storage.put(name, RelationsStorageTest.view(name, "type"));
        Assertions.assertThat((Object)this.storage.removeView(name)).isNotNull();
        Assert.assertTrue((boolean)this.storage.allObjects().stream().noneMatch(o -> o instanceof View && ((View)o).name().equals(name)));
    }

    @Test
    public void when_removeAbsentValue_then_returnsNull() {
        Assertions.assertThat((Object)this.storage.removeView("non-existing")).isNull();
    }

    private static Mapping mapping(String name, String type) {
        return new Mapping(name, name, null, type, null, Collections.emptyList(), Collections.emptyMap());
    }

    private static View view(String name, String query) {
        return new View(name, query, Collections.emptyList(), Collections.emptyList());
    }
}

