/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.impl.TestTableResolver;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class HazelcastSchemaUtilsTest {
    @Test
    public void testSearchPaths() {
        List paths = QueryUtils.prepareSearchPaths(null, null);
        HazelcastSchemaUtilsTest.checkSearchPaths(paths, new String[0]);
        paths = QueryUtils.prepareSearchPaths(Collections.singletonList(Arrays.asList("hazelcast", "test1")), null);
        HazelcastSchemaUtilsTest.checkSearchPaths(paths, "test1");
        paths = QueryUtils.prepareSearchPaths(null, Arrays.asList(TestTableResolver.create("test1", new Table[0]), TestTableResolver.create("test2", new Table[0])));
        HazelcastSchemaUtilsTest.checkSearchPaths(paths, "test1", "test2");
        paths = QueryUtils.prepareSearchPaths(Collections.singletonList(Arrays.asList("hazelcast", "test1")), Arrays.asList(TestTableResolver.create("test2", new Table[0]), TestTableResolver.create("test3", new Table[0])));
        HazelcastSchemaUtilsTest.checkSearchPaths(paths, "test1", "test2", "test3");
    }

    private static void checkSearchPaths(List<List<String>> paths, String ... expectedPaths) {
        ArrayList<List<String>> expectedPaths0 = new ArrayList<List<String>>();
        if (expectedPaths != null) {
            for (String expectedPath : expectedPaths) {
                expectedPaths0.add(Arrays.asList("hazelcast", expectedPath));
            }
        }
        expectedPaths0.add(Collections.singletonList("hazelcast"));
        expectedPaths0.add(Collections.emptyList());
        Assert.assertEquals(expectedPaths0, paths);
    }
}

