/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.QueryException;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GetDdlTest
extends SqlTestSupport {
    private static final String LE = System.lineSeparator();

    @BeforeClass
    public static void beforeClass() throws Exception {
        GetDdlTest.initializeWithClient((int)1, null, null);
    }

    @Test
    public void when_queryMappingFromRelationNamespace_then_success() {
        GetDdlTest.createMapping("a", Integer.TYPE, Integer.TYPE);
        GetDdlTest.assertRowsAnyOrder("SELECT GET_DDL('relation', 'a')", List.of(new SqlTestSupport.Row("CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"a\" EXTERNAL NAME \"a\" (" + LE + "  \"__key\" INTEGER EXTERNAL NAME \"__key\"," + LE + "  \"this\" INTEGER EXTERNAL NAME \"this\"" + LE + ")" + LE + "TYPE \"IMap\"" + LE + "OBJECT TYPE \"IMap\"" + LE + "OPTIONS (" + LE + "  'keyFormat'='java'," + LE + "  'keyJavaClass'='int'," + LE + "  'valueFormat'='java'," + LE + "  'valueJavaClass'='int'" + LE + ")")));
    }

    @Test
    public void when_queryViewFromRelationNamespace_then_success() {
        GetDdlTest.createMapping("a", Integer.TYPE, Integer.TYPE);
        GetDdlTest.instance().getSql().executeUpdate("CREATE VIEW v AS SELECT * FROM a", new Object[0]);
        GetDdlTest.assertRowsAnyOrder("SELECT GET_DDL('relation', 'v')", List.of(new SqlTestSupport.Row("CREATE OR REPLACE VIEW \"hazelcast\".\"public\".\"v\" AS" + LE + "SELECT \"a\".\"__key\", \"a\".\"this\"" + LE + "FROM \"hazelcast\".\"public\".\"a\" AS \"a\"")));
    }

    @Test
    public void when_queryTypeFromRelationNamespace_then_success() {
        String createTypeQuery = "CREATE OR REPLACE TYPE \"hazelcast\".\"public\".\"t\" (" + LE + "  \"a\" INTEGER," + LE + "  \"b\" INTEGER" + LE + ")" + LE + "OPTIONS (" + LE + "  'typeClass'='foo'" + LE + ")";
        GetDdlTest.instance().getSql().executeUpdate(createTypeQuery, new Object[0]);
        GetDdlTest.assertRowsAnyOrder("SELECT GET_DDL('relation', 't')", List.of(new SqlTestSupport.Row(createTypeQuery)));
    }

    @Test
    public void when_queryTypeFromRelationNamespace_withoutFieldsAndOptions_then_success() {
        String createTypeQuery = "CREATE OR REPLACE TYPE \"hazelcast\".\"public\".\"t\"";
        GetDdlTest.instance().getSql().executeUpdate(createTypeQuery, new Object[0]);
        GetDdlTest.assertRowsAnyOrder("SELECT GET_DDL('relation', 't')", List.of(new SqlTestSupport.Row(createTypeQuery)));
    }

    @Test
    public void when_queryDataConnectionFromDataConnectionNamespace_then_success() {
        String createDataConnectionQuery = "CREATE OR REPLACE DATA CONNECTION \"hazelcast\".\"public\".\"dl\"" + LE + "TYPE \"dummy\"" + LE + "SHARED";
        String createDataConnectionQueryFixedType = "CREATE OR REPLACE DATA CONNECTION \"hazelcast\".\"public\".\"dl\"" + LE + "TYPE \"DUMMY\"" + LE + "SHARED";
        GetDdlTest.instance().getSql().executeUpdate(createDataConnectionQuery, new Object[0]);
        GetDdlTest.assertRowsAnyOrder("SELECT GET_DDL('dataconnection', 'dl')", List.of(new SqlTestSupport.Row(createDataConnectionQueryFixedType)));
    }

    @Test
    public void when_queryDataConnectionWithByKeyPlan_then_success() {
        GetDdlTest.createMapping("a", Integer.class, String.class);
        GetDdlTest.createDataConnection(GetDdlTest.instance(), "dl", "DUMMY", true, Collections.emptyMap());
        IMap map = GetDdlTest.instance().getMap("a");
        map.put((Object)1, (Object)"dl");
        String ddl = "CREATE OR REPLACE DATA CONNECTION \"hazelcast\".\"public\".\"dl\"" + LE + "TYPE \"DUMMY\"" + LE + "SHARED";
        GetDdlTest.assertRowsAnyOrder("SELECT __key, GET_DDL('dataconnection', this) FROM a WHERE __key = 1", List.of(new SqlTestSupport.Row(1, ddl)));
    }

    @Test
    public void when_queryNullNamespace_then_throws() {
        try (SqlResult sqlRows = GetDdlTest.instance().getSql().execute("SELECT GET_DDL(null, 'b')", new Object[0]);){
            Assertions.assertThatThrownBy(() -> sqlRows.iterator().next()).hasCauseInstanceOf(QueryException.class).hasMessageContaining("Namespace must not be null for GET_DDL");
        }
    }

    @Test
    public void when_queryNotSupportedNamespace_then_throws() {
        try (SqlResult sqlRows = GetDdlTest.instance().getSql().execute("SELECT GET_DDL('a', 'b')", new Object[0]);){
            Assertions.assertThatThrownBy(() -> sqlRows.iterator().next()).hasCauseInstanceOf(QueryException.class).hasMessageContaining("Namespace 'a' is not supported.");
        }
    }

    @Test
    public void when_queryNullObject_then_throws() {
        try (SqlResult sqlRows = GetDdlTest.instance().getSql().execute("SELECT GET_DDL('relation', NULL)", new Object[0]);){
            Assertions.assertThatThrownBy(() -> sqlRows.iterator().next()).hasCauseInstanceOf(QueryException.class).hasMessageContaining("Object_name must not be null for GET_DDL");
        }
    }

    @Test
    public void when_queryNonExistingObject_then_throws() {
        try (SqlResult sqlRows = GetDdlTest.instance().getSql().execute("SELECT GET_DDL('relation', 'bbb')", new Object[0]);){
            Assertions.assertThatThrownBy(() -> sqlRows.iterator().next()).hasCauseInstanceOf(QueryException.class).hasMessageContaining("Object 'bbb' does not exist in namespace 'relation'");
        }
    }

    @Test
    public void when_queryDdlWithAnotherOperator_then_success() {
        GetDdlTest.createMapping("a", Integer.TYPE, Integer.TYPE);
        GetDdlTest.assertRowsAnyOrder("SELECT SUBSTRING(GET_DDL('relation', 'a') FROM 1 FOR 6)", List.of(new SqlTestSupport.Row("CREATE")));
        GetDdlTest.assertRowsAnyOrder("SELECT SUBSTRING(GET_DDL('relation', 'a') FROM 1 FOR 6) || SUBSTRING(GET_DDL('relation', 'a') FROM 1 FOR 3)", List.of(new SqlTestSupport.Row("CREATECRE")));
    }

    @Test
    public void when_queryDdlWithOtherRels_then_success() {
        GetDdlTest.createMapping("a", Integer.TYPE, Integer.TYPE);
        GetDdlTest.assertRowsAnyOrder("SELECT SUBSTRING(GET_DDL('relation', 'a') FROM 1 FOR 6)UNION ALL SELECT SUBSTRING(GET_DDL('relation', 'a') FROM 1 FOR 6)", List.of(new SqlTestSupport.Row("CREATE"), new SqlTestSupport.Row("CREATE")));
    }

    @Test
    public void when_queryDdlWithInput_then_success() {
        GetDdlTest.createMapping("a", Integer.TYPE, String.class);
        GetDdlTest.instance().getMap("a").put((Object)1, (Object)"a");
        GetDdlTest.assertRowsAnyOrder("SELECT GET_DDL('relation', this) FROM a", List.of(new SqlTestSupport.Row("CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"a\" EXTERNAL NAME \"a\" (" + LE + "  \"__key\" INTEGER EXTERNAL NAME \"__key\"," + LE + "  \"this\" VARCHAR EXTERNAL NAME \"this\"" + LE + ")" + LE + "TYPE \"IMap\"" + LE + "OBJECT TYPE \"IMap\"" + LE + "OPTIONS (" + LE + "  'keyFormat'='java'," + LE + "  'keyJavaClass'='int'," + LE + "  'valueFormat'='java'," + LE + "  'valueJavaClass'='java.lang.String'" + LE + ")")));
    }

    @Test
    public void when_queryDdlWithInputInPredicate_then_success() {
        GetDdlTest.createMapping("a", Integer.TYPE, String.class);
        GetDdlTest.instance().getMap("a").put((Object)1, (Object)"a");
        GetDdlTest.assertRowsAnyOrder("SELECT * FROM a WHERE GET_DDL('relation', this) = 'a'", Collections.emptyList());
    }

    @Test
    public void when_queryDataConnectionWithCreateJob_then_success() {
        String createDataConnectionQuery = "CREATE OR REPLACE DATA CONNECTION \"hazelcast\".\"public\".\"dl\"" + LE + "TYPE \"dummy\"" + LE + "SHARED";
        String createDataConnectionQueryFixedType = "CREATE OR REPLACE DATA CONNECTION \"hazelcast\".\"public\".\"dl\"" + LE + "TYPE \"DUMMY\"" + LE + "SHARED";
        String createJobQuery = "CREATE JOB j AS SINK INTO map SELECT v, v FROM (SELECT GET_DDL('dataconnection', 'dl') AS v)";
        IMap map = GetDdlTest.instance().getMap("map");
        GetDdlTest.createMapping("map", String.class, String.class);
        GetDdlTest.instance().getSql().executeUpdate(createDataConnectionQuery, new Object[0]);
        GetDdlTest.instance().getSql().executeUpdate(createJobQuery, new Object[0]);
        GetDdlTest.assertEqualsEventually(() -> map.size(), (Object)1);
        Assert.assertEquals(map.values().iterator().next(), (Object)createDataConnectionQueryFixedType);
    }

    @Test
    public void when_updateWithGetDdl_then_success() {
        GetDdlTest.createMapping("main", Integer.class, String.class);
        GetDdlTest.createMapping("target", Integer.class, String.class);
        SqlService sql = GetDdlTest.client().getSql();
        sql.executeUpdate("INSERT INTO main VALUES(1, 'initial')", new Object[0]);
        sql.executeUpdate("UPDATE main SET this = GET_DDL('relation', 'target') WHERE __key < 2", new Object[0]);
        try (SqlResult result = sql.execute("SELECT * FROM main WHERE __key = 1", new Object[0]);){
            String ddl = (String)((SqlRow)result.stream().findFirst().orElseThrow()).getObject("this");
            Assertions.assertThat((String)ddl).startsWith((CharSequence)"CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"target\" EXTERNAL NAME \"target\"");
        }
    }
}

