/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.TestContextSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.processors.LateItemsDropP;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={QuickTest.class, ParallelJVMTest.class})
@RunWith(value=HazelcastSerialClassRunner.class)
public class LateItemsDropPTest
extends SqlTestSupport {
    private static final Expression<?> timestampEx = ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BIGINT);

    @BeforeClass
    public static void beforeClass() {
        LateItemsDropPTest.initialize((int)1, null);
    }

    @Test
    public void when_noEventIsLate_then_successful() {
        SupplierEx & Serializable supplier = (SupplierEx & Serializable)() -> new LateItemsDropP(0, timestampEx);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)ProcessorSupplier.of((SupplierEx)supplier))).hazelcastInstance(LateItemsDropPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(SqlTestSupport::compareRowLists).disableSnapshots().input(Arrays.asList(LateItemsDropPTest.wm((long)0L), LateItemsDropPTest.jetRow(0L, 1L), LateItemsDropPTest.jetRow(1L, 2L), LateItemsDropPTest.jetRow(2L, 2L), LateItemsDropPTest.wm((long)3L))).expectOutput(Arrays.asList(LateItemsDropPTest.wm((long)0L), LateItemsDropPTest.jetRow(0L, 1L), LateItemsDropPTest.jetRow(1L, 2L), LateItemsDropPTest.jetRow(2L, 2L), LateItemsDropPTest.wm((long)3L)));
    }

    @Test
    public void when_oneEventIsLate_then_dropEvent() {
        SupplierEx & Serializable supplier = (SupplierEx & Serializable)() -> new LateItemsDropP(0, timestampEx);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)ProcessorSupplier.of((SupplierEx)supplier))).hazelcastInstance(LateItemsDropPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(SqlTestSupport::compareRowLists).disableSnapshots().input(Arrays.asList(LateItemsDropPTest.wm((long)0L), LateItemsDropPTest.jetRow(0L, 1L), LateItemsDropPTest.jetRow(1L, 2L), LateItemsDropPTest.wm((long)3L), LateItemsDropPTest.jetRow(1L, 2L))).expectOutput(Arrays.asList(LateItemsDropPTest.wm((long)0L), LateItemsDropPTest.jetRow(0L, 1L), LateItemsDropPTest.jetRow(1L, 2L), LateItemsDropPTest.wm((long)3L)));
    }

    @Test
    public void when_fewEventsAreLate_then_dropEvents() {
        SupplierEx & Serializable supplier = (SupplierEx & Serializable)() -> new LateItemsDropP(0, timestampEx);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)ProcessorSupplier.of((SupplierEx)supplier))).hazelcastInstance(LateItemsDropPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(SqlTestSupport::compareRowLists).disableSnapshots().input(Arrays.asList(LateItemsDropPTest.wm((long)0L), LateItemsDropPTest.jetRow(0L, 1L), LateItemsDropPTest.jetRow(1L, 2L), LateItemsDropPTest.wm((long)3L), LateItemsDropPTest.jetRow(2L, 2L), LateItemsDropPTest.jetRow(1L, 3L), LateItemsDropPTest.wm((long)5L))).expectOutput(Arrays.asList(LateItemsDropPTest.wm((long)0L), LateItemsDropPTest.jetRow(0L, 1L), LateItemsDropPTest.jetRow(1L, 2L), LateItemsDropPTest.wm((long)3L), LateItemsDropPTest.wm((long)5L)));
    }
}

