/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.SelectByKeyMapLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ValuesLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class LogicalSelectTest
extends OptimizerTestSupport {
    @BeforeClass
    public static void setUpClass() {
        LogicalSelectTest.initialize((int)1, null);
    }

    @Test
    public void test_requiresJob() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = 1", true, table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, FullScanLogicalRel.class)));
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT this || '-s' FROM m WHERE __key = 1", true, table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, FullScanLogicalRel.class)));
    }

    @Test
    public void test_selectWithoutWhere() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, FullScanLogicalRel.class)));
    }

    @Test
    public void test_selectByValue() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE this = '1'", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, FullScanLogicalRel.class)));
    }

    @Test
    public void test_selectByKeyAndValue() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = 1 AND this = '1'", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, FullScanLogicalRel.class)));
    }

    @Test
    public void test_selectByKeyAndKey() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = 1 AND __key = 2", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, ValuesLogicalRel.class)));
    }

    @Test
    public void test_selectByKeyOrKey() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = 1 OR __key = 2", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, FullScanLogicalRel.class)));
    }

    @Test
    public void test_selectWithConstantCondition() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 10L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE 1 = 1", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, FullScanLogicalRel.class)));
    }

    private Object[] literals() {
        return new Object[]{new Object[]{QueryDataType.BOOLEAN, "true"}, new Object[]{QueryDataType.BOOLEAN, "false"}, new Object[]{QueryDataType.TINYINT, Character.valueOf('1')}, new Object[]{QueryDataType.SMALLINT, Character.valueOf('1')}, new Object[]{QueryDataType.INT, Character.valueOf('1')}, new Object[]{QueryDataType.BIGINT, Character.valueOf('1')}, new Object[]{QueryDataType.DECIMAL, Character.valueOf('1')}, new Object[]{QueryDataType.REAL, Character.valueOf('1')}, new Object[]{QueryDataType.DOUBLE, Character.valueOf('1')}, new Object[]{QueryDataType.VARCHAR, "'string'"}, new Object[]{QueryDataType.TIME, "'12:23:34'"}, new Object[]{QueryDataType.DATE, "'2021-07-01'"}, new Object[]{QueryDataType.TIMESTAMP, "'2021-07-01T12:23:34'"}, new Object[]{QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, "'2021-07-01T12:23:34Z'"}, new Object[]{QueryDataType.OBJECT, "CAST(1 AS OBJECT)"}};
    }

    @Test
    @Parameters(method="literals")
    public void test_selectByKeyWithLiteral(QueryDataType type, String literalValue) {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, type), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = " + literalValue, table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, SelectByKeyMapLogicalRel.class)));
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE " + literalValue + " = __key", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, SelectByKeyMapLogicalRel.class)));
    }

    @Test
    public void test_selectByKeyWithLiteralExpression() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = 1 + 1", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, SelectByKeyMapLogicalRel.class)));
    }

    private Object[] types() {
        return new Object[]{new Object[]{QueryDataType.BOOLEAN}, new Object[]{QueryDataType.TINYINT}, new Object[]{QueryDataType.SMALLINT}, new Object[]{QueryDataType.INT}, new Object[]{QueryDataType.BIGINT}, new Object[]{QueryDataType.DECIMAL}, new Object[]{QueryDataType.REAL}, new Object[]{QueryDataType.DOUBLE}, new Object[]{QueryDataType.VARCHAR}, new Object[]{QueryDataType.TIME}, new Object[]{QueryDataType.DATE}, new Object[]{QueryDataType.TIMESTAMP}, new Object[]{QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME}, new Object[]{QueryDataType.OBJECT}};
    }

    @Test
    @Parameters(method="types")
    public void test_selectByKeyWithDynamicParam(QueryDataType type) {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, type), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = ?", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, SelectByKeyMapLogicalRel.class)));
    }

    @Test
    public void test_selectByKeyWithDynamicParamAndImplicitCastOnKey() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = ? + 1", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, FullScanLogicalRel.class)));
    }

    @Test
    public void test_selectByKeyWithDynamicParamExpression() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT * FROM m WHERE __key = CAST(? + 1 AS INT)", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, SelectByKeyMapLogicalRel.class)));
    }

    @Test
    public void test_selectByKeyWithProject() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT this FROM m WHERE __key = 1", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, SelectByKeyMapLogicalRel.class)));
    }

    @Test
    public void test_selectByKeyWithProjectExpression() {
        HazelcastTable table = LogicalSelectTest.partitionedTable("m", Arrays.asList(LogicalSelectTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSelectTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 1L);
        LogicalSelectTest.assertPlan((RelNode)this.optimizeLogical("SELECT this || '-s' FROM m WHERE __key = 1", table), LogicalSelectTest.plan(LogicalSelectTest.planRow(0, SelectByKeyMapLogicalRel.class)));
    }
}

