/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.InsertLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.InsertMapLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ValuesLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import junitparams.JUnitParamsRunner;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class LogicalInsertTest
extends OptimizerTestSupport {
    @BeforeClass
    public static void setUpClass() {
        LogicalInsertTest.initialize((int)1, null);
    }

    @Test
    public void test_requiresJob() {
        HazelcastTable table = LogicalInsertTest.partitionedTable("m", Arrays.asList(LogicalInsertTest.field(QueryPath.KEY, QueryDataType.INT), LogicalInsertTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalInsertTest.assertPlan((RelNode)this.optimizeLogical("INSERT INTO m VALUES (1, '1')", true, table), LogicalInsertTest.plan(LogicalInsertTest.planRow(0, InsertLogicalRel.class), LogicalInsertTest.planRow(1, ValuesLogicalRel.class)));
    }

    @Test
    public void test_insertValues() {
        HazelcastTable table = LogicalInsertTest.partitionedTable("m", Arrays.asList(LogicalInsertTest.field(QueryPath.KEY, QueryDataType.INT), LogicalInsertTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalInsertTest.assertPlan((RelNode)this.optimizeLogical("INSERT INTO m VALUES (1, '1')", table), LogicalInsertTest.plan(LogicalInsertTest.planRow(0, InsertMapLogicalRel.class)));
    }

    @Test
    public void test_insertMultiValues() {
        HazelcastTable table = LogicalInsertTest.partitionedTable("m", Arrays.asList(LogicalInsertTest.field(QueryPath.KEY, QueryDataType.INT), LogicalInsertTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalInsertTest.assertPlan((RelNode)this.optimizeLogical("INSERT INTO m VALUES (1, '1'), (2, '2')", table), LogicalInsertTest.plan(LogicalInsertTest.planRow(0, InsertLogicalRel.class), LogicalInsertTest.planRow(1, ValuesLogicalRel.class)));
    }

    @Test
    public void test_insertSelect() {
        HazelcastTable target = LogicalInsertTest.partitionedTable("m1", Arrays.asList(LogicalInsertTest.field(QueryPath.KEY, QueryDataType.INT), LogicalInsertTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        HazelcastTable source = LogicalInsertTest.partitionedTable("m2", Arrays.asList(LogicalInsertTest.field(QueryPath.KEY, QueryDataType.INT), LogicalInsertTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalInsertTest.assertPlan((RelNode)this.optimizeLogical("INSERT INTO m1 SELECT * FROM m2", target, source), LogicalInsertTest.plan(LogicalInsertTest.planRow(0, InsertLogicalRel.class), LogicalInsertTest.planRow(1, FullScanLogicalRel.class)));
    }
}

