/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.WatermarkThrottlingFrameSizeCalculator;
import com.hazelcast.jet.sql.impl.opt.physical.CalcPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.DropLateItemsPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ShouldNotExecuteRel;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowAggregatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.UnionPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public final class WatermarkThrottlingFrameSizeCalculatorTest
extends OptimizerTestSupport {
    private static ExpressionEvalContext MOCK_EEC;

    @BeforeClass
    public static void beforeClass() {
        WatermarkThrottlingFrameSizeCalculatorTest.initialize((int)1, null);
        MOCK_EEC = WatermarkThrottlingFrameSizeCalculatorTest.createExpressionEvalContext(new Object[0]);
    }

    @Test
    public void when_noSlidingWindowInTree_then_returnDefault() {
        HazelcastTable table = WatermarkThrottlingFrameSizeCalculatorTest.partitionedTable("map", Arrays.asList(WatermarkThrottlingFrameSizeCalculatorTest.field(QueryPath.KEY, QueryDataType.INT), WatermarkThrottlingFrameSizeCalculatorTest.field(QueryPath.VALUE, QueryDataType.INT)), 1L);
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, QueryDataType.INT);
        String sql = "SELECT * FROM TABLE(IMPOSE_ORDER((SELECT __key, this FROM map), DESCRIPTOR(this), 1))";
        PhysicalRel optimizedPhysicalRel = this.optimizePhysical("SELECT * FROM TABLE(IMPOSE_ORDER((SELECT __key, this FROM map), DESCRIPTOR(this), 1))", parameterTypes, table).getPhysical();
        WatermarkThrottlingFrameSizeCalculatorTest.assertPlan((RelNode)optimizedPhysicalRel, WatermarkThrottlingFrameSizeCalculatorTest.plan(WatermarkThrottlingFrameSizeCalculatorTest.planRow(0, DropLateItemsPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(1, FullScanPhysicalRel.class)));
        Assertions.assertThat((Object)optimizedPhysicalRel.getInput(0)).isInstanceOf(FullScanPhysicalRel.class);
        Assertions.assertThat((long)WatermarkThrottlingFrameSizeCalculator.calculate((PhysicalRel)optimizedPhysicalRel, (ExpressionEvalContext)MOCK_EEC)).isEqualTo(100L);
    }

    @Test
    public void when_shouldNotExecutePlan_then_returnDefault() {
        HazelcastTable table = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("_stream", 10);
        List<QueryDataType> parameterTypes = Collections.singletonList(QueryDataType.INT);
        String sql = "SELECT MAX(v) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER((SELECT * FROM TABLE(GENERATE_STREAM(10))), DESCRIPTOR(v), 1)))  , DESCRIPTOR(v) , 6, 3))";
        PhysicalRel optimizedPhysicalRel = this.optimizePhysical("SELECT MAX(v) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER((SELECT * FROM TABLE(GENERATE_STREAM(10))), DESCRIPTOR(v), 1)))  , DESCRIPTOR(v) , 6, 3))", parameterTypes, table).getPhysical();
        WatermarkThrottlingFrameSizeCalculatorTest.assertPlan((RelNode)optimizedPhysicalRel, WatermarkThrottlingFrameSizeCalculatorTest.plan(WatermarkThrottlingFrameSizeCalculatorTest.planRow(0, ShouldNotExecuteRel.class)));
        Assertions.assertThat((long)WatermarkThrottlingFrameSizeCalculator.calculate((PhysicalRel)optimizedPhysicalRel, (ExpressionEvalContext)MOCK_EEC)).isEqualTo(100L);
        ShouldNotExecuteRel sneRel = (ShouldNotExecuteRel)optimizedPhysicalRel;
        Assertions.assertThat((String)sneRel.message()).contains(new CharSequence[]{"Streaming aggregation is supported only for window aggregation"});
    }

    @Test
    public void when_onlySlidingWindowInTree_then_returnWindowSize() {
        HazelcastTable streamTable = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("_stream", 10);
        List<QueryDataType> parameterTypes = Collections.singletonList(QueryDataType.INT);
        String sql = "SELECT MAX(v) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER((SELECT * FROM TABLE(GENERATE_STREAM(10))), DESCRIPTOR(v), 1)))  , DESCRIPTOR(v) , 6, 3)) GROUP BY window_start, v";
        PhysicalRel optimizedPhysicalRel = this.optimizePhysical("SELECT MAX(v) FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER((SELECT * FROM TABLE(GENERATE_STREAM(10))), DESCRIPTOR(v), 1)))  , DESCRIPTOR(v) , 6, 3)) GROUP BY window_start, v", parameterTypes, streamTable).getPhysical();
        WatermarkThrottlingFrameSizeCalculatorTest.assertPlan((RelNode)optimizedPhysicalRel, WatermarkThrottlingFrameSizeCalculatorTest.plan(WatermarkThrottlingFrameSizeCalculatorTest.planRow(0, CalcPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(1, SlidingWindowAggregatePhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(2, CalcPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(3, FullScanPhysicalRel.class)));
        Assertions.assertThat((long)WatermarkThrottlingFrameSizeCalculator.calculate((PhysicalRel)optimizedPhysicalRel, (ExpressionEvalContext)MOCK_EEC)).isEqualTo(3L);
    }

    @Test
    public void when_twoConsecutiveSlidingWindowsAgg_then_returnGcdOfWindowsSize() {
        HazelcastTable table = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("s1", 100);
        HazelcastTable table2 = WatermarkThrottlingFrameSizeCalculatorTest.partitionedTable("map", Arrays.asList(WatermarkThrottlingFrameSizeCalculatorTest.field(QueryPath.KEY, QueryDataType.INT), WatermarkThrottlingFrameSizeCalculatorTest.field(QueryPath.VALUE, QueryDataType.INT)), 1L);
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, QueryDataType.INT);
        String sql = "SELECT window_end, window_end_inner, v, COUNT(v) FROM TABLE(HOP(   (SELECT v, window_end AS window_end_inner FROM        TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER((SELECT * FROM TABLE(GENERATE_STREAM(10))), DESCRIPTOR(v), 1)))       , DESCRIPTOR(v), 6, 2       )) GROUP BY v, window_end_inner   )   , DESCRIPTOR(window_end_inner), 15, 5)) GROUP BY window_end, window_end_inner, v";
        PhysicalRel optimizedPhysicalRel = this.optimizePhysical("SELECT window_end, window_end_inner, v, COUNT(v) FROM TABLE(HOP(   (SELECT v, window_end AS window_end_inner FROM        TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER((SELECT * FROM TABLE(GENERATE_STREAM(10))), DESCRIPTOR(v), 1)))       , DESCRIPTOR(v), 6, 2       )) GROUP BY v, window_end_inner   )   , DESCRIPTOR(window_end_inner), 15, 5)) GROUP BY window_end, window_end_inner, v", parameterTypes, table, table2).getPhysical();
        WatermarkThrottlingFrameSizeCalculatorTest.assertPlan((RelNode)optimizedPhysicalRel, WatermarkThrottlingFrameSizeCalculatorTest.plan(WatermarkThrottlingFrameSizeCalculatorTest.planRow(0, SlidingWindowAggregatePhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(1, CalcPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(2, SlidingWindowAggregatePhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(3, CalcPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(4, FullScanPhysicalRel.class)));
        Assertions.assertThat((long)WatermarkThrottlingFrameSizeCalculator.calculate((PhysicalRel)optimizedPhysicalRel, (ExpressionEvalContext)MOCK_EEC)).isEqualTo(1L);
    }

    @Test
    public void when_unionAboveSlidingWindows_then_returnGcdOfWindowsSize() {
        HazelcastTable table = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("s1", 1);
        HazelcastTable table2 = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("s2", 10);
        HazelcastTable table3 = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("s3", 100);
        List<QueryDataType> parameterTypes = Collections.singletonList(QueryDataType.INT);
        int expectedGcd = 12;
        String query = "SELECT * FROM " + WatermarkThrottlingFrameSizeCalculatorTest.hop("s1", expectedGcd * 4, expectedGcd) + " UNION ALL " + WatermarkThrottlingFrameSizeCalculatorTest.hop("s2", expectedGcd * 3, expectedGcd) + " UNION ALL " + WatermarkThrottlingFrameSizeCalculatorTest.hop("s3", expectedGcd * 2, expectedGcd);
        PhysicalRel optimizedPhysicalRel = this.optimizePhysical(query, parameterTypes, table, table2, table3).getPhysical();
        WatermarkThrottlingFrameSizeCalculatorTest.assertPlan((RelNode)optimizedPhysicalRel, WatermarkThrottlingFrameSizeCalculatorTest.plan(WatermarkThrottlingFrameSizeCalculatorTest.planRow(0, UnionPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(1, SlidingWindowAggregatePhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(2, CalcPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(3, FullScanPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(1, SlidingWindowAggregatePhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(2, CalcPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(3, FullScanPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(1, SlidingWindowAggregatePhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(2, CalcPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(3, FullScanPhysicalRel.class)));
        Assertions.assertThat((long)WatermarkThrottlingFrameSizeCalculator.calculate((PhysicalRel)optimizedPhysicalRel, (ExpressionEvalContext)MOCK_EEC)).isEqualTo((long)expectedGcd);
    }

    @Test
    public void when_streamToStreamJoin_then_returnMinPostponeTime() {
        HazelcastTable table = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("t1", 1);
        HazelcastTable table2 = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("t2", 10);
        HazelcastTable table3 = WatermarkThrottlingFrameSizeCalculatorTest.streamGeneratorTable("t3", 100);
        List<QueryDataType> parameterTypes = Collections.singletonList(QueryDataType.INT);
        int expectedWindowSize = 20;
        String query = "SELECT * FROM " + WatermarkThrottlingFrameSizeCalculatorTest.joinSubQuery("t1", "s1", 1) + " JOIN " + WatermarkThrottlingFrameSizeCalculatorTest.joinSubQuery("t2", "s2", 2) + " ON s1.v BETWEEN s2.v - 180 AND s2.v + 70  JOIN " + WatermarkThrottlingFrameSizeCalculatorTest.joinSubQuery("t3", "s3", 3) + " ON s3.v BETWEEN s1.v - 100 AND s1.v + 100 ";
        PhysicalRel optPhysicalRel = this.optimizePhysical(query, parameterTypes, table, table2, table3).getPhysical();
        WatermarkThrottlingFrameSizeCalculatorTest.assertPlan((RelNode)optPhysicalRel, WatermarkThrottlingFrameSizeCalculatorTest.plan(WatermarkThrottlingFrameSizeCalculatorTest.planRow(0, StreamToStreamJoinPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(1, StreamToStreamJoinPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(2, FullScanPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(2, FullScanPhysicalRel.class), WatermarkThrottlingFrameSizeCalculatorTest.planRow(1, FullScanPhysicalRel.class)));
        Assertions.assertThat((long)WatermarkThrottlingFrameSizeCalculator.calculate((PhysicalRel)optPhysicalRel, (ExpressionEvalContext)MOCK_EEC)).isEqualTo((long)expectedWindowSize);
    }

    private static String hop(String name, int windowSize, int windowSlide) {
        return "(SELECT window_start, MAX(v) AS res FROM TABLE(HOP(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(v), 1)))  , DESCRIPTOR(v) , " + windowSize + " , " + windowSlide + ")) GROUP BY window_start) ";
    }

    private static String joinSubQuery(String stream, String alias, int lag) {
        return "(SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + stream + ", DESCRIPTOR(v), " + lag + "))) AS " + alias;
    }
}

