/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.LimitPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SortPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;

public class LimitOffsetScanOptimizerTest
extends OptimizerTestSupport {
    @BeforeClass
    public static void beforeClass() throws Exception {
        LimitOffsetScanOptimizerTest.initialize((int)1, null);
    }

    @Test
    public void test_LimitAndIndexScan_arePresentInPlan() {
        String mapName = LimitOffsetScanOptimizerTest.randomName();
        IMap map = LimitOffsetScanOptimizerTest.instance().getMap(mapName);
        map.addIndex(IndexType.SORTED, new String[]{"this"});
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)String.valueOf(i));
        }
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, QueryDataType.VARCHAR);
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("this", QueryDataType.VARCHAR, false, QueryPath.VALUE_PATH));
        HazelcastTable table = LimitOffsetScanOptimizerTest.partitionedTable(mapName, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)LimitOffsetScanOptimizerTest.mapContainer(map), mapTableFields), map.size());
        String sql = "SELECT * FROM " + mapName + " ORDER BY this DESC LIMIT 5 OFFSET 3";
        LimitOffsetScanOptimizerTest.assertPlan((RelNode)this.optimizePhysical(sql, parameterTypes, table).getPhysical(), LimitOffsetScanOptimizerTest.plan(LimitOffsetScanOptimizerTest.planRow(0, LimitPhysicalRel.class), LimitOffsetScanOptimizerTest.planRow(1, IndexScanMapPhysicalRel.class)));
    }

    @Test
    public void test_Limit_Sort_Scan_arePresentInPlan() {
        String mapName = LimitOffsetScanOptimizerTest.randomName();
        IMap map = LimitOffsetScanOptimizerTest.instance().getMap(mapName);
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)String.valueOf(i));
        }
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, QueryDataType.VARCHAR);
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("this", QueryDataType.VARCHAR, false, QueryPath.VALUE_PATH));
        HazelcastTable table = LimitOffsetScanOptimizerTest.partitionedTable(mapName, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)LimitOffsetScanOptimizerTest.mapContainer(map), mapTableFields), map.size());
        String sql = "SELECT * FROM " + mapName + " ORDER BY this DESC LIMIT 5 OFFSET 3";
        LimitOffsetScanOptimizerTest.assertPlan((RelNode)this.optimizePhysical(sql, parameterTypes, table).getPhysical(), LimitOffsetScanOptimizerTest.plan(LimitOffsetScanOptimizerTest.planRow(0, LimitPhysicalRel.class), LimitOffsetScanOptimizerTest.planRow(1, SortPhysicalRel.class), LimitOffsetScanOptimizerTest.planRow(2, FullScanPhysicalRel.class)));
    }
}

