/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.misc;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlNoSerializationTest
extends OptimizerTestSupport {
    private static final String MAP_NAME = "map";
    private static final int KEY_COUNT = 100;
    @Parameterized.Parameter
    public boolean useIndex;
    private static volatile boolean failOnSerialization;

    @Parameterized.Parameters(name="useIndex:{0}")
    public static Collection<Object> parameters() {
        return Arrays.asList(false, true);
    }

    @BeforeClass
    public static void beforeClass() {
        SqlNoSerializationTest.initialize((int)1, (Config)SqlNoSerializationTest.smallInstanceConfig());
    }

    @Before
    public void before() {
        HashMap<Key, Value> localMap = new HashMap<Key, Value>();
        for (int i = 0; i < 100; ++i) {
            localMap.put(new Key(i), new Value(i));
        }
        SqlNoSerializationTest.createMapping(MAP_NAME, Key.class, Value.class);
        IMap map = SqlNoSerializationTest.instance().getMap(MAP_NAME);
        map.putAll(localMap);
        if (this.useIndex) {
            map.addIndex(new IndexConfig(IndexType.HASH, new String[]{"val"}));
        }
        failOnSerialization = true;
    }

    @After
    public void after() {
        failOnSerialization = false;
    }

    @Test
    public void test() {
        this.check("SELECT __key, this FROM map WHERE val = 1", this.useIndex);
    }

    private void check(String sql, boolean expectedIndexUsage) {
        this.checkIndexUsage(new SqlStatement(sql), expectedIndexUsage);
        try (SqlResult res = SqlNoSerializationTest.instance().getSql().execute(sql, new Object[0]);){
            int count = 0;
            for (SqlRow row : res) {
                Object key = row.getObject(0);
                Object value = row.getObject(1);
                Assert.assertTrue((boolean)(key instanceof Key));
                Assert.assertTrue((boolean)(value instanceof Value));
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    private void checkIndexUsage(SqlStatement statement, boolean expectedIndexUsage) {
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, QueryDataType.OBJECT, QueryDataType.INT);
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("this", QueryDataType.OBJECT, false, QueryPath.VALUE_PATH), new MapTableField("val", QueryDataType.INT, false, new QueryPath("val", false)));
        HazelcastTable table = SqlNoSerializationTest.partitionedTable(MAP_NAME, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)SqlNoSerializationTest.mapContainer(SqlNoSerializationTest.instance().getMap(MAP_NAME)), mapTableFields), 100L);
        OptimizerTestSupport.Result optimizationResult = this.optimizePhysical(statement.getSql(), parameterTypes, table);
        SqlNoSerializationTest.assertPlan((RelNode)optimizationResult.getLogical(), SqlNoSerializationTest.plan(SqlNoSerializationTest.planRow(0, FullScanLogicalRel.class)));
        if (expectedIndexUsage) {
            SqlNoSerializationTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlNoSerializationTest.plan(SqlNoSerializationTest.planRow(0, IndexScanMapPhysicalRel.class)));
        } else {
            SqlNoSerializationTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlNoSerializationTest.plan(SqlNoSerializationTest.planRow(0, FullScanPhysicalRel.class)));
        }
    }

    public static class Key
    implements Externalizable {
        public int key;

        public Key() {
        }

        private Key(int key) {
            this.key = key;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.key);
            if (failOnSerialization) {
                throw new IOException("Key serialization must not happen.");
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.key = in.readInt();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return this.key == that.key;
        }

        public int hashCode() {
            return this.key;
        }
    }

    public static class Value
    implements Externalizable {
        public int val;

        public Value() {
        }

        private Value(int val) {
            this.val = val;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.val);
            if (failOnSerialization) {
                throw new IOException("Value serialization must not happen.");
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.val = in.readInt();
        }
    }
}

