/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.misc;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.SqlInternalService;
import com.hazelcast.sql.impl.SqlServiceImpl;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlClientCursorCleanupTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private static volatile boolean fail;
    private final TestHazelcastFactory factory = new TestHazelcastFactory();
    private HazelcastInstance member;
    private HazelcastInstance client;

    @Before
    public void before() {
        this.member = this.factory.newHazelcastInstance(SqlClientCursorCleanupTest.smallInstanceConfig());
        this.client = this.factory.newHazelcastClient(new ClientConfig());
        this.member.getConfig().addMapConfig(new MapConfig().setName(MAP_NAME).setInMemoryFormat(InMemoryFormat.OBJECT));
    }

    @After
    public void after() {
        fail = false;
        this.factory.shutdownAll();
        this.member = null;
        this.client = null;
    }

    @Test
    public void testExceptionOnExecute() {
        IMap map = this.member.getMap(MAP_NAME);
        map.put((Object)0, (Object)new Person());
        map.put((Object)1, (Object)new Person());
        fail = true;
        try {
            SqlResult result = this.client.getSql().execute(SqlClientCursorCleanupTest.statement());
            for (SqlRow sqlRow : result) {
            }
            Assert.fail((String)"Must fail");
        }
        catch (Exception e) {
            this.assertNoState();
        }
    }

    @Test
    public void testExceptionOnFetch() {
        IMap map = this.member.getMap(MAP_NAME);
        map.put((Object)0, (Object)new Person());
        map.put((Object)1, (Object)new Person());
        map.put((Object)2, (Object)new Person());
        try {
            SqlResult result = this.client.getSql().execute(SqlClientCursorCleanupTest.statement());
            for (SqlRow ignore : result) {
                fail = true;
            }
            Assert.fail((String)"Must fail");
        }
        catch (Exception e) {
            this.assertNoState();
        }
    }

    private void assertNoState() {
        SqlInternalService service = ((SqlServiceImpl)this.member.getSql()).getInternalService();
        Assert.assertEquals((long)0L, (long)service.getResultRegistry().getResultCount());
        Assert.assertEquals((long)0L, (long)service.getClientStateRegistry().getCursorCount());
    }

    private static SqlStatement statement() {
        return new SqlStatement("SELECT * FROM map").setCursorBufferSize(1);
    }

    public static class Person
    implements DataSerializable {
        public void writeData(ObjectDataOutput out) throws IOException {
            if (fail) {
                throw new IOException();
            }
        }

        public void readData(ObjectDataInput in) {
        }
    }
}

