/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.extract;

import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.jet.sql.impl.extract.JsonQueryTarget;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class JsonQueryTargetTest {
    private Object[] values() throws IOException {
        String json = "{\"string\": \"string\", \"boolean\": true, \"byte\": 127, \"short\": 32767, \"int\": 2147483647, \"long\": 9223372036854775807, \"float\": 1234567890.1, \"double\": 123451234567890.1, \"decimal\": \"9223372036854775.123\", \"time\": \"12:23:34\", \"date\": \"2020-09-09\", \"timestamp\": \"2020-09-09T12:23:34.1\", \"timestampTz\": \"2020-09-09T12:23:34.2Z\", \"null\": null, \"object\": {}, \"co\": {\"nested\":{}}}";
        return new Object[]{new Object[]{json}, new Object[]{json.getBytes(StandardCharsets.UTF_8)}, new Object[]{JsonUtil.mapFrom((Object)json)}};
    }

    @Test
    @Parameters(method="values")
    public void test_get(Object value) {
        JsonQueryTarget target = new JsonQueryTarget();
        QueryExtractor topExtractor = target.createExtractor(null, QueryDataType.OBJECT);
        QueryExtractor nonExistingExtractor = target.createExtractor("nonExisting", QueryDataType.OBJECT);
        QueryExtractor stringExtractor = target.createExtractor("string", QueryDataType.VARCHAR);
        QueryExtractor booleanExtractor = target.createExtractor("boolean", QueryDataType.BOOLEAN);
        QueryExtractor byteExtractor = target.createExtractor("byte", QueryDataType.TINYINT);
        QueryExtractor shortExtractor = target.createExtractor("short", QueryDataType.SMALLINT);
        QueryExtractor intExtractor = target.createExtractor("int", QueryDataType.INT);
        QueryExtractor longExtractor = target.createExtractor("long", QueryDataType.BIGINT);
        QueryExtractor floatExtractor = target.createExtractor("float", QueryDataType.REAL);
        QueryExtractor doubleExtractor = target.createExtractor("double", QueryDataType.DOUBLE);
        QueryExtractor decimalExtractor = target.createExtractor("decimal", QueryDataType.DECIMAL);
        QueryExtractor timeExtractor = target.createExtractor("time", QueryDataType.TIME);
        QueryExtractor dateExtractor = target.createExtractor("date", QueryDataType.DATE);
        QueryExtractor timestampExtractor = target.createExtractor("timestamp", QueryDataType.TIMESTAMP);
        QueryExtractor timestampTzExtractor = target.createExtractor("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME);
        QueryExtractor nullExtractor = target.createExtractor("null", QueryDataType.OBJECT);
        QueryExtractor objectExtractor = target.createExtractor("object", QueryDataType.OBJECT);
        target.setTarget(value, null);
        Assertions.assertThat((Object)topExtractor.get()).isInstanceOf(Map.class);
        Assertions.assertThat((Object)nonExistingExtractor.get()).isNull();
        Assertions.assertThat((Object)stringExtractor.get()).isEqualTo((Object)"string");
        Assertions.assertThat((Object)booleanExtractor.get()).isEqualTo((Object)true);
        Assertions.assertThat((Object)byteExtractor.get()).isEqualTo((Object)127);
        Assertions.assertThat((Object)shortExtractor.get()).isEqualTo((Object)Short.MAX_VALUE);
        Assertions.assertThat((Object)intExtractor.get()).isEqualTo((Object)Integer.MAX_VALUE);
        Assertions.assertThat((Object)longExtractor.get()).isEqualTo((Object)Long.MAX_VALUE);
        Assertions.assertThat((Object)floatExtractor.get()).isEqualTo((Object)Float.valueOf(1.234568E9f));
        Assertions.assertThat((Object)doubleExtractor.get()).isEqualTo((Object)1.234512345678901E14);
        Assertions.assertThat((Object)decimalExtractor.get()).isEqualTo((Object)new BigDecimal("9223372036854775.123"));
        Assertions.assertThat((Object)timeExtractor.get()).isEqualTo((Object)LocalTime.of(12, 23, 34));
        Assertions.assertThat((Object)dateExtractor.get()).isEqualTo((Object)LocalDate.of(2020, 9, 9));
        Assertions.assertThat((Object)timestampExtractor.get()).isEqualTo((Object)LocalDateTime.of(2020, 9, 9, 12, 23, 34, 100000000));
        Assertions.assertThat((Object)timestampTzExtractor.get()).isEqualTo((Object)OffsetDateTime.of(2020, 9, 9, 12, 23, 34, 200000000, ZoneOffset.UTC));
        Assertions.assertThat((Object)nullExtractor.get()).isNull();
        Assertions.assertThat((Object)objectExtractor.get()).isNotNull();
    }
}

