/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.extract;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.impl.extract.HazelcastJsonQueryTarget;
import com.hazelcast.jet.sql.impl.extract.HazelcastJsonQueryTargetDescriptor;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.extract.QueryTarget;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class HazelcastJsonQueryTargetDescriptorTest {
    private static final InternalSerializationService SERIALIZATION_SERVICE = new DefaultSerializationServiceBuilder().build();

    @Test
    @Parameters(value={"true", "false"})
    public void test_create(boolean key) {
        Extractors extractors = Extractors.newBuilder((InternalSerializationService)SERIALIZATION_SERVICE).build();
        HazelcastJsonQueryTargetDescriptor descriptor = HazelcastJsonQueryTargetDescriptor.INSTANCE;
        QueryTarget target = descriptor.create(SERIALIZATION_SERVICE, extractors, key);
        Assertions.assertThat((Object)target).isInstanceOf(HazelcastJsonQueryTarget.class);
    }

    @Test
    public void test_serialization() {
        HazelcastJsonQueryTargetDescriptor original = HazelcastJsonQueryTargetDescriptor.INSTANCE;
        HazelcastJsonQueryTargetDescriptor serialized = (HazelcastJsonQueryTargetDescriptor)SERIALIZATION_SERVICE.toObject((Object)SERIALIZATION_SERVICE.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualTo((Object)original);
    }
}

