/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.string.StringFunctionIntegrationTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class TrimSimpleFunctionIntegrationTest
extends StringFunctionIntegrationTestSupport {
    @Parameterized.Parameter
    public Mode mode;

    @Parameterized.Parameters(name="name: {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Mode.TRIM}, {Mode.BTRIM}, {Mode.LTRIM}, {Mode.RTRIM});
    }

    @Override
    protected String functionName() {
        return this.mode.name();
    }

    @Override
    protected SqlColumnType resultType() {
        return SqlColumnType.VARCHAR;
    }

    @Override
    protected void checkSupportedColumns() {
        this.checkColumn(new ExpressionValue.CharacterVal(), null);
        this.checkColumn(new ExpressionValue.StringVal(), null);
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('a')), "a");
        this.checkColumn(new ExpressionValue.StringVal().field1(""), "");
        this.checkColumn(new ExpressionValue.StringVal().field1("a"), "a");
        this.checkColumn(new ExpressionValue.StringVal().field1("abc"), this.trim("abc"));
        this.checkColumn(new ExpressionValue.StringVal().field1("abc "), this.trim("abc "));
        this.checkColumn(new ExpressionValue.StringVal().field1("abc   "), this.trim("abc   "));
        this.checkColumn(new ExpressionValue.StringVal().field1(" abc"), this.trim(" abc"));
        this.checkColumn(new ExpressionValue.StringVal().field1("   abc"), this.trim("   abc"));
        this.checkColumn(new ExpressionValue.StringVal().field1(" abc "), this.trim(" abc "));
        this.checkColumn(new ExpressionValue.StringVal().field1("   abc   "), this.trim("   abc   "));
    }

    @Override
    protected void checkSupportedLiterals() {
        this.checkLiteral("null", null);
        this.checkLiteral("''", "");
        this.checkLiteral("'a'", this.trim("a"));
        this.checkLiteral("'abc'", this.trim("abc"));
        this.checkLiteral("'abc '", this.trim("abc "));
        this.checkLiteral("'abc   '", this.trim("abc   "));
        this.checkLiteral("' abc'", this.trim(" abc"));
        this.checkLiteral("'   abc'", this.trim("   abc"));
        this.checkLiteral("' abc '", this.trim(" abc "));
        this.checkLiteral("'   abc   '", this.trim("   abc   "));
    }

    @Override
    protected void checkSupportedParameters() {
        this.checkParameter(null, null);
        this.checkParameter(Character.valueOf('a'), this.trim("a"));
        this.checkParameter("", "");
        this.checkParameter("a", this.trim("a"));
        this.checkParameter("abc", this.trim("abc"));
        this.checkParameter("abc ", this.trim("abc "));
        this.checkParameter("abc   ", this.trim("abc   "));
        this.checkParameter(" abc", this.trim(" abc"));
        this.checkParameter("   abc", this.trim("   abc"));
        this.checkParameter(" abc ", this.trim(" abc "));
        this.checkParameter("   abc   ", this.trim("   abc   "));
    }

    private String trim(String value) {
        if (value == null) {
            return null;
        }
        if (this.mode.left && this.mode.right) {
            value = value.trim();
        } else if (this.mode.left) {
            while (value.startsWith(" ")) {
                value = value.substring(1);
            }
        } else {
            while (value.endsWith(" ")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        return value;
    }

    private static enum Mode {
        TRIM(true, true),
        BTRIM(true, true),
        LTRIM(true, false),
        RTRIM(false, true);

        private final boolean left;
        private final boolean right;

        private Mode(boolean left, boolean right) {
            this.left = left;
            this.right = right;
        }
    }
}

