/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.string.StringFunctionIntegrationTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.InitcapFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class InitcapFunctionIntegrationTest
extends StringFunctionIntegrationTestSupport {
    @Override
    protected String functionName() {
        return "INITCAP";
    }

    @Override
    protected SqlColumnType resultType() {
        return SqlColumnType.VARCHAR;
    }

    @Override
    protected void checkSupportedColumns() {
        this.checkColumn(new ExpressionValue.CharacterVal(), null);
        this.checkColumn(new ExpressionValue.StringVal(), null);
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('a')), "A");
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('A')), "A");
        this.checkColumn(new ExpressionValue.StringVal().field1(""), "");
        this.checkColumn(new ExpressionValue.StringVal().field1("a"), "A");
        this.checkColumn(new ExpressionValue.StringVal().field1("A"), "A");
        this.checkColumn(new ExpressionValue.StringVal().field1("first"), "First");
        this.checkColumn(new ExpressionValue.StringVal().field1("first second"), "First Second");
        this.checkColumn(new ExpressionValue.StringVal().field1("-first second"), "-First Second");
        this.checkColumn(new ExpressionValue.StringVal().field1("first-second"), "First-Second");
    }

    @Override
    protected void checkSupportedLiterals() {
        this.checkLiteral("null", null);
        this.checkLiteral("''", "");
        this.checkLiteral("'a'", "A");
        this.checkLiteral("'A'", "A");
        this.checkLiteral("'first'", "First");
        this.checkLiteral("'first second'", "First Second");
        this.checkLiteral("'-first second'", "-First Second");
        this.checkLiteral("'first-second'", "First-Second");
    }

    @Override
    protected void checkSupportedParameters() {
        this.checkParameter(null, null);
        this.checkParameter("", "");
        this.checkParameter(Character.valueOf('a'), "A");
        this.checkParameter(Character.valueOf('A'), "A");
        this.checkParameter("a", "A");
        this.checkParameter("A", "A");
        this.checkParameter("first", "First");
        this.checkParameter("first second", "First Second");
        this.checkParameter("-first second", "-First Second");
        this.checkParameter("first-second", "First-Second");
    }

    @Test
    public void testEquals() {
        InitcapFunction function = InitcapFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        InitcapFunctionIntegrationTest.checkEquals(function, InitcapFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR)), true);
        InitcapFunctionIntegrationTest.checkEquals(function, InitcapFunction.create((Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)), false);
    }

    @Test
    public void testSerialization() {
        InitcapFunction original = InitcapFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        InitcapFunction restored = (InitcapFunction)InitcapFunctionIntegrationTest.serializeAndCheck(original, 59);
        InitcapFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

