/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.string.StringFunctionIntegrationTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.AsciiFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AsciiFunctionIntegrationTest
extends StringFunctionIntegrationTestSupport {
    @Override
    protected String functionName() {
        return "ASCII";
    }

    @Override
    protected SqlColumnType resultType() {
        return SqlColumnType.INTEGER;
    }

    @Override
    protected void checkSupportedColumns() {
        this.checkColumn(new ExpressionValue.CharacterVal(), null);
        this.checkColumn(new ExpressionValue.StringVal(), null);
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('a')), AsciiFunctionIntegrationTest.codePoint(Character.valueOf('a')));
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('A')), AsciiFunctionIntegrationTest.codePoint(Character.valueOf('A')));
        this.checkColumn(new ExpressionValue.StringVal().field1("abc"), AsciiFunctionIntegrationTest.codePoint(Character.valueOf('a')));
        this.checkColumn(new ExpressionValue.StringVal().field1("ABC"), AsciiFunctionIntegrationTest.codePoint(Character.valueOf('A')));
    }

    @Override
    protected void checkSupportedLiterals() {
        this.checkLiteral("null", AsciiFunctionIntegrationTest.codePoint(null));
        this.checkLiteral("'a'", AsciiFunctionIntegrationTest.codePoint(Character.valueOf('a')));
        this.checkLiteral("'A'", AsciiFunctionIntegrationTest.codePoint(Character.valueOf('A')));
        this.checkLiteral("'abc'", AsciiFunctionIntegrationTest.codePoint(Character.valueOf('a')));
        this.checkLiteral("'ABC'", AsciiFunctionIntegrationTest.codePoint(Character.valueOf('A')));
    }

    @Override
    protected void checkSupportedParameters() {
        this.checkParameter(null, null);
        this.checkParameter("", 0);
        this.checkParameter(Character.valueOf('a'), AsciiFunctionIntegrationTest.codePoint(Character.valueOf('a')));
        this.checkParameter(Character.valueOf('A'), AsciiFunctionIntegrationTest.codePoint(Character.valueOf('A')));
        this.checkParameter("a", AsciiFunctionIntegrationTest.codePoint(Character.valueOf('a')));
        this.checkParameter("A", AsciiFunctionIntegrationTest.codePoint(Character.valueOf('A')));
        this.checkParameter("abc", AsciiFunctionIntegrationTest.codePoint(Character.valueOf('a')));
        this.checkParameter("ABC", AsciiFunctionIntegrationTest.codePoint(Character.valueOf('A')));
    }

    @Test
    public void testEquals() {
        AsciiFunction function = AsciiFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        AsciiFunctionIntegrationTest.checkEquals(function, AsciiFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR)), true);
        AsciiFunctionIntegrationTest.checkEquals(function, AsciiFunction.create((Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)), false);
    }

    @Test
    public void testSerialization() {
        AsciiFunction original = AsciiFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        AsciiFunction restored = (AsciiFunction)AsciiFunctionIntegrationTest.serializeAndCheck(original, 57);
        AsciiFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    private static Integer codePoint(Character value) {
        if (value == null) {
            return null;
        }
        return value.toString().codePoints().toArray()[0];
    }
}

