/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.predicate;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.NotPredicate;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class NotPredicateIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void test_column() {
        this.putAndCheck(true, false);
        this.putAndCheck(false, true);
        this.putAndCheck(null, null);
        this.putAndCheckFailure(Character.valueOf('t'), NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure("true", NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure((byte)1, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.TINYINT), new Object[0]);
        this.putAndCheckFailure((short)1, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.SMALLINT), new Object[0]);
        this.putAndCheckFailure(1, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(1L, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(BigInteger.ONE, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ONE, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(1.0f), NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, NotPredicateIntegrationTest.sql("this"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.OBJECT), new Object[0]);
    }

    private void putAndCheck(Boolean value, Boolean expectedResult) {
        this.put(NotPredicateIntegrationTest.booleanValue1(value));
        this.check("field1", expectedResult, new Object[0]);
    }

    @Test
    public void test_parameter() {
        this.put(1);
        this.check("?", false, true);
        this.check("?", true, false);
        this.check("?", null, new Object[]{null});
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.VARCHAR), Character.valueOf('t'));
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.VARCHAR), "true");
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.TINYINT), (byte)1);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.SMALLINT), (short)1);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.INTEGER), 1);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.BIGINT), 1L);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL), BigInteger.ONE);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL), BigDecimal.ONE);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.DOUBLE), 1.0);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure0(NotPredicateIntegrationTest.sql("?"), 2000, NotPredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void test_literal() {
        this.put(1);
        this.check("true", false, new Object[0]);
        this.check("false", true, new Object[0]);
        this.check("null", null, new Object[0]);
        this.checkFailure0(NotPredicateIntegrationTest.sql("'true'"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0(NotPredicateIntegrationTest.sql("1"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.TINYINT), new Object[0]);
        this.checkFailure0(NotPredicateIntegrationTest.sql("1.1"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure0(NotPredicateIntegrationTest.sql("1.1E1"), 1008, NotPredicateIntegrationTest.signatureErrorOperator("NOT", SqlColumnType.DOUBLE), new Object[0]);
    }

    private void check(String operand, Boolean expectedResult, Object ... params) {
        String sql = NotPredicateIntegrationTest.sql(operand);
        List<SqlRow> rows = NotPredicateIntegrationTest.execute(sql, params);
        Assert.assertEquals((long)1L, (long)rows.size());
        SqlRow row = rows.get(0);
        Assert.assertEquals((long)1L, (long)row.getMetadata().getColumnCount());
        Assert.assertEquals((Object)SqlColumnType.BOOLEAN, (Object)row.getMetadata().getColumn(0).getType());
        Assert.assertEquals((Object)expectedResult, (Object)row.getObject(0));
    }

    private static String sql(String operand) {
        return "SELECT NOT " + operand + " FROM map";
    }

    @Test
    public void testEquality() {
        NotPredicateIntegrationTest.checkEquals(NotPredicateIntegrationTest.not(true), NotPredicateIntegrationTest.not(true), true);
        NotPredicateIntegrationTest.checkEquals(NotPredicateIntegrationTest.not(true), NotPredicateIntegrationTest.not(false), false);
    }

    @Test
    public void testSerialization() {
        NotPredicate original = NotPredicateIntegrationTest.not(true);
        NotPredicate restored = (NotPredicate)NotPredicateIntegrationTest.serializeAndCheck(original, 44);
        NotPredicateIntegrationTest.checkEquals(original, restored, true);
    }

    private static NotPredicate not(Boolean value) {
        return NotPredicate.create((Expression)ConstantExpression.create((Object)value, (QueryDataType)QueryDataType.BOOLEAN));
    }
}

