/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.predicate;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.AndPredicate;
import com.hazelcast.sql.impl.expression.predicate.OrPredicate;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AndOrPredicateIntegrationTest
extends ExpressionTestSupport {
    @Parameterized.Parameter
    public Mode mode;

    @Parameterized.Parameters(name="mode: {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({Mode.AND}, {Mode.OR});
    }

    @Test
    public void testArg2() {
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue2(true, true), "field1", "field2", this.result(true, true), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue2(true, false), "field1", "field2", this.result(true, false), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue2(true, null), "field1", "field2", this.result(true, null), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue2(false, false), "field1", "field2", this.result(false, false), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue2(false, null), "field1", "field2", this.result(false, null), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue2(null, null), "field1", "field2", this.result(null, null), new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanStringVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.VARCHAR, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanByteVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.TINYINT, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanShortVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.SMALLINT, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanIntegerVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.INTEGER, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanLongVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.BIGINT, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanBigIntegerVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanBigDecimalVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanFloatVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.REAL, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanDoubleVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.DOUBLE, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanLocalDateVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.DATE, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanLocalTimeVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.TIME, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanLocalDateTimeVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.TIMESTAMP, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanOffsetDateTimeVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionBiValue.BooleanObjectVal(), "field1", "field2", SqlColumnType.BOOLEAN, SqlColumnType.OBJECT, new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "true", this.result(true, true), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "false", this.result(true, false), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "null", this.result(true, null), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(false), "field1", "true", this.result(false, true), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(false), "field1", "false", this.result(false, false), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(false), "field1", "null", this.result(false, null), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(null), "field1", "true", this.result(null, true), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(null), "field1", "false", this.result(null, false), new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(null), "field1", "null", this.result(null, null), new Object[0]);
        this.putCheckFailureSignatureCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "'true'", SqlColumnType.BOOLEAN, SqlColumnType.VARCHAR, new Object[0]);
        this.putCheckFailureSignatureCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "1", SqlColumnType.BOOLEAN, SqlColumnType.TINYINT, new Object[0]);
        this.putCheckFailureSignatureCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "1.1", SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL, new Object[0]);
        this.putCheckFailureSignatureCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "1.1E1", SqlColumnType.BOOLEAN, SqlColumnType.DOUBLE, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.StringVal(), "field1", "true", SqlColumnType.VARCHAR, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.ByteVal(), "field1", "true", SqlColumnType.TINYINT, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.ShortVal(), "field1", "true", SqlColumnType.SMALLINT, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.IntegerVal(), "field1", "true", SqlColumnType.INTEGER, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.LongVal(), "field1", "true", SqlColumnType.BIGINT, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.BigIntegerVal(), "field1", "true", SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.BigDecimalVal(), "field1", "true", SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.FloatVal(), "field1", "true", SqlColumnType.REAL, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.DoubleVal(), "field1", "true", SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.LocalDateVal(), "field1", "true", SqlColumnType.DATE, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.LocalTimeVal(), "field1", "true", SqlColumnType.TIME, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.LocalDateTimeVal(), "field1", "true", SqlColumnType.TIMESTAMP, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(new ExpressionValue.OffsetDateTimeVal(), "field1", "true", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckFailureSignatureCommute(OBJECT_VAL, "field1", "true", SqlColumnType.OBJECT, SqlColumnType.BOOLEAN, new Object[0]);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", this.result(true, true), true);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", this.result(true, false), false);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", this.result(true, null), new Object[]{null});
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(false), "field1", "?", this.result(false, true), true);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(false), "field1", "?", this.result(false, false), false);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(false), "field1", "?", this.result(false, null), new Object[]{null});
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(null), "field1", "?", this.result(null, true), true);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(null), "field1", "?", this.result(null, false), false);
        this.putCheckCommute(AndOrPredicateIntegrationTest.booleanValue1(null), "field1", "?", this.result(null, null), new Object[]{null});
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.VARCHAR, "1");
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.TINYINT, (byte)1);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.SMALLINT, (short)1);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.INTEGER, 1);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.BIGINT, 1L);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.DECIMAL, BigInteger.ONE);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.REAL, Float.valueOf(1.0f));
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.DOUBLE, 1.0);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.DATE, LOCAL_DATE_VAL);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.TIME, LOCAL_TIME_VAL);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.TIMESTAMP, LOCAL_DATE_TIME_VAL);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OFFSET_DATE_TIME_VAL);
        this.putCheckFailureParameterCommute(AndOrPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, SqlColumnType.OBJECT, OBJECT_VAL);
        this.putCheckFailureSignatureCommute("true", "this", "?", SqlColumnType.VARCHAR, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute((byte)1, "this", "?", SqlColumnType.TINYINT, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute((short)1, "this", "?", SqlColumnType.SMALLINT, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(1, "this", "?", SqlColumnType.INTEGER, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(1L, "this", "?", SqlColumnType.BIGINT, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(BigInteger.ONE, "this", "?", SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(BigDecimal.ONE, "this", "?", SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(Float.valueOf(1.0f), "this", "?", SqlColumnType.REAL, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(1.0, "this", "?", SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(LOCAL_DATE_VAL, "this", "?", SqlColumnType.DATE, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(LOCAL_TIME_VAL, "this", "?", SqlColumnType.TIME, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(LOCAL_DATE_TIME_VAL, "this", "?", SqlColumnType.TIMESTAMP, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(OFFSET_DATE_TIME_VAL, "this", "?", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.BOOLEAN, true);
        this.putCheckFailureSignatureCommute(OBJECT_VAL, "field1", "?", SqlColumnType.OBJECT, SqlColumnType.BOOLEAN, true);
        this.checkCommute("?", "true", this.result(true, true), true);
        this.checkCommute("?", "false", this.result(true, false), true);
        this.checkCommute("?", "null", this.result(true, null), true);
        this.checkCommute("?", "true", this.result(false, true), false);
        this.checkCommute("?", "false", this.result(false, false), false);
        this.checkCommute("?", "null", this.result(false, null), false);
        this.checkCommute("?", "true", this.result(null, true), new Object[]{null});
        this.checkCommute("?", "false", this.result(null, false), new Object[]{null});
        this.checkCommute("?", "null", this.result(null, null), new Object[]{null});
        this.checkFailureSignatureCommute("?", "'true'", SqlColumnType.BOOLEAN, SqlColumnType.VARCHAR, true);
        this.checkFailureSignatureCommute("?", "1", SqlColumnType.BOOLEAN, SqlColumnType.TINYINT, true);
        this.checkFailureSignatureCommute("?", "1.1", SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL, true);
        this.checkFailureSignatureCommute("?", "1.1E1", SqlColumnType.BOOLEAN, SqlColumnType.DOUBLE, true);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.VARCHAR, "1");
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.TINYINT, (byte)1);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.SMALLINT, (short)1);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.INTEGER, 1);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.BIGINT, 1L);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.DECIMAL, BigInteger.ONE);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.REAL, Float.valueOf(1.0f));
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.DOUBLE, 1.0);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.DATE, LOCAL_DATE_VAL);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.TIME, LOCAL_TIME_VAL);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.TIMESTAMP, LOCAL_DATE_TIME_VAL);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OFFSET_DATE_TIME_VAL);
        this.checkFailureParameterCommute("?", "true", 0, SqlColumnType.OBJECT, OBJECT_VAL);
        this.checkCommute("?", "?", this.result(true, true), true, true);
        this.checkCommute("?", "?", this.result(true, false), true, false);
        this.checkCommute("?", "?", this.result(true, null), true, null);
        this.checkCommute("?", "?", this.result(false, true), false, true);
        this.checkCommute("?", "?", this.result(false, false), false, false);
        this.checkCommute("?", "?", this.result(false, null), false, null);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.VARCHAR, true, "true");
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.TINYINT, true, (byte)1);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.SMALLINT, true, (short)1);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.INTEGER, true, 1);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.BIGINT, true, 1L);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.DECIMAL, true, BigInteger.ONE);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.DECIMAL, true, BigDecimal.ONE);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.REAL, true, Float.valueOf(1.0f));
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.DOUBLE, true, 1.0);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.DATE, true, LOCAL_DATE_VAL);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.TIME, true, LOCAL_TIME_VAL);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.TIMESTAMP, true, LOCAL_DATE_TIME_VAL);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, true, OFFSET_DATE_TIME_VAL);
        this.checkFailureParameterCommute("?", "?", 1, SqlColumnType.OBJECT, true, OBJECT_VAL);
        this.checkCommute("true", "true", this.result(true, true), new Object[0]);
        this.checkCommute("true", "false", this.result(true, false), new Object[0]);
        this.checkCommute("true", "null", this.result(true, null), new Object[0]);
        this.checkCommute("false", "true", this.result(false, true), new Object[0]);
        this.checkCommute("false", "false", this.result(false, false), new Object[0]);
        this.checkCommute("false", "null", this.result(false, null), new Object[0]);
        this.checkFailureSignatureCommute("true", "'true'", SqlColumnType.BOOLEAN, SqlColumnType.VARCHAR, new Object[0]);
        this.checkFailureSignatureCommute("true", "1", SqlColumnType.BOOLEAN, SqlColumnType.TINYINT, new Object[0]);
        this.checkFailureSignatureCommute("true", "1.1", SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL, new Object[0]);
        this.checkFailureSignatureCommute("true", "1.1E1", SqlColumnType.BOOLEAN, SqlColumnType.DOUBLE, new Object[0]);
    }

    @Test
    public void testArg3() {
        this.put(0);
        this.checkValue0(this.sql("?", "?", "?"), SqlColumnType.BOOLEAN, this.result(null, true, false), null, true, false);
    }

    private void putCheckCommute(Object value, String operand1, String operand2, Boolean expectedResult, Object ... params) {
        this.put(value);
        this.checkCommute(operand1, operand2, expectedResult, params);
    }

    private void checkCommute(String operand1, String operand2, Boolean expectedResult, Object ... params) {
        this.check(operand1, operand2, expectedResult, params);
        this.check(operand2, operand1, expectedResult, params);
    }

    private void check(String operand1, String operand2, Boolean expectedResult, Object ... params) {
        String sql = this.sql(operand1, operand2);
        this.checkValue0(sql, SqlColumnType.BOOLEAN, expectedResult, params);
    }

    private void putCheckFailureSignatureCommute(Object value, String operand1, String operand2, SqlColumnType type1, SqlColumnType type2, Object ... params) {
        this.put(value);
        this.checkFailureSignatureCommute(operand1, operand2, type1, type2, params);
    }

    private void checkFailureSignatureCommute(String operand1, String operand2, SqlColumnType type1, SqlColumnType type2, Object ... params) {
        this.checkFailureSignature(operand1, operand2, type1, type2, params);
        this.checkFailureSignature(operand2, operand1, type2, type1, params);
    }

    private void checkFailureSignature(String operand1, String operand2, SqlColumnType type1, SqlColumnType type2, Object ... params) {
        String sql = this.sql(operand1, operand2);
        this.checkFailure0(sql, 1008, AndOrPredicateIntegrationTest.signatureErrorOperator(this.mode.name(), type1, type2), params);
    }

    private void putCheckFailureParameterCommute(Object value, String operand1, String operand2, int parameterPosition, SqlColumnType parameterType, Object ... params) {
        this.put(value);
        this.checkFailureParameterCommute(operand1, operand2, parameterPosition, parameterType, params);
    }

    private void checkFailureParameterCommute(String operand1, String operand2, int parameterPosition, SqlColumnType parameterType, Object ... params) {
        this.checkFailureParameter(operand1, operand2, parameterPosition, parameterType, params);
        this.checkFailureParameter(operand2, operand1, parameterPosition, parameterType, params);
    }

    private void checkFailureParameter(String operand1, String operand2, int parameterPosition, SqlColumnType parameterType, Object ... params) {
        String sql = this.sql(operand1, operand2);
        this.checkFailure0(sql, 2000, AndOrPredicateIntegrationTest.parameterError(parameterPosition, SqlColumnType.BOOLEAN, parameterType), params);
    }

    private String sql(Object ... operands) {
        assert (operands != null);
        assert (operands.length > 1);
        StringBuilder condition = new StringBuilder();
        condition.append(operands[0]);
        for (int i = 1; i < operands.length; ++i) {
            condition.append(" ");
            condition.append(this.mode.name());
            condition.append(" ");
            condition.append(operands[i]);
        }
        return "SELECT " + String.valueOf(condition) + " FROM map";
    }

    private Boolean result(Boolean ... values) {
        assert (values != null);
        if (this.mode == Mode.AND) {
            for (Boolean value : values) {
                if (!Boolean.FALSE.equals(value)) continue;
                return false;
            }
            for (Boolean value : values) {
                if (value != null) continue;
                return null;
            }
            return true;
        }
        assert (this.mode == Mode.OR);
        for (Boolean value : values) {
            if (!Boolean.TRUE.equals(value)) continue;
            return true;
        }
        for (Boolean value : values) {
            if (value != null) continue;
            return null;
        }
        return false;
    }

    @Test
    public void testEquality() {
        AndOrPredicateIntegrationTest.checkEquals(this.predicate(true, false), this.predicate(true, false), true);
        AndOrPredicateIntegrationTest.checkEquals(this.predicate(true, false), this.predicate(true, true), false);
        AndOrPredicateIntegrationTest.checkEquals(this.predicate(true, true), this.predicate(true, true, true), false);
    }

    @Test
    public void testSerialization() {
        Expression<?> original = this.predicate(true, false);
        Expression restored = (Expression)AndOrPredicateIntegrationTest.serializeAndCheck(original, this.mode == Mode.AND ? 42 : 43);
        AndOrPredicateIntegrationTest.checkEquals(original, restored, true);
    }

    private Expression<?> predicate(Boolean ... values) {
        Expression[] operands = new Expression[values.length];
        for (int i = 0; i < values.length; ++i) {
            operands[i] = ConstantExpression.create((Object)values[i], (QueryDataType)QueryDataType.BOOLEAN);
        }
        return this.mode == Mode.AND ? AndPredicate.create((Expression[])operands) : OrPredicate.create((Expression[])operands);
    }

    private static enum Mode {
        AND,
        OR;

    }
}

