/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.misc;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class NestingAndCasingExpressionTest
extends ExpressionTestSupport {
    private static final Set<String> EXCEPTIONAL_EXPRESSIONS = new HashSet<String>(Arrays.asList("DESC", "UNION", "UNION_ALL", "VALUES", "ROW", "COLLECTION_TABLE", "MAP_VALUE_CONSTRUCTOR", "ARGUMENT_ASSIGNMENT", "GENERATE_SERIES", "GENERATE_STREAM", "CSV_FILE", "JSON_FLAT_FILE", "AVRO_FILE", "PARQUET_FILE", "EXISTS", "DESCRIPTOR", "IMPOSE_ORDER", "TUMBLE", "HOP", "WITHIN_GROUP", "JSON_ARRAYAGG_ABSENT_ON_NULL", "JSON_ARRAYAGG_NULL_ON_NULL", "JSON_OBJECTAGG_ABSENT_ON_NULL", "JSON_OBJECTAGG_NULL_ON_NULL", "DOT", "GET_DDL"));

    @Before
    public void before0() {
        this.put(1);
    }

    @Test
    public void testAllExpressionsCovered() {
        HashSet<Field> checkedFields = new HashSet<Field>();
        LinkedHashSet<CallSite> missingMethodNames = new LinkedHashSet<CallSite>();
        for (Field field : HazelcastSqlOperatorTable.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !SqlOperator.class.isAssignableFrom(field.getType()) || EXCEPTIONAL_EXPRESSIONS.contains(field.getName())) continue;
            checkedFields.add(field);
            String testMethodName = "test_" + field.getName();
            try {
                NestingAndCasingExpressionTest.class.getMethod(testMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                missingMethodNames.add((CallSite)((Object)testMethodName));
            }
        }
        Assert.assertFalse((String)"No fields to check found!", (boolean)checkedFields.isEmpty());
        if (!missingMethodNames.isEmpty()) {
            StringJoiner joiner = new StringJoiner("\n");
            missingMethodNames.forEach(joiner::add);
            Assert.fail((String)("Tests not implemented: \n" + String.valueOf(joiner)));
        }
    }

    @Test
    public void test_CAST() {
        this.check(this.sql("CAST(? AS INTEGER) || CAST(? AS INTEGER)"), 1, 1);
    }

    @Test
    public void test_AND() {
        this.check(this.sql("(? AND ?) || (? AND ?)"), true, true, true, true);
    }

    @Test
    public void test_OR() {
        this.check(this.sql("(? OR ?) || (? OR ?)"), true, true, true, true);
    }

    @Test
    public void test_NOT() {
        this.check(this.sql("(NOT(?)) || (NOT(?))"), true, true);
    }

    @Test
    public void test_IN() {
        this.check(this.sql("(1 IN (1)) || (1 IN (1))"), new Object[0]);
    }

    @Test
    public void test_NOT_IN() {
        this.check(this.sql("(1 NOT IN (2)) || (1 NOT IN (2))"), new Object[0]);
    }

    @Test
    public void test_EQUALS() {
        this.check(this.sql("(CAST(1 AS INT) = ?) || (1 = CAST(? AS TINYINT))"), 1, 1);
    }

    @Test
    public void test_NOT_EQUALS() {
        this.check(this.sql("(CAST(1 AS INT) != ?) || (1 != CAST(? AS TINYINT))"), 1, 1);
    }

    @Test
    public void test_GREATER_THAN() {
        this.check(this.sql("(CAST(1 AS INT) > ?) || (1 > CAST(? AS TINYINT))"), 1, 1);
    }

    @Test
    public void test_GREATER_THAN_OR_EQUAL() {
        this.check(this.sql("(CAST(1 AS INT) >= ?) || (1 >= CAST(? AS TINYINT))"), 1, 1);
    }

    @Test
    public void test_LESS_THAN() {
        this.check(this.sql("(CAST(1 AS INT) < ?) || (1 < CAST(? AS TINYINT))"), 1, 1);
    }

    @Test
    public void test_LESS_THAN_OR_EQUAL() {
        this.check(this.sql("(CAST(1 AS INT) <= ?) || (1 <= CAST(? AS TINYINT))"), 1, 1);
    }

    @Test
    public void test_PLUS() {
        this.check(this.sql("(1+?) || (1+?)"), 1, 1);
    }

    @Test
    public void test_MINUS() {
        this.check(this.sql("(1-?) || (1-?)"), 1, 1);
    }

    @Test
    public void test_MULTIPLY() {
        this.check(this.sql("(1*?) || (1*?)"), 1, 1);
    }

    @Test
    public void test_DIVIDE() {
        this.check(this.sql("(1/?) || (1/?)"), 1, 1);
    }

    @Test
    public void test_REMAINDER() {
        this.check(this.sql("(1%?) || (1%?)"), 1, 1);
    }

    @Test
    public void test_UNARY_PLUS() {
        this.check(this.sql("(+?) || (+?)"), 1, 1);
    }

    @Test
    public void test_UNARY_MINUS() {
        this.check(this.sql("(-?) || (-?)"), 1, 1);
    }

    @Test
    public void test_IS_TRUE() {
        this.check(this.sql("(? IS TRUE) || (? IS TRUE)"), false, false);
    }

    @Test
    public void test_IS_NOT_TRUE() {
        this.check(this.sql("(? IS NOT TRUE) || (? IS NOT TRUE)"), false, false);
    }

    @Test
    public void test_IS_FALSE() {
        this.check(this.sql("(? IS FALSE) || (? IS FALSE)"), false, false);
    }

    @Test
    public void test_IS_NOT_FALSE() {
        this.check(this.sql("(? IS NOT FALSE) || (? IS NOT FALSE)"), false, false);
    }

    @Test
    public void test_IS_NULL() {
        this.check(this.sql("(? IS NULL) || (? IS NULL)"), 1, 1);
    }

    @Test
    public void test_IS_NOT_NULL() {
        this.check(this.sql("(? IS NOT NULL) || (? IS NOT NULL)"), 1, 1);
    }

    @Test
    public void test_ABS() {
        this.check(this.sql("ABS(?) || ABS(?)"), 1, 1);
    }

    @Test
    public void test_SIGN() {
        this.check(this.sql("SIGN(?) || SIGN(?)"), 1, 1);
    }

    @Test
    public void test_RAND() {
        this.check(this.sql("RAND(?) || RAND(?)"), 1, 1);
    }

    @Test
    public void test_COS() {
        this.check(this.sql("COS(?) || COS(?)"), 1, 1);
    }

    @Test
    public void test_POWER() {
        this.check(this.sql("POWER(?, ?) || POWER(?, ?)"), 1, 1, 1, 1);
    }

    @Test
    public void test_SQUARE() {
        this.check(this.sql("SQUARE(?) || SQUARE(?)"), 1, 1);
    }

    @Test
    public void test_SQRT() {
        this.check(this.sql("SQRT(?) || SQRT(?)"), 4, 4);
    }

    @Test
    public void test_CBRT() {
        this.check(this.sql("CBRT(?) || CBRT(?)"), 8, 8);
    }

    @Test
    public void test_SIN() {
        this.check(this.sql("SIN(?) || SIN(?)"), 1, 1);
    }

    @Test
    public void test_TAN() {
        this.check(this.sql("TAN(?) || TAN(?)"), 1, 1);
    }

    @Test
    public void test_COT() {
        this.check(this.sql("COT(?) || COT(?)"), 1, 1);
    }

    @Test
    public void test_ACOS() {
        this.check(this.sql("ACOS(?) || ACOS(?)"), 1, 1);
    }

    @Test
    public void test_ASIN() {
        this.check(this.sql("ASIN(?) || ASIN(?)"), 1, 1);
    }

    @Test
    public void test_ATAN() {
        this.check(this.sql("ATAN(?) || ATAN(?)"), 1, 1);
    }

    @Test
    public void test_ATAN2() {
        this.check(this.sql("ATAN2(?, ?) || ATAN2(?, ?)"), 1, 1, 1, 1);
    }

    @Test
    public void test_EXP() {
        this.check(this.sql("EXP(?) || EXP(?)"), 1, 1);
    }

    @Test
    public void test_LN() {
        this.check(this.sql("LN(?) || LN(?)"), 1, 1);
    }

    @Test
    public void test_LOG10() {
        this.check(this.sql("LOG10(?) || LOG10(?)"), 1, 1);
    }

    @Test
    public void test_DEGREES() {
        this.check(this.sql("DEGREES(?) || DEGREES(?)"), 1, 1);
    }

    @Test
    public void test_RADIANS() {
        this.check(this.sql("RADIANS(?) || RADIANS(?)"), 1, 1);
    }

    @Test
    public void test_FLOOR() {
        this.check(this.sql("FLOOR(?) || FLOOR(?)"), 1, 1);
    }

    @Test
    public void test_CEIL() {
        this.check(this.sql("CEIL(?) || CEIL(?)"), 1, 1);
    }

    @Test
    public void test_ROUND() {
        this.check(this.sql("ROUND(?) || ROUND(?)"), 1, 1);
    }

    @Test
    public void test_TRUNCATE() {
        this.check(this.sql("TRUNCATE(?) || TRUNCATE(?)"), 1, 1);
    }

    @Test
    public void test_CONCAT() {
        this.check(this.sql("(? || ?) || (? || ?)"), "a", "b", "c", "d");
    }

    @Test
    public void test_CONCAT_WS() {
        this.check(this.sql("CONCAT_WS(?, ?, ?) || CONCAT_WS(?, ?, ?)"), "-", "1", "2", "-", "3", "4");
    }

    @Test
    public void test_LIKE() {
        this.check(this.sql("(? LIKE ?) || (? LIKE ?)"), "a", "a", "b", "b");
    }

    @Test
    public void test_NOT_LIKE() {
        this.check(this.sql("(? NOT LIKE ?) || (? NOT LIKE ?)"), "a", "a", "b", "b");
    }

    @Test
    public void test_SUBSTRING() {
        this.check(this.sql("SUBSTRING(? FROM ?) || SUBSTRING(? FROM ?) "), "a", 1, "b", 1);
    }

    @Test
    public void test_TRIM() {
        this.check(this.sql("TRIM(LEADING ? FROM ?) || RTRIM(?)"), "1", "1", "2");
    }

    @Test
    public void test_RTRIM() {
        this.check(this.sql("RTRIM(?) || RTRIM(?)"), "1", "1");
    }

    @Test
    public void test_LTRIM() {
        this.check(this.sql("LTRIM(?) || LTRIM(?)"), "1", "1");
    }

    @Test
    public void test_BTRIM() {
        this.check(this.sql("BTRIM(?) || BTRIM(?)"), "1", "1");
    }

    @Test
    public void test_ASCII() {
        this.check(this.sql("ASCII(?) || ASCII(?)"), "1", "1");
    }

    @Test
    public void test_INITCAP() {
        this.check(this.sql("INITCAP(?) || INITCAP(?)"), "1", "1");
    }

    @Test
    public void test_CHAR_LENGTH() {
        this.check(this.sql("CHAR_LENGTH(?) || CHAR_LENGTH(?)"), "1", "1");
    }

    @Test
    public void test_CHARACTER_LENGTH() {
        this.check(this.sql("CHARACTER_LENGTH(?) || CHARACTER_LENGTH(?)"), "1", "1");
    }

    @Test
    public void test_LENGTH() {
        this.check(this.sql("LENGTH(?) || LENGTH(?)"), "1", "1");
    }

    @Test
    public void test_LOWER() {
        this.check(this.sql("LOWER(?) || LOWER(?)"), "1", "2");
    }

    @Test
    public void test_UPPER() {
        this.check(this.sql("UPPER(?) || UPPER(?)"), "1", "2");
    }

    @Test
    public void test_REPLACE() {
        this.check(this.sql("REPLACE(?, ?, ?) || REPLACE(?, ?, ?) "), "xyz", "x", "X", "xyz", "y", "Y");
    }

    @Test
    public void test_POSITION() {
        this.check(this.sql("POSITION(? IN ?) || POSITION(? IN ?)"), "y", "xyz", "z", "xyz");
    }

    @Test
    public void test_BETWEEN_ASYMMETRIC() {
        this.check(this.sqlWithWhere("BETWEEN ? AND ? "), SqlColumnType.INTEGER, new Object[]{1, 1});
    }

    @Test
    public void test_NOT_BETWEEN_ASYMMETRIC() {
        this.check(this.sqlWithWhere("NOT BETWEEN ? AND ? "), SqlColumnType.INTEGER, new Object[]{2, 2});
    }

    @Test
    public void test_BETWEEN_SYMMETRIC() {
        this.check(this.sqlWithWhere("BETWEEN SYMMETRIC ? AND ? "), SqlColumnType.INTEGER, new Object[]{1, 1});
    }

    @Test
    public void test_NOT_BETWEEN_SYMMETRIC() {
        this.check(this.sqlWithWhere("NOT BETWEEN SYMMETRIC ? AND ? "), SqlColumnType.INTEGER, new Object[]{2, 2});
    }

    @Test
    public void test_CASE() {
        this.check(this.sql("CASE WHEN ? THEN ? END || CASE WHEN ? THEN ? END"), true, "foo", true, "bar");
    }

    @Test
    public void test_EXTRACT() {
        this.check(this.sql("EXTRACT(MONTH FROM ?) || EXTRACT(MONTH FROM ?)"), LocalDateTime.now(), LocalDateTime.now());
    }

    @Test
    public void test_NULLIF() {
        this.check(this.sql("NULLIF(1, ?) || NULLIF(1, ?)"), 1, 2);
    }

    @Test
    public void test_COALESCE() {
        this.check(this.sql("COALESCE('1', ?) || COALESCE('2', ?)"), "1", "2");
    }

    @Test
    public void test_TO_TIMESTAMP_TZ() {
        this.check(this.sql("TO_TIMESTAMP_TZ(?) || TO_TIMESTAMP_TZ(?)"), 1L, 1L);
    }

    @Test
    public void test_TO_EPOCH_MILLIS() {
        this.check(this.sql("TO_EPOCH_MILLIS(?) || TO_EPOCH_MILLIS(?)"), OFFSET_DATE_TIME_VAL, OFFSET_DATE_TIME_VAL);
    }

    @Test
    public void test_TO_CHAR() {
        this.check(this.sql("TO_CHAR(?, ?) || TO_CHAR(?, ?)"), LOCAL_DATE_VAL, "YYYY-MM-DD", 1, "9");
    }

    @Test
    public void test_COUNT() {
        this.check(this.sql("COUNT(?) || COUNT(?)"), 1L, 1L);
    }

    @Test
    public void test_SUM() {
        this.check(this.sql("SUM(?) || SUM(?)"), 1L, 1L);
    }

    @Test
    public void test_AVG() {
        this.check(this.sql("AVG(?) || AVG(?)"), 1L, 1L);
    }

    @Test
    public void test_MIN() {
        this.check(this.sql("MIN(?) || MIN(?)"), 1L, 1L);
    }

    @Test
    public void test_MAX() {
        this.check(this.sql("MAX(?) || MAX(?)"), 1L, 1L);
    }

    @Test
    public void test_MOD() {
        this.check(this.sql("MOD(?, 2) || MOD(?, 2)"), 1L, 1L);
        this.check(this.sql("MOD(2, ?) || MOD(2, ?)"), 1L, 1L);
    }

    @Test
    public void test_JSON_QUERY() {
        this.check(this.sql("JSON_QUERY(CAST(? AS JSON), '$') || JSON_QUERY(CAST(? AS JSON), '$')"), "[1]", "[1]");
    }

    @Test
    public void test_JSON_VALUE() {
        this.check(this.sql("JSON_VALUE(CAST(? AS JSON), '$[0]') || JSON_VALUE(CAST(? AS JSON), '$[0]')"), "[1]", "[1]");
    }

    @Test
    public void test_JSON_OBJECT() {
        this.check(this.sql("JSON_OBJECT(? : ?) || JSON_OBJECT(KEY ? VALUE ?)"), "k", "v", "k", "v");
    }

    @Test
    public void test_JSON_ARRAY() {
        this.check(this.sql("JSON_ARRAY(?) || JSON_ARRAY(?)"), "v", "v");
    }

    @Test
    public void test_JSON_ARRAYAGG() {
        this.check(this.sql("JSON_VALUE(JSON_ARRAYAGG(?), '$[0]')"), "k");
    }

    @Test
    public void test_JSON_OBJECTAGG() {
        this.check(this.sql("JSON_VALUE(JSON_OBJECTAGG(? VALUE ?), '$.k')"), "k", "v");
    }

    private void check(String sql, Object ... params) {
        this.checkValue0(sql, SqlColumnType.VARCHAR, SKIP_VALUE_CHECK, params);
        this.checkValue0(StringUtil.lowerCaseInternal((String)sql), SqlColumnType.VARCHAR, SKIP_VALUE_CHECK, params);
    }

    private void check(String sql, SqlColumnType type, Object ... params) {
        this.checkValue0(sql, type, SKIP_VALUE_CHECK, params);
        this.checkValue0(StringUtil.lowerCaseInternal((String)sql), type, SKIP_VALUE_CHECK, params);
    }

    private String sql(String expression) {
        return "SELECT " + expression + " FROM map";
    }

    private String sqlWithWhere(String expression) {
        return "SELECT this FROM map WHERE this " + expression;
    }
}

