/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.misc;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.CaseExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.junit.Test;

public class CoalesceFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void coalesce() {
        this.put(1);
        this.checkValue0("select coalesce(null) from map", SqlColumnType.NULL, null, new Object[0]);
        this.checkValue0("select coalesce(null, null) from map", SqlColumnType.NULL, null, new Object[0]);
        this.checkValue0("select coalesce(this, 2) from map", SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue0("select coalesce(null, this, 2) from map", SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue0("select coalesce(null, 2, this) from map", SqlColumnType.INTEGER, 2, new Object[0]);
        this.checkValue0("select coalesce(CAST(null as INT), null) from map", SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0("select coalesce(CAST(null as INT)) from map", SqlColumnType.INTEGER, null, new Object[0]);
    }

    @Test
    public void fails_whenReturnTypeCantBeInferred() {
        this.put(1);
        this.checkFailure0("select coalesce() from map", 1008, "Invalid number of arguments to function 'COALESCE'. Was expecting 1 arguments", new Object[0]);
        this.checkFailure0("select coalesce(?) from map", 1008, "Cannot apply 'COALESCE' function to [UNKNOWN] (consider adding an explicit CAST)", new Object[0]);
        this.checkFailure0("select coalesce(?, ?) from map", 1008, "Cannot apply 'COALESCE' function to [UNKNOWN, UNKNOWN] (consider adding an explicit CAST)", new Object[0]);
    }

    @Test
    public void numbersCoercion() {
        this.put(1);
        this.checkValue0("select coalesce(this, CAST(null as BIGINT)) from map", SqlColumnType.BIGINT, 1L, new Object[0]);
        this.checkValue0("select coalesce(null, this, 1234567890123) from map", SqlColumnType.BIGINT, 1L, new Object[0]);
    }

    @Test
    public void dateTimeValuesAndLiterals() {
        LocalDate localDate = LocalDate.of(2021, 1, 1);
        this.put(localDate);
        this.checkValue0("select coalesce(this, '2021-01-02') from map", SqlColumnType.DATE, localDate, new Object[0]);
        LocalTime localTime = LocalTime.of(12, 0);
        this.put(localTime);
        this.checkValue0("select coalesce(this, '13:00') from map", SqlColumnType.TIME, localTime, new Object[0]);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        this.put(localDateTime);
        this.checkValue0("select coalesce(this, '2021-01-02T13:00') from map", SqlColumnType.TIMESTAMP, localDateTime, new Object[0]);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.ofHours(2));
        this.put(offsetDateTime);
        this.checkValue0("select coalesce(this, '2021-01-02T13:00+01:00') from map", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, offsetDateTime, new Object[0]);
        this.checkValue0("select coalesce(this, CAST('2021-01-02' as DATE), CAST('2021-01-02T13:00' as TIMESTAMP), '2021-01-02T13:00+01:00') from map", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, offsetDateTime, new Object[0]);
        this.checkValue0("select CAST('13:00:00' as TIME) from map", SqlColumnType.TIME, localTime.plusHours(1L), new Object[0]);
        this.checkValue0("select coalesce(this, CAST(? as TIMESTAMP), CAST('2021-01-02T13:00' as TIMESTAMP), '2021-01-02T13:00+01:00') from map", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, offsetDateTime, localTime);
    }

    @Test
    public void nonCoercibleTypes() {
        this.put(1);
        this.checkFailure0("select coalesce(1, 'abc') from map", 1008, "Cannot infer return type for COALESCE among [TINYINT, VARCHAR]", new Object[0]);
        this.checkFailure0("select coalesce('abc', CAST('2021-01-02' as DATE)) from map", 1008, "CAST function cannot convert literal 'abc' to type DATE: Cannot parse VARCHAR value to DATE", new Object[0]);
        this.checkFailure0("select coalesce('abc', CAST('13:00:00' as TIME)) from map", 1008, "CAST function cannot convert literal 'abc' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0("select coalesce('abc', CAST('2021-01-02T13:00' as TIMESTAMP)) from map", 1008, "CAST function cannot convert literal 'abc' to type TIMESTAMP: Cannot parse VARCHAR value to TIMESTAMP", new Object[0]);
        this.checkFailure0("select coalesce(1, CAST('2021-01-02' as DATE)) from map", 1008, "Cannot infer return type for COALESCE among [TINYINT, DATE]", new Object[0]);
        this.checkFailure0("select coalesce(1, CAST('13:00:00' as TIME)) from map", 1008, "Cannot infer return type for COALESCE among [TINYINT, TIME]", new Object[0]);
        this.checkFailure0("select coalesce(1, CAST('2021-01-02T13:00' as TIMESTAMP)) from map", 1008, "Cannot infer return type for COALESCE among [TINYINT, TIMESTAMP]", new Object[0]);
    }

    @Test
    public void testEquality() {
        CoalesceFunctionIntegrationTest.checkEquals(CaseExpression.coalesce((Expression[])new Expression[]{ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT)}), CaseExpression.coalesce((Expression[])new Expression[]{ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT)}), true);
        CoalesceFunctionIntegrationTest.checkEquals(CaseExpression.coalesce((Expression[])new Expression[]{ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT)}), CaseExpression.coalesce((Expression[])new Expression[]{ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)10, (QueryDataType)QueryDataType.INT)}), false);
    }

    @Test
    public void testSerialization() {
        CaseExpression original = CaseExpression.coalesce((Expression[])new Expression[]{ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT)});
        CaseExpression restored = (CaseExpression)CoalesceFunctionIntegrationTest.serializeAndCheck(original, 70);
        CoalesceFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

