/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.misc;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.CastExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.converter.LocalDateConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.LocalTimeConverter;
import com.hazelcast.sql.impl.type.converter.OffsetDateTimeConverter;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class CastFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testVarchar_char() {
        this.putAndCheckValue(new ExpressionValue.CharacterVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "b", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 2000, "Cannot parse VARCHAR value to BOOLEAN", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 2000, "Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), 2000, "Cannot parse VARCHAR value to DECIMAL", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), 2000, "Cannot parse VARCHAR value to REAL", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), 2000, "Cannot parse VARCHAR value to DOUBLE", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 2000, "Cannot parse VARCHAR value to DATE", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 2000, "Cannot parse VARCHAR value to TIME", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 2000, "Cannot parse VARCHAR value to TIMESTAMP", new Object[0]);
        this.putAndCheckFailure(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 2000, "Cannot parse VARCHAR value to TIMESTAMP WITH TIME ZONE", new Object[0]);
        this.putAndCheckValue(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, "b", new Object[0]);
        this.putAndCheckValue(Character.valueOf('b'), CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), SqlColumnType.JSON, new HazelcastJsonValue("b"), new Object[0]);
    }

    @Test
    public void testVarchar_string() {
        this.putAndCheckValue(Character.valueOf('f'), CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "f", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue("foo", CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "foo", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, null, new Object[0]);
        this.putAndCheckValue("true", CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, true, new Object[0]);
        this.putAndCheckValue("false", CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, false, new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 2000, "Cannot parse VARCHAR value to BOOLEAN", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(0), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string((byte)127), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)127, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string((byte)-128), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)-128, new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.string((short)Short.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.string((short)Short.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(0), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string((short)Short.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string((short)Short.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.string(Integer.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.string(Integer.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(0), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(Integer.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(Integer.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.string(Long.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.string(Long.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(0), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(Long.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(Long.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.string(CastFunctionIntegrationTest.decimal(Long.MAX_VALUE).multiply(CastFunctionIntegrationTest.decimal(2))), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 2000, "Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.string(CastFunctionIntegrationTest.decimal(Long.MIN_VALUE).multiply(CastFunctionIntegrationTest.decimal(2))), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 2000, "Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 2000, "Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string(1), CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, BigDecimal.ONE, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("1.1"), new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), 2000, "Cannot parse VARCHAR value to DECIMAL", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.1f), new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), 2000, "Cannot parse VARCHAR value to REAL", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.string("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.1, new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), 2000, "Cannot parse VARCHAR value to DOUBLE", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DATE), SqlColumnType.DATE, null, new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_VAL.toString(), CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), SqlColumnType.DATE, LOCAL_DATE_VAL, new Object[0]);
        this.putAndCheckValue("2020-1-1", CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), SqlColumnType.DATE, LOCAL_DATE_VAL, new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 2000, "Cannot parse VARCHAR value to DATE", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIME), SqlColumnType.TIME, null, new Object[0]);
        this.putAndCheckValue(LOCAL_TIME_VAL.toString(), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), SqlColumnType.TIME, LOCAL_TIME_VAL, new Object[0]);
        this.putAndCheckValue("0:0:0", CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), SqlColumnType.TIME, LOCAL_TIME_VAL, new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 2000, "Cannot parse VARCHAR value to TIME", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_TIME_VAL.toString(), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LOCAL_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckValue("2020-1-1 0:0:0", CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LOCAL_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 2000, "Cannot parse VARCHAR value to TIMESTAMP", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null, new Object[0]);
        this.putAndCheckValue(OFFSET_DATE_TIME_VAL.toString(), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OFFSET_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckValue("2020-1-1 0:0:0+00:00", CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OFFSET_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckFailure("bad", CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 2000, "Cannot parse VARCHAR value to TIMESTAMP WITH TIME ZONE", new Object[0]);
        this.putAndCheckValue(new ExpressionValue.StringVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue("foo", CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, "foo", new Object[0]);
        this.putAndCheckValue("[1,2,3]", CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), SqlColumnType.JSON, new HazelcastJsonValue("[1,2,3]"), new Object[0]);
    }

    @Test
    public void testVarchar_literal() {
        this.put(1);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "foo", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "true", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "false", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(LOCAL_DATE_VAL), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, LOCAL_DATE_VAL.toString(), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(LOCAL_TIME_VAL), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, LOCAL_TIME_VAL.toString(), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(LOCAL_DATE_TIME_VAL), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, LOCAL_DATE_TIME_VAL.toString(), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(OFFSET_DATE_TIME_VAL), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, OFFSET_DATE_TIME_VAL.toString(), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.BOOLEAN), 1008, "CAST function cannot convert literal 'foo' to type BOOLEAN: Cannot parse VARCHAR value to BOOLEAN", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("null"), SqlColumnType.BOOLEAN), 1008, "CAST function cannot convert literal 'null' to type BOOLEAN: Cannot parse VARCHAR value to BOOLEAN", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("True"), SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("False"), SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(1), SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral((byte)127), SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)127, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral((byte)-128), SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)-128, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral((short)Short.MAX_VALUE), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal '32767' to type TINYINT: Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral((short)Short.MIN_VALUE), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal '-32768' to type TINYINT: Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 'foo' to type TINYINT: Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 'true' to type TINYINT: Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 'false' to type TINYINT: Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("1.1"), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal '1.1' to type TINYINT: Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(1), SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral((short)Short.MAX_VALUE), SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral((short)Short.MIN_VALUE), SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(Integer.MAX_VALUE), SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal '2147483647' to type SMALLINT: Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(Integer.MIN_VALUE), SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal '-2147483648' to type SMALLINT: Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal 'foo' to type SMALLINT: Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal 'true' to type SMALLINT: Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal 'false' to type SMALLINT: Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("1.1"), SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal '1.1' to type SMALLINT: Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(1), SqlColumnType.INTEGER), SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(Integer.MAX_VALUE), SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MAX_VALUE, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(Integer.MIN_VALUE), SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MIN_VALUE, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(Long.MAX_VALUE), SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal '9223372036854775807' to type INTEGER: Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(Long.MIN_VALUE), SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal '-9223372036854775808' to type INTEGER: Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal 'foo' to type INTEGER: Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal 'true' to type INTEGER: Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal 'false' to type INTEGER: Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("1.1"), SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal '1.1' to type INTEGER: Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(1), SqlColumnType.BIGINT), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(Long.MAX_VALUE), SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(Long.MIN_VALUE), SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MIN_VALUE, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("92233720368547758070"), SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal '92233720368547758070' to type BIGINT: Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("-92233720368547758080"), SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal '-92233720368547758080' to type BIGINT: Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal 'foo' to type BIGINT: Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal 'true' to type BIGINT: Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal 'false' to type BIGINT: Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("1.1"), SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal '1.1' to type BIGINT: Cannot parse VARCHAR value to BIGINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(1), SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal(1), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("1.1"), SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("1.1"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("92233720368547758070"), SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("92233720368547758070"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("-92233720368547758080"), SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("-92233720368547758080"), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.DECIMAL), 1008, "CAST function cannot convert literal 'foo' to type DECIMAL: Cannot parse VARCHAR value to DECIMAL", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.DECIMAL), 1008, "CAST function cannot convert literal 'true' to type DECIMAL: Cannot parse VARCHAR value to DECIMAL", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.DECIMAL), 1008, "CAST function cannot convert literal 'false' to type DECIMAL: Cannot parse VARCHAR value to DECIMAL", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(1), SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.0f), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("1.1"), SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.1f), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.REAL), 1008, "CAST function cannot convert literal 'foo' to type REAL: Cannot parse VARCHAR value to REAL", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.REAL), 1008, "CAST function cannot convert literal 'true' to type REAL: Cannot parse VARCHAR value to REAL", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.REAL), 1008, "CAST function cannot convert literal 'false' to type REAL: Cannot parse VARCHAR value to REAL", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(1), SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("1.1"), SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.1, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.DOUBLE), 1008, "CAST function cannot convert literal 'foo' to type DOUBLE: Cannot parse VARCHAR value to DOUBLE", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("true"), SqlColumnType.DOUBLE), 1008, "CAST function cannot convert literal 'true' to type DOUBLE: Cannot parse VARCHAR value to DOUBLE", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("false"), SqlColumnType.DOUBLE), 1008, "CAST function cannot convert literal 'false' to type DOUBLE: Cannot parse VARCHAR value to DOUBLE", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("2020-1-01"), SqlColumnType.DATE), SqlColumnType.DATE, LocalDate.parse("2020-01-01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("2020-9-1"), SqlColumnType.DATE), SqlColumnType.DATE, LocalDate.parse("2020-09-01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("2020-01-01"), SqlColumnType.DATE), SqlColumnType.DATE, LocalDate.parse("2020-01-01"), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.DATE), 1008, "CAST function cannot convert literal 'foo' to type DATE: Cannot parse VARCHAR value to DATE", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("00:00"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("00:00"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("0:0"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("00:00"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("9:0"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("09:00"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("00:01"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("00:01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("00:1"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("00:01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("02:01"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("02:01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("00:00:00"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("00:00:00"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("00:00:01"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("00:00:01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("00:02:01"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("00:02:01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("03:02:01"), SqlColumnType.TIME), SqlColumnType.TIME, LocalTime.parse("03:02:01"), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("9"), SqlColumnType.TIME), 1008, "CAST function cannot convert literal '9' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("00:60"), SqlColumnType.TIME), 1008, "CAST function cannot convert literal '00:60' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("00:00:60"), SqlColumnType.TIME), 1008, "CAST function cannot convert literal '00:00:60' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("25:00"), SqlColumnType.TIME), 1008, "CAST function cannot convert literal '25:00' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("25:00:00"), SqlColumnType.TIME), 1008, "CAST function cannot convert literal '25:00:00' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.TIME), 1008, "CAST function cannot convert literal 'foo' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("2020-02-01T00:00:00"), SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LocalDateTime.parse("2020-02-01T00:00:00"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("2020-02-01T00:00:01"), SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LocalDateTime.parse("2020-02-01T00:00:01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("2020-02-01T00:02:01"), SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LocalDateTime.parse("2020-02-01T00:02:01"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("2020-02-01T03:02:01"), SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LocalDateTime.parse("2020-02-01T03:02:01"), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.TIMESTAMP), 1008, "CAST function cannot convert literal 'foo' to type TIMESTAMP: Cannot parse VARCHAR value to TIMESTAMP", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral(OFFSET_DATE_TIME_VAL), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OFFSET_DATE_TIME_VAL, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, "CAST function cannot convert literal 'foo' to type TIMESTAMP WITH TIME ZONE: Cannot parse VARCHAR value to TIMESTAMP WITH TIME ZONE", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("foo"), SqlColumnType.OBJECT), SqlColumnType.OBJECT, "foo", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.stringLiteral("[1,2,3]"), SqlColumnType.JSON), SqlColumnType.JSON, new HazelcastJsonValue("[1,2,3]"), new Object[0]);
    }

    @Test
    public void testBoolean() {
        this.putAndCheckValue(new ExpressionValue.BooleanVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BooleanVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BooleanVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "true", new Object[0]);
        this.putAndCheckValue(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, true, new Object[0]);
        this.putAndCheckValue(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, true, new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.TINYINT), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.SMALLINT), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(true, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testBoolean_literal() {
        this.put(1);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "true", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(false), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "false", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(false), SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.OBJECT), SqlColumnType.OBJECT, true, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.TINYINT), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.TINYINT), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.SMALLINT), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.SMALLINT), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.INTEGER), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.INTEGER), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.BIGINT), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.BIGINT), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.DECIMAL), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.REAL), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.REAL), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.DOUBLE), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.DOUBLE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.DATE), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.TIME), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(true), SqlColumnType.JSON), 1008, this.castError(SqlColumnType.BOOLEAN, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testTinyint() {
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ByteVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "0", new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, BigDecimal.ZERO, new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(0.0f), new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.putAndCheckValue((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, (byte)0, new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "-128", new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)-128, new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)-128, new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, -128, new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, -128L, new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, new BigDecimal(-128), new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(-128.0f), new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, -128.0, new Object[0]);
        this.putAndCheckValue((byte)-128, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, (byte)-128, new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "127", new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)127, new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)127, new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 127, new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 127L, new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, new BigDecimal(127), new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(127.0f), new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 127.0, new Object[0]);
        this.putAndCheckValue((byte)127, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, (byte)127, new Object[0]);
        this.putAndCheckFailure((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure((byte)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testTinyint_literal() {
        this.put(1);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "1", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((byte)-128), SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)-128, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((byte)127), SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)127, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(128), SqlColumnType.TINYINT), 1008, "Numeric overflow while converting SMALLINT to TINYINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.INTEGER), SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.BIGINT), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal(1), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.0f), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.DATE), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.TIME), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.JSON), 1008, this.castError(SqlColumnType.TINYINT, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(1), SqlColumnType.OBJECT), SqlColumnType.OBJECT, (byte)1, new Object[0]);
    }

    @Test
    public void testSmallint() {
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ShortVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "0", new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, BigDecimal.ZERO, new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(0.0f), new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.putAndCheckValue((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, (short)0, new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "-32768", new Object[0]);
        this.putAndCheckFailure((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting SMALLINT to TINYINT", new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE, new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Short.MIN_VALUE, new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, -32768L, new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, new BigDecimal(Short.MIN_VALUE), new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(-32768.0f), new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, -32768.0, new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, (short)Short.MIN_VALUE, new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "32767", new Object[0]);
        this.putAndCheckFailure((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting SMALLINT to TINYINT", new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE, new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Short.MAX_VALUE, new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 32767L, new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, new BigDecimal(Short.MAX_VALUE), new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(32767.0f), new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 32767.0, new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, (short)Short.MAX_VALUE, new Object[0]);
        this.putAndCheckFailure((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure((short)0, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testSmallint_literal() {
        this.put(1);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "32767", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 32767 to type TINYINT: Numeric overflow while converting SMALLINT to TINYINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.INTEGER), SqlColumnType.INTEGER, Short.MAX_VALUE, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.BIGINT), SqlColumnType.BIGINT, 32767L, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal((short)Short.MAX_VALUE), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(32767.0f), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 32767.0, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.DATE), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.TIME), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.JSON), 1008, this.castError(SqlColumnType.SMALLINT, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal((short)Short.MAX_VALUE), SqlColumnType.OBJECT), SqlColumnType.OBJECT, (short)Short.MAX_VALUE, new Object[0]);
    }

    @Test
    public void testInteger() {
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "0", new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, BigDecimal.ZERO, new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(0.0f), new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.putAndCheckValue(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, 0, new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, String.valueOf(Integer.MIN_VALUE), new Object[0]);
        this.putAndCheckFailure(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting INTEGER to TINYINT", new Object[0]);
        this.putAndCheckFailure(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Numeric overflow while converting INTEGER to SMALLINT", new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MIN_VALUE, new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Integer.MIN_VALUE, new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, new BigDecimal(Integer.MIN_VALUE), new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(-2.1474836E9f), new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, -2.147483648E9, new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, Integer.MIN_VALUE, new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, String.valueOf(Integer.MAX_VALUE), new Object[0]);
        this.putAndCheckFailure(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting INTEGER to TINYINT", new Object[0]);
        this.putAndCheckFailure(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Numeric overflow while converting INTEGER to SMALLINT", new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Integer.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, new BigDecimal(Integer.MAX_VALUE), new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(2.1474836E9f), new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 2.147483647E9, new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, Integer.MAX_VALUE, new Object[0]);
        this.putAndCheckFailure(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(0, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testInteger_literal() {
        this.put(1);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "2147483647", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 2147483647 to type TINYINT: Numeric overflow while converting INTEGER to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal 2147483647 to type SMALLINT: Numeric overflow while converting INTEGER to SMALLINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MAX_VALUE, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.BIGINT), SqlColumnType.BIGINT, Integer.MAX_VALUE, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal(Integer.MAX_VALUE), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(2.1474836E9f), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 2.147483647E9, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.DATE), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.TIME), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.JSON), 1008, this.castError(SqlColumnType.INTEGER, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Integer.MAX_VALUE), SqlColumnType.OBJECT), SqlColumnType.OBJECT, Integer.MAX_VALUE, new Object[0]);
    }

    @Test
    public void testBigint() {
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LongVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "0", new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, BigDecimal.ZERO, new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(0.0f), new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.putAndCheckValue(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, 0L, new Object[0]);
        this.putAndCheckValue(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "-9223372036854775808", new Object[0]);
        this.putAndCheckFailure(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting BIGINT to TINYINT", new Object[0]);
        this.putAndCheckFailure(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Numeric overflow while converting BIGINT to SMALLINT", new Object[0]);
        this.putAndCheckFailure(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Numeric overflow while converting BIGINT to INTEGER", new Object[0]);
        this.putAndCheckValue(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MIN_VALUE, new Object[0]);
        this.putAndCheckValue(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, new BigDecimal(Long.MIN_VALUE), new Object[0]);
        this.putAndCheckValue(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(-9.223372E18f), new Object[0]);
        this.putAndCheckValue(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, -9.223372036854776E18, new Object[0]);
        this.putAndCheckValue(Long.MIN_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, Long.MIN_VALUE, new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "9223372036854775807", new Object[0]);
        this.putAndCheckFailure(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting BIGINT to TINYINT", new Object[0]);
        this.putAndCheckFailure(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Numeric overflow while converting BIGINT to SMALLINT", new Object[0]);
        this.putAndCheckFailure(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Numeric overflow while converting BIGINT to INTEGER", new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, new BigDecimal(Long.MAX_VALUE), new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(9.223372E18f), new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 9.223372036854776E18, new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, Long.MAX_VALUE, new Object[0]);
        this.putAndCheckFailure(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(0L, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testBigint_literal() {
        this.put(1);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "9223372036854775807", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 9223372036854775807 to type TINYINT: Numeric overflow while converting BIGINT to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal 9223372036854775807 to type SMALLINT: Numeric overflow while converting BIGINT to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal 9223372036854775807 to type INTEGER: Numeric overflow while converting BIGINT to INTEGER", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal(Long.MAX_VALUE), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(9.223372E18f), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 9.223372036854776E18, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.DATE), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.TIME), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.JSON), 1008, this.castError(SqlColumnType.BIGINT, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(CastFunctionIntegrationTest.literal(Long.MAX_VALUE), SqlColumnType.OBJECT), SqlColumnType.OBJECT, Long.MAX_VALUE, new Object[0]);
    }

    @Test
    public void testDecimal_BigInteger() {
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigIntegerVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.putAndCheckValue(new BigInteger("127"), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)127, new Object[0]);
        this.putAndCheckValue(new BigInteger("-128"), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)-128, new Object[0]);
        this.putAndCheckFailure(new BigInteger("32767"), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting DECIMAL to TINYINT", new Object[0]);
        this.putAndCheckFailure(new BigInteger("-32768"), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting DECIMAL to TINYINT", new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue(new BigInteger("32767"), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(new BigInteger("-32768"), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(new BigInteger("2147483647"), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Numeric overflow while converting DECIMAL to SMALLINT", new Object[0]);
        this.putAndCheckFailure(new BigInteger("-2147483648"), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Numeric overflow while converting DECIMAL to SMALLINT", new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue(new BigInteger("2147483647"), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(new BigInteger("-2147483648"), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(new BigInteger("9223372036854775807"), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Numeric overflow while converting DECIMAL to INTEGER", new Object[0]);
        this.putAndCheckFailure(new BigInteger("-9223372036854775808"), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Numeric overflow while converting DECIMAL to INTEGER", new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue(new BigInteger("9223372036854775807"), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(new BigInteger("-9223372036854775808"), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(new BigInteger("92233720368547758070"), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 2000, "Numeric overflow while converting DECIMAL to BIGINT", new Object[0]);
        this.putAndCheckFailure(new BigInteger("-92233720368547758080"), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 2000, "Numeric overflow while converting DECIMAL to BIGINT", new Object[0]);
        this.putAndCheckValue(new BigInteger("1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("1"), new Object[0]);
        this.putAndCheckValue(new BigInteger("1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.0f), new Object[0]);
        this.putAndCheckValue(new BigInteger("1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.putAndCheckValue(new BigInteger("1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, CastFunctionIntegrationTest.decimal("1"), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testDecimal_BigDecimal() {
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.BigDecimalVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal(0), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal((byte)127), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)127, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal((byte)-128), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)-128, new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.decimal((short)Short.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting DECIMAL to TINYINT", new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.decimal((short)Short.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 2000, "Numeric overflow while converting DECIMAL to TINYINT", new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal(0), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal((short)Short.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal((short)Short.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.decimal(Integer.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Numeric overflow while converting DECIMAL to SMALLINT", new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.decimal(Integer.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 2000, "Numeric overflow while converting DECIMAL to SMALLINT", new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal(0), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 1, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal(Integer.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal(Integer.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, Integer.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.decimal(Long.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Numeric overflow while converting DECIMAL to INTEGER", new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.decimal(Long.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 2000, "Numeric overflow while converting DECIMAL to INTEGER", new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal(0), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal(Long.MAX_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal(Long.MIN_VALUE), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, Long.MIN_VALUE, new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.decimal("92233720368547758070"), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 2000, "Numeric overflow while converting DECIMAL to BIGINT", new Object[0]);
        this.putAndCheckFailure(CastFunctionIntegrationTest.decimal("-92233720368547758080"), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 2000, "Numeric overflow while converting DECIMAL to BIGINT", new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("1.1"), new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.1f), new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.1, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.decimal("1.1"), CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, CastFunctionIntegrationTest.decimal("1.1"), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(BigDecimal.ZERO, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testDecimal_literal_small() {
        this.put(1);
        String literal = CastFunctionIntegrationTest.literal("1.1");
        BigDecimal decimalValue = CastFunctionIntegrationTest.decimal(literal);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, literal, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.INTEGER), SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BIGINT), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, decimalValue, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(decimalValue.floatValue()), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, decimalValue.doubleValue(), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DATE), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.OBJECT), SqlColumnType.OBJECT, decimalValue, new Object[0]);
    }

    @Test
    public void testDecimal_literal_big() {
        this.put(1);
        String literal = CastFunctionIntegrationTest.literal("92233720368547758070.1");
        BigDecimal decimalValue = CastFunctionIntegrationTest.decimal(literal);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, literal, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 92233720368547758070.1 to type TINYINT: Numeric overflow while converting DECIMAL to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal 92233720368547758070.1 to type SMALLINT: Numeric overflow while converting DECIMAL to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal 92233720368547758070.1 to type INTEGER: Numeric overflow while converting DECIMAL to INTEGER", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal 92233720368547758070.1 to type BIGINT: Numeric overflow while converting DECIMAL to BIGINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, decimalValue, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(decimalValue.floatValue()), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, decimalValue.doubleValue(), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DATE), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DECIMAL, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.OBJECT), SqlColumnType.OBJECT, decimalValue, new Object[0]);
    }

    @Test
    public void testReal() {
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.FloatVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.1f), CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.1f), CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.1f), CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 1, new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.1f), CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.0f), CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("1"), new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.1f), CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.1f), new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.0f), CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.1f), CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, Float.valueOf(1.1f), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(0.0f), CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.REAL, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(0.0f), CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.REAL, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(0.0f), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.REAL, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(0.0f), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.REAL, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(0.0f), CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.REAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(Float.valueOf(0.0f), CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.REAL, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testDouble() {
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.DoubleVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(1.1, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.putAndCheckValue(1.1, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.putAndCheckValue(1.1, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 1, new Object[0]);
        this.putAndCheckValue(1.1, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.putAndCheckValue(1.0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("1"), new Object[0]);
        this.putAndCheckValue(1.1, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.1f), new Object[0]);
        this.putAndCheckValue(1.0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.putAndCheckValue(1.1, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, 1.1, new Object[0]);
        this.putAndCheckFailure(0.0, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(0.0, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(0.0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(0.0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(0.0, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(0.0, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testApproximateTypeSimplification() {
        this.put(1);
        this.checkValue0("select 1 = cast(1.0000001 as real) from map", SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0("select 1.0E0 = cast(1.0000001 as real) from map", SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0("select cast(1.0 as real) = cast(1.0000001 as real) from map", SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0("select 1 = cast(1.00000001 as real) from map", SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0("select 1.0E0 = cast(1.00000001 as real) from map", SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0("select cast(1.0 as real) = cast(1.00000001 as real) from map", SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0("select 1 = cast(1.000000000000001 as double) from map", SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0("select 1.0E0 = cast(1.000000000000001 as double) from map", SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0("select cast(1.0 as double) = cast(1.000000000000001 as double) from map", SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0("select 1 = cast(1.0000000000000001 as double) from map", SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0("select 1.0E0 = cast(1.0000000000000001 as double) from map", SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0("select cast(1.0 as double) = cast(1.0000000000000001 as double) from map", SqlColumnType.BOOLEAN, true, new Object[0]);
    }

    @Test
    public void testReal_literal() {
        this.put(1);
        this.checkValue0(CastFunctionIntegrationTest.sql("CAST(1.5 AS REAL)", SqlColumnType.OBJECT), SqlColumnType.OBJECT, Float.valueOf(1.5f), new Object[0]);
    }

    @Test
    public void testDouble_literal_small() {
        this.put(1);
        String literal = CastFunctionIntegrationTest.literal("1.1E1");
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, literal, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)11, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)11, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.INTEGER), SqlColumnType.INTEGER, 11, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BIGINT), SqlColumnType.BIGINT, 11L, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("11"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(11.0f), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 11.0, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DATE), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.OBJECT), SqlColumnType.OBJECT, 11.0, new Object[0]);
    }

    @Test
    public void testDouble_literal_big() {
        this.put(1);
        String literal = CastFunctionIntegrationTest.literal("1.1E35");
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, literal, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 1.1E35 to type TINYINT: Numeric overflow while converting DOUBLE to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal 1.1E35 to type SMALLINT: Numeric overflow while converting DOUBLE to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal 1.1E35 to type INTEGER: Numeric overflow while converting DOUBLE to INTEGER", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal 1.1E35 to type BIGINT: Numeric overflow while converting DOUBLE to BIGINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("1.1E35"), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.1E35f), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.1E35, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DATE), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.OBJECT), SqlColumnType.OBJECT, 1.1E35, new Object[0]);
    }

    @Test
    public void testDouble_literal_huge() {
        this.put(1);
        String literal = CastFunctionIntegrationTest.literal("1.1E100");
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, literal, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TINYINT), 1008, "CAST function cannot convert literal 1.1E100 to type TINYINT: Numeric overflow while converting DOUBLE to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.SMALLINT), 1008, "CAST function cannot convert literal 1.1E100 to type SMALLINT: Numeric overflow while converting DOUBLE to SMALLINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.INTEGER), 1008, "CAST function cannot convert literal 1.1E100 to type INTEGER: Numeric overflow while converting DOUBLE to INTEGER", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.BIGINT), 1008, "CAST function cannot convert literal 1.1E100 to type BIGINT: Numeric overflow while converting DOUBLE to BIGINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, CastFunctionIntegrationTest.decimal("1.100000000000000036919869142993200560714308010269170019300014421873657477457E+100"), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.REAL), 1008, "CAST function cannot convert literal 1.1E100 to type REAL: Numeric overflow while converting DOUBLE to REAL", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.1E100, new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.DATE), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.DATE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIME), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DOUBLE, SqlColumnType.JSON), new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql(literal, SqlColumnType.OBJECT), SqlColumnType.OBJECT, 1.1E100, new Object[0]);
    }

    @Test
    public void testDate() {
        this.putAndCheckValue(new ExpressionValue.LocalDateVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DATE), SqlColumnType.DATE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, LOCAL_DATE_VAL.toString(), new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), SqlColumnType.DATE, LOCAL_DATE_VAL, new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LocalDateConverter.INSTANCE.asTimestamp((Object)LOCAL_DATE_VAL), new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, LocalDateConverter.INSTANCE.asTimestampWithTimezone((Object)LOCAL_DATE_VAL), new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, LOCAL_DATE_VAL, new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.TINYINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.SMALLINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.DATE, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testTime() {
        this.putAndCheckValue(new ExpressionValue.LocalTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIME), SqlColumnType.TIME, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, LOCAL_TIME_VAL.toString(), new Object[0]);
        this.putAndCheckValue(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), SqlColumnType.TIME, LOCAL_TIME_VAL, new Object[0]);
        this.putAndCheckValue(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LocalTimeConverter.INSTANCE.asTimestamp((Object)LOCAL_TIME_VAL), new Object[0]);
        this.putAndCheckValue(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, LocalTimeConverter.INSTANCE.asTimestampWithTimezone((Object)LOCAL_TIME_VAL), new Object[0]);
        this.putAndCheckValue(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, LOCAL_TIME_VAL, new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.TINYINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.SMALLINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.TIME, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testTimestamp() {
        this.putAndCheckValue(new ExpressionValue.LocalDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DATE), SqlColumnType.DATE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIME), SqlColumnType.TIME, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.LocalDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, LOCAL_DATE_TIME_VAL.toString(), new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), SqlColumnType.DATE, LocalDateTimeConverter.INSTANCE.asDate((Object)LOCAL_DATE_TIME_VAL), new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), SqlColumnType.TIME, LocalDateTimeConverter.INSTANCE.asTime((Object)LOCAL_DATE_TIME_VAL), new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LOCAL_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, LocalDateTimeConverter.INSTANCE.asTimestampWithTimezone((Object)LOCAL_DATE_TIME_VAL), new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, LOCAL_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.TINYINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.SMALLINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.TIMESTAMP, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testTimestampWithTimezone() {
        this.putAndCheckValue(new ExpressionValue.OffsetDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.OffsetDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DATE), SqlColumnType.DATE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.OffsetDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIME), SqlColumnType.TIME, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.OffsetDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.OffsetDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.OffsetDateTimeVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, OFFSET_DATE_TIME_VAL.toString(), new Object[0]);
        this.putAndCheckValue(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), SqlColumnType.DATE, OffsetDateTimeConverter.INSTANCE.asDate((Object)OFFSET_DATE_TIME_VAL), new Object[0]);
        this.putAndCheckValue(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), SqlColumnType.TIME, OffsetDateTimeConverter.INSTANCE.asTime((Object)OFFSET_DATE_TIME_VAL), new Object[0]);
        this.putAndCheckValue(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, OffsetDateTimeConverter.INSTANCE.asTimestamp((Object)OFFSET_DATE_TIME_VAL), new Object[0]);
        this.putAndCheckValue(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OFFSET_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckValue(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, OFFSET_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.BOOLEAN), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TINYINT), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.SMALLINT), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, CastFunctionIntegrationTest.sql("this", SqlColumnType.JSON), 1008, this.castError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.JSON), new Object[0]);
    }

    @Test
    public void testObject() {
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DATE), SqlColumnType.DATE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIME), SqlColumnType.TIME, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null, new Object[0]);
        this.putAndCheckValue(new ExpressionValue.ObjectVal(), CastFunctionIntegrationTest.sql("field1", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object("foo"), CastFunctionIntegrationTest.sql("field1", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "foo", new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(true), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, true, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object((byte)1), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object((short)1), CastFunctionIntegrationTest.sql("field1", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(1), CastFunctionIntegrationTest.sql("field1", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 1, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(1L), CastFunctionIntegrationTest.sql("field1", SqlColumnType.BIGINT), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(BIG_DECIMAL_VAL), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, BIG_DECIMAL_VAL, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(Float.valueOf(1.0f)), CastFunctionIntegrationTest.sql("field1", SqlColumnType.REAL), SqlColumnType.REAL, Float.valueOf(1.0f), new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(1.0), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(LOCAL_DATE_VAL), CastFunctionIntegrationTest.sql("field1", SqlColumnType.DATE), SqlColumnType.DATE, LOCAL_DATE_VAL, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(LOCAL_TIME_VAL), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIME), SqlColumnType.TIME, LOCAL_TIME_VAL, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(LOCAL_DATE_TIME_VAL), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, LOCAL_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object(OFFSET_DATE_TIME_VAL), CastFunctionIntegrationTest.sql("field1", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OFFSET_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckValue(CastFunctionIntegrationTest.object("foo"), CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, CastFunctionIntegrationTest.object("foo"), new Object[0]);
    }

    @Test
    public void testJson() {
        HazelcastJsonValue value = new HazelcastJsonValue("[1,2,3]");
        this.putAndCheckValue(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "[1,2,3]", new Object[0]);
        this.putAndCheckValue(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.OBJECT), SqlColumnType.OBJECT, value, new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.TINYINT), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.TINYINT), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.SMALLINT), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.SMALLINT), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.INTEGER), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.INTEGER), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.BIGINT), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.BIGINT), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.DECIMAL), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.DECIMAL), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.REAL), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.REAL), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.DOUBLE), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.DOUBLE), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.DATE), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIME), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(value, CastFunctionIntegrationTest.sql("this", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), 1008, this.castError(SqlColumnType.JSON, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
    }

    @Test
    public void testNullLiteral() {
        this.put(1);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.BOOLEAN), SqlColumnType.BOOLEAN, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.TINYINT), SqlColumnType.TINYINT, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.SMALLINT), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.INTEGER), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.BIGINT), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.DECIMAL), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.REAL), SqlColumnType.REAL, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.DOUBLE), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.DATE), SqlColumnType.DATE, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.TIME), SqlColumnType.TIME, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.TIMESTAMP), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null, new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("null", SqlColumnType.OBJECT), SqlColumnType.OBJECT, null, new Object[0]);
    }

    @Test
    public void testNestedCastsOfLiterals() {
        this.put(1);
        this.checkFailure0(CastFunctionIntegrationTest.sql("CAST(128 AS INTEGER)", SqlColumnType.TINYINT), 1008, "Numeric overflow while converting SMALLINT to TINYINT", new Object[0]);
        this.checkFailure0(CastFunctionIntegrationTest.sql("CAST(128 AS SMALLINT)", SqlColumnType.TINYINT), 1008, "Numeric overflow while converting SMALLINT to TINYINT", new Object[0]);
        this.checkValue0(CastFunctionIntegrationTest.sql("CAST(42 AS SMALLINT)", SqlColumnType.TINYINT), SqlColumnType.TINYINT, (byte)42, new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(0);
        this.checkValue0(CastFunctionIntegrationTest.sql("?", SqlColumnType.VARCHAR), SqlColumnType.VARCHAR, "1", 1);
        this.checkValue0(CastFunctionIntegrationTest.sql("?", SqlColumnType.INTEGER), SqlColumnType.INTEGER, 1, "1");
        this.checkValue0(CastFunctionIntegrationTest.sql("?", SqlColumnType.JSON), SqlColumnType.JSON, new HazelcastJsonValue("[1]"), "[1]");
    }

    @Test
    public void testEquality() {
        CastFunctionIntegrationTest.checkEquals(CastExpression.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), CastExpression.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), true);
        CastFunctionIntegrationTest.checkEquals(CastExpression.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), CastExpression.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.DOUBLE), false);
        CastFunctionIntegrationTest.checkEquals(CastExpression.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), CastExpression.create((Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
    }

    @Test
    public void testSerialization() {
        CastExpression original = CastExpression.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT);
        CastExpression restored = (CastExpression)CastFunctionIntegrationTest.serializeAndCheck(original, 36);
        CastFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    private static String sql(String source, SqlColumnType targetType) {
        return "SELECT CAST(" + source + " AS " + String.valueOf(targetType) + ") FROM map";
    }

    protected String castError(SqlColumnType type1, SqlColumnType type2) {
        return "CAST function cannot convert value of type " + String.valueOf(type1) + " to type " + String.valueOf(type2);
    }

    private static String string(Object value) {
        return value.toString();
    }

    private static BigDecimal decimal(Object value) {
        return new BigDecimal(value.toString());
    }

    private static ExpressionValue object(Object value) {
        return new ExpressionValue.ObjectVal().field1(value);
    }

    private static String stringLiteral(Object value) {
        return "'" + String.valueOf(value) + "'";
    }

    private static String literal(Object value) {
        return String.valueOf(value);
    }
}

