/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class UnaryPlusIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testColumn() {
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), UnaryPlusIntegrationTest.sql("field1"), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue((byte)0, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.putAndCheckValue((byte)1, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.putAndCheckValue((byte)-1, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.TINYINT, (byte)-1, new Object[0]);
        this.putAndCheckValue((byte)127, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.TINYINT, (byte)127, new Object[0]);
        this.putAndCheckValue((byte)-128, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.TINYINT, (byte)-128, new Object[0]);
        this.putAndCheckValue((short)0, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue((short)1, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.putAndCheckValue((short)-1, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)-1, new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE, new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE, new Object[0]);
        this.putAndCheckValue(0, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue(1, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.INTEGER, 1, new Object[0]);
        this.putAndCheckValue(-1, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.INTEGER, -1, new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.INTEGER, Integer.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.INTEGER, Integer.MIN_VALUE, new Object[0]);
        this.putAndCheckValue(0L, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue(1L, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.putAndCheckValue(-1L, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.BIGINT, -1L, new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.putAndCheckValue(BigInteger.ONE, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.DECIMAL, BigDecimal.ONE, new Object[0]);
        this.putAndCheckValue(BigDecimal.ONE, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.DECIMAL, BigDecimal.ONE, new Object[0]);
        this.putAndCheckValue(Float.valueOf(0.0f), UnaryPlusIntegrationTest.sql("this"), SqlColumnType.REAL, Float.valueOf(0.0f), new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.0f), UnaryPlusIntegrationTest.sql("this"), SqlColumnType.REAL, Float.valueOf(1.0f), new Object[0]);
        this.putAndCheckValue(Float.valueOf(-1.0f), UnaryPlusIntegrationTest.sql("this"), SqlColumnType.REAL, Float.valueOf(-1.0f), new Object[0]);
        this.putAndCheckValue(0.0, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.putAndCheckValue(1.0, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.putAndCheckValue(-1.0, UnaryPlusIntegrationTest.sql("this"), SqlColumnType.DOUBLE, -1.0, new Object[0]);
        this.putAndCheckFailure("foo", UnaryPlusIntegrationTest.sql("this"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(true, UnaryPlusIntegrationTest.sql("this"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, UnaryPlusIntegrationTest.sql("this"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, UnaryPlusIntegrationTest.sql("this"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, UnaryPlusIntegrationTest.sql("this"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, UnaryPlusIntegrationTest.sql("this"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, UnaryPlusIntegrationTest.sql("this"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.OBJECT), new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(1);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), Character.valueOf('f'));
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.checkValue0(UnaryPlusIntegrationTest.sql("?"), SqlColumnType.BIGINT, 1L, (byte)1);
        this.checkValue0(UnaryPlusIntegrationTest.sql("?"), SqlColumnType.BIGINT, 1L, (short)1);
        this.checkValue0(UnaryPlusIntegrationTest.sql("?"), SqlColumnType.BIGINT, 1L, 1);
        this.checkValue0(UnaryPlusIntegrationTest.sql("?"), SqlColumnType.BIGINT, 1L, 1L);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigInteger.ONE);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigDecimal.ONE);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("?"), 2000, UnaryPlusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testLiteral() {
        this.put(1);
        this.checkValue0(UnaryPlusIntegrationTest.sql("null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(UnaryPlusIntegrationTest.sql("1"), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue0(UnaryPlusIntegrationTest.sql("1.1"), SqlColumnType.DECIMAL, new BigDecimal("1.1"), new Object[0]);
        this.checkValue0(UnaryPlusIntegrationTest.sql("1.1E0"), SqlColumnType.DOUBLE, 1.1, new Object[0]);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("'foo'"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0(UnaryPlusIntegrationTest.sql("true"), 1008, UnaryPlusIntegrationTest.signatureError(SqlColumnType.BOOLEAN), new Object[0]);
    }

    private static String signatureError(SqlColumnType type) {
        return UnaryPlusIntegrationTest.signatureErrorOperator("+", type);
    }

    private static String sql(String attribute) {
        return "SELECT +" + attribute + " FROM map";
    }
}

