/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.math.ArithmeticOperatorIntegrationTest;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.RemainderFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class RemainderOperatorIntegrationTest
extends ArithmeticOperatorIntegrationTest {
    @Override
    protected String operator() {
        return "%";
    }

    @Test
    public void testTinyint_left() {
        this.putAndCheckValue((byte)0, this.sql("this", "null"), SqlColumnType.TINYINT, null, new Object[0]);
        this.putAndCheckValue((byte)0, this.sql("null", "this"), SqlColumnType.TINYINT, null, new Object[0]);
        this.checkFields((byte)3, (byte)2, SqlColumnType.TINYINT, (byte)1);
        this.checkFields((byte)3, (byte)4, SqlColumnType.TINYINT, (byte)3);
        this.checkError((byte)3, (byte)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((byte)3, (short)2, SqlColumnType.SMALLINT, (short)1);
        this.checkFields((byte)3, (short)4, SqlColumnType.SMALLINT, (short)3);
        this.checkError((byte)3, (short)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((byte)3, 2, SqlColumnType.INTEGER, 1);
        this.checkFields((byte)3, 4, SqlColumnType.INTEGER, 3);
        this.checkError((byte)3, 0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((byte)3, 2L, SqlColumnType.BIGINT, 1L);
        this.checkFields((byte)3, 4L, SqlColumnType.BIGINT, 3L);
        this.checkError((byte)3, 0L, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((byte)3, RemainderOperatorIntegrationTest.decimal("1.4"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("0.2"));
        this.checkError((byte)3, RemainderOperatorIntegrationTest.decimal("0.0"), 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((byte)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)2);
        this.putAndCheckValue((byte)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)2);
        this.putAndCheckValue((byte)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2);
        this.putAndCheckValue((byte)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2L);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testSmallint_left() {
        this.putAndCheckValue((short)0, this.sql("this", "null"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue((short)0, this.sql("null", "this"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkFields((short)3, (byte)2, SqlColumnType.SMALLINT, (short)1);
        this.checkFields((short)3, (byte)4, SqlColumnType.SMALLINT, (short)3);
        this.checkError((short)3, (byte)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((short)3, (short)2, SqlColumnType.SMALLINT, (short)1);
        this.checkFields((short)3, (short)4, SqlColumnType.SMALLINT, (short)3);
        this.checkError((short)3, (short)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((short)3, 2, SqlColumnType.INTEGER, 1);
        this.checkFields((short)3, 4, SqlColumnType.INTEGER, 3);
        this.checkError((short)3, 0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((short)3, 2L, SqlColumnType.BIGINT, 1L);
        this.checkFields((short)3, 4L, SqlColumnType.BIGINT, 3L);
        this.checkError((short)3, 0L, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((short)3, RemainderOperatorIntegrationTest.decimal("1.4"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("0.2"));
        this.checkError((short)3, RemainderOperatorIntegrationTest.decimal("0.0"), 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((short)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)2);
        this.putAndCheckValue((short)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)2);
        this.putAndCheckValue((short)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2);
        this.putAndCheckValue((short)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2L);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testInteger_left() {
        this.putAndCheckValue(0, this.sql("this", "null"), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue(0, this.sql("null", "this"), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkFields(3, (byte)2, SqlColumnType.INTEGER, 1);
        this.checkFields(3, (byte)4, SqlColumnType.INTEGER, 3);
        this.checkError(3, (byte)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(3, (short)2, SqlColumnType.INTEGER, 1);
        this.checkFields(3, (short)4, SqlColumnType.INTEGER, 3);
        this.checkError(3, (short)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(3, 2, SqlColumnType.INTEGER, 1);
        this.checkFields(3, 4, SqlColumnType.INTEGER, 3);
        this.checkError(3, 0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(3, 2L, SqlColumnType.BIGINT, 1L);
        this.checkFields(3, 4L, SqlColumnType.BIGINT, 3L);
        this.checkError(3, 0L, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(3, RemainderOperatorIntegrationTest.decimal("1.4"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("0.2"));
        this.checkError(3, RemainderOperatorIntegrationTest.decimal("0.0"), 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)2);
        this.putAndCheckValue(3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)2);
        this.putAndCheckValue(3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2);
        this.putAndCheckValue(3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2L);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testBigint_left() {
        this.putAndCheckValue(0L, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0L, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFields(3L, (byte)2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3L, (byte)4, SqlColumnType.BIGINT, 3L);
        this.checkError(3L, (byte)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(3L, (short)2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3L, (short)4, SqlColumnType.BIGINT, 3L);
        this.checkError(3L, (short)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(3L, 2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3L, 4, SqlColumnType.BIGINT, 3L);
        this.checkError(3L, 0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(3L, 2L, SqlColumnType.BIGINT, 1L);
        this.checkFields(3L, 4L, SqlColumnType.BIGINT, 3L);
        this.checkError(3L, 0L, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(3L, RemainderOperatorIntegrationTest.decimal("1.4"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("0.2"));
        this.checkError(3L, RemainderOperatorIntegrationTest.decimal("0.0"), 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(3L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)2);
        this.putAndCheckValue(3L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)2);
        this.putAndCheckValue(3L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2);
        this.putAndCheckValue(3L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2L);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigInteger_left() {
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFields(new BigInteger("3"), (byte)2, SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigInteger("3"), (short)2, SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigInteger("3"), 2, SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigInteger("3"), 2L, SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigInteger("3"), new BigInteger("2"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigInteger("3"), RemainderOperatorIntegrationTest.decimal("1.4"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("0.2"));
        this.checkError(new BigInteger("3"), (byte)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigInteger("3"), (short)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigInteger("3"), 0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigInteger("3"), 0L, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigInteger("3"), BigInteger.ZERO, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigInteger("3"), BigDecimal.ZERO, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigInteger("3"), RemainderOperatorIntegrationTest.decimal("0"), 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), (byte)2);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), (short)2);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), 2);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), 2L);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), new BigInteger("2"));
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("0.2"), RemainderOperatorIntegrationTest.decimal("1.4"));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigDecimal_left() {
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFields(new BigDecimal("3"), (byte)2, SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigDecimal("3"), (short)2, SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigDecimal("3"), 2, SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigDecimal("3"), 2L, SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigDecimal("3"), new BigInteger("2"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"));
        this.checkFields(new BigDecimal("3"), RemainderOperatorIntegrationTest.decimal("1.4"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("0.2"));
        this.checkError(new BigDecimal("3"), (byte)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigDecimal("3"), (short)0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigDecimal("3"), 0, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigDecimal("3"), 0L, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigDecimal("3"), BigInteger.ZERO, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigDecimal("3"), BigDecimal.ZERO, 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.checkError(new BigDecimal("3"), RemainderOperatorIntegrationTest.decimal("0"), 2000, RemainderOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), (byte)2);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), (short)2);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), 2);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), 2L);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("1"), new BigInteger("2"));
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, RemainderOperatorIntegrationTest.decimal("0.2"), RemainderOperatorIntegrationTest.decimal("1.4"));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, RemainderOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testReal_left() {
        this.checkUnsupportedForAllTypesCommute(Float.valueOf(1.0f), SqlColumnType.REAL);
    }

    @Test
    public void testDouble_left() {
        this.checkUnsupportedForAllTypesCommute(1.0, SqlColumnType.DOUBLE);
    }

    @Test
    public void testTemporal_left() {
        this.checkUnsupportedForAllTypesCommute(LOCAL_DATE_VAL, SqlColumnType.DATE);
        this.checkUnsupportedForAllTypesCommute(LOCAL_TIME_VAL, SqlColumnType.TIME);
        this.checkUnsupportedForAllTypesCommute(LOCAL_DATE_TIME_VAL, SqlColumnType.TIMESTAMP);
        this.checkUnsupportedForAllTypesCommute(OFFSET_DATE_TIME_VAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
    }

    @Override
    @Test
    public void testNullLiteral() {
        this.put(1);
        this.checkFailure0(this.sql("null", "null"), 1008, this.signatureError(SqlColumnType.NULL, SqlColumnType.NULL), new Object[0]);
        this.checkFailure0(this.sql("'foo'", "null"), 1008, this.signatureError(SqlColumnType.VARCHAR, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0(this.sql("null", "'foo'"), 1008, this.signatureError(SqlColumnType.VARCHAR, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0(this.sql("true", "null"), 1008, this.signatureError(SqlColumnType.BOOLEAN, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure0(this.sql("null", "true"), 1008, this.signatureError(SqlColumnType.BOOLEAN, SqlColumnType.BOOLEAN), new Object[0]);
        this.checkValue0(this.sql("null", 1), SqlColumnType.TINYINT, null, new Object[0]);
        this.checkValue0(this.sql(1, "null"), SqlColumnType.TINYINT, null, new Object[0]);
        this.checkValue0(this.sql("null", (byte)127), SqlColumnType.TINYINT, null, new Object[0]);
        this.checkValue0(this.sql((byte)127, "null"), SqlColumnType.TINYINT, null, new Object[0]);
        this.checkValue0(this.sql("null", (short)Short.MAX_VALUE), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkValue0(this.sql((short)Short.MAX_VALUE, "null"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkValue0(this.sql("null", Integer.MAX_VALUE), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0(this.sql(Integer.MAX_VALUE, "null"), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0(this.sql("null", Long.MAX_VALUE), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(this.sql(Long.MAX_VALUE, "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(this.sql("null", "1.1"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkValue0(this.sql("1.1", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFailure0(this.sql("null", "1.1E1"), 1008, this.signatureError(SqlColumnType.DOUBLE, SqlColumnType.DOUBLE), new Object[0]);
        this.checkFailure0(this.sql("1.1E1", "null"), 1008, this.signatureError(SqlColumnType.DOUBLE, SqlColumnType.DOUBLE), new Object[0]);
    }

    @Test
    public void testEquality() {
        RemainderOperatorIntegrationTest.checkEquals(RemainderFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), RemainderFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), true);
        RemainderOperatorIntegrationTest.checkEquals(RemainderFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), RemainderFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
        RemainderOperatorIntegrationTest.checkEquals(RemainderFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), RemainderFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)100, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), false);
    }

    @Test
    public void testSerialization() {
        RemainderFunction original = RemainderFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        RemainderFunction restored = (RemainderFunction)RemainderOperatorIntegrationTest.serializeAndCheck(original, 66);
        RemainderOperatorIntegrationTest.checkEquals(original, restored, true);
    }

    private static String divisionByZeroError() {
        return "Division by zero";
    }
}

