/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.ParameterExpression;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ColumnIntegrationTest
extends ExpressionTestSupport {
    @Before
    public void before() {
        this.put(1);
    }

    @Test
    public void testLiteral() {
        this.checkValue0(ColumnIntegrationTest.sql("null"), SqlColumnType.NULL, null, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("unknown"), SqlColumnType.BOOLEAN, null, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("''"), SqlColumnType.VARCHAR, "", new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("'f'"), SqlColumnType.VARCHAR, "f", new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("'foo'"), SqlColumnType.VARCHAR, "foo", new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("false"), SqlColumnType.BOOLEAN, false, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("true"), SqlColumnType.BOOLEAN, true, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("0"), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("-0"), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("000"), SqlColumnType.TINYINT, (byte)0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1"), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("-1"), SqlColumnType.TINYINT, (byte)-1, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("001"), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("100"), SqlColumnType.TINYINT, (byte)100, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql((byte)127), SqlColumnType.TINYINT, (byte)127, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql((byte)-128), SqlColumnType.TINYINT, (byte)-128, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql((short)128), SqlColumnType.SMALLINT, (short)128, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql((short)-129), SqlColumnType.SMALLINT, (short)-129, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql((short)Short.MAX_VALUE), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql((short)Short.MIN_VALUE), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(32768), SqlColumnType.INTEGER, 32768, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(-32769), SqlColumnType.INTEGER, -32769, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(Integer.MAX_VALUE), SqlColumnType.INTEGER, Integer.MAX_VALUE, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(Integer.MIN_VALUE), SqlColumnType.INTEGER, Integer.MIN_VALUE, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(0x80000000L), SqlColumnType.BIGINT, 0x80000000L, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(-2147483649L), SqlColumnType.BIGINT, -2147483649L, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(Long.MAX_VALUE), SqlColumnType.BIGINT, Long.MAX_VALUE, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(Long.MIN_VALUE), SqlColumnType.BIGINT, Long.MIN_VALUE, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("92233720368547758070"), SqlColumnType.DECIMAL, new BigDecimal(Long.MAX_VALUE).multiply(BigDecimal.TEN), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("0.0"), SqlColumnType.DECIMAL, new BigDecimal("0.0"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1.0"), SqlColumnType.DECIMAL, new BigDecimal("1.0"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1.000"), SqlColumnType.DECIMAL, new BigDecimal("1.000"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("001.000"), SqlColumnType.DECIMAL, new BigDecimal("1.000"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1.1"), SqlColumnType.DECIMAL, new BigDecimal("1.1"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1.100"), SqlColumnType.DECIMAL, new BigDecimal("1.100"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("001.100"), SqlColumnType.DECIMAL, new BigDecimal("1.100"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("-0.0"), SqlColumnType.DECIMAL, new BigDecimal("0.0"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("-1.0"), SqlColumnType.DECIMAL, new BigDecimal("-1.0"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("-001.100"), SqlColumnType.DECIMAL, new BigDecimal("-1.100"), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(".0"), SqlColumnType.DECIMAL, BigDecimal.valueOf(0.0), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(".1"), SqlColumnType.DECIMAL, BigDecimal.valueOf(0.1), new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("0e0"), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1e0"), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1e000"), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("001e000"), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1.1e0"), SqlColumnType.DOUBLE, 1.1, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1.100e0"), SqlColumnType.DOUBLE, 1.1, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("001.100e0"), SqlColumnType.DOUBLE, 1.1, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("-0.0e0"), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("-1.0e0"), SqlColumnType.DOUBLE, -1.0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("-001.100e0"), SqlColumnType.DOUBLE, -1.1, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(".0e0"), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql(".1e0"), SqlColumnType.DOUBLE, 0.1, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1.1e1"), SqlColumnType.DOUBLE, 11.0, new Object[0]);
        this.checkValue0(ColumnIntegrationTest.sql("1.1e-1"), SqlColumnType.DOUBLE, 0.11, new Object[0]);
    }

    @Test
    public void testLiteralEquality() {
        ColumnIntegrationTest.checkEquals(ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), true);
        ColumnIntegrationTest.checkEquals(ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.BIGINT), false);
        ColumnIntegrationTest.checkEquals(ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), false);
    }

    @Test
    public void testLiteralSerialization() {
        ConstantExpression original = ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT);
        ConstantExpression restored = (ConstantExpression)ColumnIntegrationTest.serializeAndCheck(original, 34);
        ColumnIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    public void testParameter() {
        this.checkFailure0(ColumnIntegrationTest.sql("?"), 1008, "Illegal use of dynamic parameter", 1);
    }

    @Test
    public void testParameterEquality() {
        ColumnIntegrationTest.checkEquals(ParameterExpression.create((int)1, (QueryDataType)QueryDataType.INT), ParameterExpression.create((int)1, (QueryDataType)QueryDataType.INT), true);
        ColumnIntegrationTest.checkEquals(ParameterExpression.create((int)1, (QueryDataType)QueryDataType.INT), ParameterExpression.create((int)1, (QueryDataType)QueryDataType.BIGINT), false);
        ColumnIntegrationTest.checkEquals(ParameterExpression.create((int)1, (QueryDataType)QueryDataType.INT), ParameterExpression.create((int)2, (QueryDataType)QueryDataType.INT), false);
    }

    @Test
    public void testParameterSerialization() {
        ParameterExpression original = ParameterExpression.create((int)1, (QueryDataType)QueryDataType.INT);
        ParameterExpression restored = (ParameterExpression)ColumnIntegrationTest.serializeAndCheck(original, 35);
        ColumnIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    public void testColumn_auto() {
        for (ExpressionType<?> type : ExpressionTypes.all()) {
            Class<? extends ExpressionValue> clazz = ExpressionValue.createClass(type.typeName());
            Object value = ExpressionValue.create(clazz, type.valueFrom());
            Object nullValue = ExpressionValue.create(clazz, null);
            SqlColumnType expectedType = type.getFieldConverterType().getTypeFamily().getPublicType();
            Object expectedResult = type.getFieldConverterType().getConverter().convertToSelf(type.getFieldConverterType().getConverter(), type.valueFrom());
            this.putAndCheckValue(value, ColumnIntegrationTest.sql("field1"), expectedType, expectedResult, new Object[0]);
            this.putAndCheckValue(nullValue, ColumnIntegrationTest.sql("field1"), expectedType, null, new Object[0]);
        }
    }

    @Test
    public void testColumn_manual() {
        this.putAndCheckValue(Character.valueOf('f'), ColumnIntegrationTest.sql("this"), SqlColumnType.VARCHAR, "f", new Object[0]);
        this.putAndCheckValue("foo", ColumnIntegrationTest.sql("this"), SqlColumnType.VARCHAR, "foo", new Object[0]);
        this.putAndCheckValue(true, ColumnIntegrationTest.sql("this"), SqlColumnType.BOOLEAN, true, new Object[0]);
        this.putAndCheckValue((byte)1, ColumnIntegrationTest.sql("this"), SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.putAndCheckValue((short)1, ColumnIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.putAndCheckValue(1, ColumnIntegrationTest.sql("this"), SqlColumnType.INTEGER, 1, new Object[0]);
        this.putAndCheckValue(1L, ColumnIntegrationTest.sql("this"), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.putAndCheckValue(BigInteger.ONE, ColumnIntegrationTest.sql("this"), SqlColumnType.DECIMAL, BigDecimal.ONE, new Object[0]);
        this.putAndCheckValue(BigDecimal.ONE, ColumnIntegrationTest.sql("this"), SqlColumnType.DECIMAL, BigDecimal.ONE, new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.0f), ColumnIntegrationTest.sql("this"), SqlColumnType.REAL, Float.valueOf(1.0f), new Object[0]);
        this.putAndCheckValue(1.0, ColumnIntegrationTest.sql("this"), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_VAL, ColumnIntegrationTest.sql("this"), SqlColumnType.DATE, LOCAL_DATE_VAL, new Object[0]);
        this.putAndCheckValue(LOCAL_TIME_VAL, ColumnIntegrationTest.sql("this"), SqlColumnType.TIME, LOCAL_TIME_VAL, new Object[0]);
        this.putAndCheckValue(LOCAL_DATE_TIME_VAL, ColumnIntegrationTest.sql("this"), SqlColumnType.TIMESTAMP, LOCAL_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckValue(OFFSET_DATE_TIME_VAL, ColumnIntegrationTest.sql("this"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OFFSET_DATE_TIME_VAL, new Object[0]);
        this.putAndCheckValue(OBJECT_VAL, ColumnIntegrationTest.sql("this"), SqlColumnType.OBJECT, OBJECT_VAL, new Object[0]);
    }

    @Test
    public void testColumnEquality() {
        ColumnIntegrationTest.checkEquals(ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), true);
        ColumnIntegrationTest.checkEquals(ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), ColumnExpression.create((int)1, (QueryDataType)QueryDataType.BIGINT), false);
        ColumnIntegrationTest.checkEquals(ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), ColumnExpression.create((int)2, (QueryDataType)QueryDataType.INT), false);
    }

    @Test
    public void testColumnSerialization() {
        ColumnExpression original = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT);
        ColumnExpression restored = (ColumnExpression)ColumnIntegrationTest.serializeAndCheck(original, 32);
        ColumnIntegrationTest.checkEquals(original, restored, true);
    }

    private static String sql(Object attribute) {
        return "SELECT " + String.valueOf(attribute) + " FROM map";
    }
}

