/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.test;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class TestAbstractSqlConnector
implements SqlConnector {
    private static final String OPTION_NAMES = "names";
    private static final String OPTION_TYPES = "types";
    private static final String OPTION_VALUES = "values";
    private static final String OPTION_STREAMING = "streaming";
    private static final String DELIMITER = ",";
    private static final String VALUES_DELIMITER = "\n";
    private static final String NULL = "null";

    static void create(SqlService sqlService, String connectorType, String tableName, List<String> names, List<QueryDataTypeFamily> types, List<String[]> values, boolean streamingActual) {
        if (names.stream().anyMatch(n -> n.contains(DELIMITER) || n.contains("'"))) {
            throw new IllegalArgumentException("',' and apostrophe not supported in names");
        }
        if (types.contains(QueryDataTypeFamily.OBJECT) || types.contains(QueryDataTypeFamily.NULL)) {
            throw new IllegalArgumentException("NULL and OBJECT type not supported: " + String.valueOf(types));
        }
        if (values.stream().flatMap(Arrays::stream).filter(Objects::nonNull).anyMatch(n -> n.equals(NULL) || n.contains(VALUES_DELIMITER) || n.contains("'"))) {
            throw new IllegalArgumentException("The text 'null', the newline character and apostrophe not supported in values");
        }
        String namesSerialized = String.join((CharSequence)DELIMITER, names);
        String typesSerialized = types.stream().map(Enum::name).collect(Collectors.joining(DELIMITER));
        String valuesSerialized = values.stream().map(row -> String.join((CharSequence)DELIMITER, row)).collect(Collectors.joining(VALUES_DELIMITER));
        String sql = "CREATE MAPPING " + tableName + " TYPE " + connectorType + " OPTIONS ('names'='" + namesSerialized + "', 'types'='" + typesSerialized + "', 'values'='" + valuesSerialized + "', 'streaming'='" + streamingActual + "')";
        System.out.println(sql);
        sqlService.executeUpdate(sql, new Object[0]);
    }

    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        if (!userFields.isEmpty()) {
            throw QueryException.error((String)"Don't specify external fields, they are fixed");
        }
        String[] names = ((String)externalResource.options().get(OPTION_NAMES)).split(DELIMITER);
        String[] types = ((String)externalResource.options().get(OPTION_TYPES)).split(DELIMITER);
        assert (names.length == types.length);
        ArrayList<MappingField> fields = new ArrayList<MappingField>(names.length);
        for (int i = 0; i < names.length; ++i) {
            fields.add(new MappingField(names[i], QueryDataTypeUtils.resolveTypeForTypeFamily((QueryDataTypeFamily)QueryDataTypeFamily.valueOf((String)types[i]))));
        }
        return fields;
    }

    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        String[] rowsSerialized;
        Map options = externalResource.options();
        String[] names = ((String)options.get(OPTION_NAMES)).split(DELIMITER);
        String[] types = ((String)options.get(OPTION_TYPES)).split(DELIMITER);
        assert (names.length == types.length);
        ArrayList<TableField> fields = new ArrayList<TableField>(names.length);
        for (int i = 0; i < names.length; ++i) {
            fields.add(new TableField(names[i], QueryDataTypeUtils.resolveTypeForTypeFamily((QueryDataTypeFamily)QueryDataTypeFamily.valueOf((String)types[i])), false));
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (String rowSerialized : rowsSerialized = ((String)options.get(OPTION_VALUES)).split(VALUES_DELIMITER)) {
            if (rowSerialized.isEmpty()) continue;
            String[] values = rowSerialized.split(DELIMITER);
            assert (values.length == fields.size());
            Object[] row = new Object[values.length];
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                row[i] = NULL.equals(value) ? null : ((TableField)fields.get(i)).getType().convert((Object)values[i]);
            }
            rows.add(row);
        }
        boolean streaming = Boolean.parseBoolean((String)options.get(OPTION_STREAMING));
        return new TestTable(this, schemaName, mappingName, fields, rows, streaming);
    }

    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable List<Map<String, Expression<?>>> partitionPruningCandidates, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        TestTable table = (TestTable)context.getTable();
        List<Object[]> rows = table.rows;
        boolean streaming = table.streaming;
        Expression convertedPredicate = context.convertFilter(predicate);
        List convertedProjection = context.convertProjection(projection);
        FunctionEx & Serializable createContextFn = (FunctionEx & Serializable)ctx -> {
            ExpressionEvalContext evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)ctx);
            EventTimePolicy eventTimePolicy = eventTimePolicyProvider == null ? EventTimePolicy.noEventTime() : (EventTimePolicy)eventTimePolicyProvider.apply((Object)evalContext);
            return new TestDataGenerator(rows, (Expression<Boolean>)convertedPredicate, convertedProjection, evalContext, (EventTimePolicy<JetSqlRow>)eventTimePolicy, streaming);
        };
        ProcessorMetaSupplier pms = this.createProcessorSupplier((FunctionEx<Processor.Context, TestDataGenerator>)createContextFn);
        return context.getDag().newUniqueVertex(table.toString(), pms);
    }

    public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        return true;
    }

    protected abstract ProcessorMetaSupplier createProcessorSupplier(FunctionEx<Processor.Context, TestDataGenerator> var1);

    public static final class TestTable
    extends JetTable {
        private final List<Object[]> rows;
        private final boolean streaming;

        private TestTable(@Nonnull SqlConnector sqlConnector, @Nonnull String schemaName, @Nonnull String name, @Nonnull List<TableField> fields, @Nonnull List<Object[]> rows, boolean streaming) {
            super(sqlConnector, fields, schemaName, name, (TableStatistics)new ConstantTableStatistics((long)rows.size()), null, streaming);
            this.rows = rows;
            this.streaming = streaming;
        }

        public PlanObjectKey getObjectKey() {
            return new TestTablePlanObjectKey(this.getSchemaName(), this.getSqlName(), this.rows);
        }
    }

    static final class TestDataGenerator {
        private static final int MAX_BATCH_SIZE = 1024;
        private final Traverser<Object> traverser;
        private final boolean streaming;

        private TestDataGenerator(List<Object[]> rows, Expression<Boolean> predicate, List<Expression<?>> projections, ExpressionEvalContext evalContext, EventTimePolicy<JetSqlRow> eventTimePolicy, boolean streaming) {
            EventTimeMapper eventTimeMapper = new EventTimeMapper(eventTimePolicy);
            eventTimeMapper.addPartitions(1);
            this.traverser = Traversers.traverseIterable(rows).flatMap(row -> {
                JetSqlRow evaluated = ExpressionUtil.evaluate((Expression)predicate, (List)projections, (JetSqlRow)new JetSqlRow((SerializationService)evalContext.getSerializationService(), row), (ExpressionEvalContext)evalContext);
                return evaluated == null ? Traversers.empty() : eventTimeMapper.flatMapEvent((Object)evaluated, 0, -1L);
            });
            this.streaming = streaming;
        }

        void fillBuffer(SourceBuilder.SourceBuffer<Object> buffer) {
            for (int i = 0; i < 1024; ++i) {
                Object o = this.traverser.next();
                if (o == null) {
                    if (!this.streaming) {
                        buffer.close();
                    }
                    return;
                }
                buffer.add(o);
            }
        }
    }

    private static final class TestTablePlanObjectKey
    implements PlanObjectKey {
        private final String schemaName;
        private final String name;
        private final List<Object[]> rows;

        private TestTablePlanObjectKey(String schemaName, String name, List<Object[]> rows) {
            this.schemaName = schemaName;
            this.name = name;
            this.rows = rows;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestTablePlanObjectKey that = (TestTablePlanObjectKey)o;
            return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.name, that.name) && Objects.equals(this.rows, that.rows);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.name, this.rows);
        }
    }
}

