/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map.index;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.sql.impl.SqlEndToEndTestSupport;
import com.hazelcast.map.IMap;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlIndexSortTest
extends SqlEndToEndTestSupport {
    private static final String MAP_NAME = "map";
    private static final String INDEX_SCAN_VERTEX_NAME = "Index(IMap[public.map])";
    private Condition<DAG> indexScan = new Condition(dag -> dag.vertices().stream().anyMatch(v -> v.getName().equals(INDEX_SCAN_VERTEX_NAME)), "Should use index scan", new Object[0]);
    private Condition<DAG> sortCombine = new Condition(dag -> dag.vertices().stream().anyMatch(v -> v.getName().equals("SortCombine")), "Should combine index scan output", new Object[0]);
    private Condition<DAG> sort = new Condition(dag -> dag.vertices().stream().anyMatch(v -> v.getName().equals("Sort")), "Should sort the result output", new Object[0]);

    @BeforeClass
    public static void beforeClass() {
        SqlIndexSortTest.initialize((int)1, (Config)SqlIndexSortTest.smallInstanceConfig());
    }

    @Before
    public void before() {
        IndexConfig indexConfig = new IndexConfig().setName("index").setType(IndexType.SORTED).addAttribute("this");
        SqlIndexSortTest.instance().getMap(MAP_NAME).addIndex(indexConfig);
        IMap map = SqlIndexSortTest.instance().getMap(MAP_NAME);
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)(i * 10));
        }
        SqlIndexSortTest.createMapping(MAP_NAME, Integer.class, Integer.class);
    }

    @Test
    public void shouldUseSortCombine_whenOrderByNoAggregation() {
        SqlIndexSortTest.instance().getSql().execute("select * from map order by this", new Object[0]).close();
        ((ObjectAssert)((ObjectAssert)this.assertThatDag().has(this.indexScan)).has(this.sortCombine)).doesNotHave(this.sort);
    }

    @Test
    public void shouldSortLate_whenOrderByWithJoin() {
        SqlIndexSortTest.instance().getSql().execute("select m1.this from map m1 join map m2 on m2.__key = m1.this where m1.this < 5 order by m1.this + m2.this", new Object[0]).close();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThatDag().has(this.indexScan)).has(this.sortCombine)).has(this.sort)).has(this.edgeBetween("Sort", "SortCombine"))).doesNotHave(this.edgeBetween(INDEX_SCAN_VERTEX_NAME, "SortCombine"))).doesNotHave(this.edgeBetween(INDEX_SCAN_VERTEX_NAME, "Sort"));
    }

    @Test
    public void shouldNotUseSortCombine_whenAggregationWithoutOrderBy() {
        SqlIndexSortTest.instance().getSql().execute("select sum(this) from map where this between 5 and 15", new Object[0]).close();
        ((ObjectAssert)((ObjectAssert)this.assertThatDag().has(this.indexScan)).doesNotHave(this.sortCombine)).doesNotHave(this.sort);
    }

    @Test
    public void shouldNotUseSortCombine_whenUnion() {
        SqlIndexSortTest.instance().getSql().execute("select this from map where this < 5union select this from map where this > 5", new Object[0]).close();
        ((ObjectAssert)((ObjectAssert)this.assertThatDag().has(this.indexScan)).doesNotHave(this.sortCombine)).doesNotHave(this.sort);
    }

    @Test
    public void shouldNotUseSortCombine_whenUnionAll() {
        SqlIndexSortTest.instance().getSql().execute("select this from map where this < 5union all select this from map where this > 5", new Object[0]).close();
        ((ObjectAssert)((ObjectAssert)this.assertThatDag().has(this.indexScan)).doesNotHave(this.sortCombine)).doesNotHave(this.sort);
    }

    private Condition<DAG> edgeBetween(String sourceName, String destName) {
        return new Condition(dag -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(dag.edgeIterator(), 16), false).anyMatch(e -> e.getSourceName().equals(sourceName) && e.getDestName().equals(destName)), "Should have edge between " + sourceName + " and " + destName, new Object[0]);
    }
}

