/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map.index;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.connector.map.index.SqlIndexTestSupport;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.SortLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.LimitPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlIndexFromSearchFilterTest
extends SqlIndexTestSupport {
    public static final int MAP_SIZE = 1000;
    public static final String F_1_INDEX = "f1_index";
    public static final String F_2_INDEX = "f2_index";
    private String mapName;

    @BeforeClass
    public static void beforeClass() {
        SqlIndexFromSearchFilterTest.initialize((int)3, null);
    }

    @Before
    public void before() throws Exception {
        this.mapName = SqlIndexFromSearchFilterTest.randomName();
        Class<? extends ExpressionBiValue> valueClass = ExpressionBiValue.createBiClass(ExpressionTypes.INTEGER, ExpressionTypes.INTEGER);
        IMap map = SqlIndexFromSearchFilterTest.instance().getMap(this.mapName);
        SqlIndexFromSearchFilterTest.createMapping(this.mapName, Integer.TYPE, valueClass);
        SqlIndexFromSearchFilterTest.createIndex(F_1_INDEX, this.mapName, IndexType.SORTED, "field1");
        SqlIndexFromSearchFilterTest.createIndex(F_2_INDEX, this.mapName, IndexType.SORTED, "field2");
        for (int i = 1; i <= 1000; ++i) {
            map.put((Object)i, ExpressionBiValue.createBiValue(valueClass, i, i, i));
        }
    }

    @Test
    public void when_selectWithRange_then_properPlanAndIndex() {
        String sql = "SELECT * FROM  \n" + this.mapName + " WHERE field1 >= 100\n AND field1 <= 10000 \n";
        OptimizerTestSupport.Result optimizePhysical = this.optimizePhysical(sql, this.parameterTypes(), this.table());
        SqlIndexFromSearchFilterTest.assertPlan((RelNode)optimizePhysical.getLogical(), SqlIndexFromSearchFilterTest.plan(SqlIndexFromSearchFilterTest.planRow(0, FullScanLogicalRel.class)));
        SqlIndexFromSearchFilterTest.assertPlan((RelNode)optimizePhysical.getPhysical(), SqlIndexFromSearchFilterTest.plan(SqlIndexFromSearchFilterTest.planRow(0, IndexScanMapPhysicalRel.class)));
        IndexScanMapPhysicalRel rel = (IndexScanMapPhysicalRel)optimizePhysical.getPhysical();
        Assert.assertEquals((Object)F_1_INDEX, (Object)rel.getIndex().getName());
    }

    @Test
    public void when_selectWithTwoRanges_then_properPlanAndIndex() {
        String sql = "SELECT * FROM  \n" + this.mapName + " WHERE (field1 >= 100 AND field1 <= 10000) \n OR (field1 >= 10100 AND field1 <= 20000) \n";
        OptimizerTestSupport.Result optimizePhysical = this.optimizePhysical(sql, this.parameterTypes(), this.table());
        SqlIndexFromSearchFilterTest.assertPlan((RelNode)optimizePhysical.getLogical(), SqlIndexFromSearchFilterTest.plan(SqlIndexFromSearchFilterTest.planRow(0, FullScanLogicalRel.class)));
        SqlIndexFromSearchFilterTest.assertPlan((RelNode)optimizePhysical.getPhysical(), SqlIndexFromSearchFilterTest.plan(SqlIndexFromSearchFilterTest.planRow(0, IndexScanMapPhysicalRel.class)));
        IndexScanMapPhysicalRel rel = (IndexScanMapPhysicalRel)optimizePhysical.getPhysical();
        Assert.assertEquals((Object)F_1_INDEX, (Object)rel.getIndex().getName());
    }

    @Test
    public void when_selectWithRangeAndOrderBy_then_properPlanAndIndex() {
        String sql = "SELECT * FROM  \n" + this.mapName + " WHERE field1 >= 100\n AND field1 <= 10000 \n ORDER BY field2 ASC LIMIT 20 OFFSET 0";
        OptimizerTestSupport.Result optimizePhysical = this.optimizePhysical(sql, this.parameterTypes(), this.table());
        SqlIndexFromSearchFilterTest.assertPlan((RelNode)optimizePhysical.getLogical(), SqlIndexFromSearchFilterTest.plan(SqlIndexFromSearchFilterTest.planRow(0, SortLogicalRel.class), SqlIndexFromSearchFilterTest.planRow(1, FullScanLogicalRel.class)));
        SqlIndexFromSearchFilterTest.assertPlan((RelNode)optimizePhysical.getPhysical(), SqlIndexFromSearchFilterTest.plan(SqlIndexFromSearchFilterTest.planRow(0, LimitPhysicalRel.class), SqlIndexFromSearchFilterTest.planRow(1, IndexScanMapPhysicalRel.class)));
        IndexScanMapPhysicalRel rel = (IndexScanMapPhysicalRel)optimizePhysical.getPhysical().getInput(0);
        Assert.assertEquals((Object)F_2_INDEX, (Object)rel.getIndex().getName());
    }

    @Test
    public void when_selectWithMultipleEquals_then_properPlan() {
        String sql = "SELECT * FROM  \n" + this.mapName + " WHERE field1 = -1\n OR field1 = 1 \n OR field1 = 3 \n";
        OptimizerTestSupport.Result optimizePhysical = this.optimizePhysical(sql, this.parameterTypes(), this.table());
        SqlIndexFromSearchFilterTest.assertPlan((RelNode)optimizePhysical.getLogical(), SqlIndexFromSearchFilterTest.plan(SqlIndexFromSearchFilterTest.planRow(0, FullScanLogicalRel.class)));
        SqlIndexFromSearchFilterTest.assertPlan((RelNode)optimizePhysical.getPhysical(), SqlIndexFromSearchFilterTest.plan(SqlIndexFromSearchFilterTest.planRow(0, IndexScanMapPhysicalRel.class)));
    }

    private List<QueryDataType> parameterTypes() {
        return Arrays.asList(QueryDataType.INT, QueryDataType.OBJECT, QueryDataType.INT);
    }

    private HazelcastTable table() {
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("field1", ExpressionTypes.INTEGER.getFieldConverterType(), false, new QueryPath("field1", false)), new MapTableField("field2", ExpressionTypes.INTEGER.getFieldConverterType(), false, new QueryPath("field2", false)));
        HazelcastTable table = SqlIndexFromSearchFilterTest.partitionedTable(this.mapName, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)SqlIndexFromSearchFilterTest.mapContainer(SqlIndexFromSearchFilterTest.instance().getMap(this.mapName)), mapTableFields), 1000L);
        return table;
    }
}

