/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map.index;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.MapConfig;
import com.hazelcast.jet.sql.impl.connector.map.index.SqlIndexTestSupport;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.CalcPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SortPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionPredicates;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.shaded.com.google.common.base.Predicates;
import com.hazelcast.shaded.com.google.common.collect.HashMultiset;
import com.hazelcast.shaded.com.google.common.collect.Multiset;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.JUnitSoftAssertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class SqlIndexAbstractTest
extends SqlIndexTestSupport {
    protected static final int DEFAULT_MEMBERS_COUNT = 2;
    private static final AtomicInteger MAP_NAME_GEN = new AtomicInteger();
    private static final String INDEX_NAME = "index";
    @Parameterized.Parameter
    public IndexType indexType;
    @Parameterized.Parameter(value=1)
    public boolean composite;
    @Parameterized.Parameter(value=2)
    public ExpressionType<?> f1;
    @Parameterized.Parameter(value=3)
    public ExpressionType<?> f2;
    @Rule
    public final JUnitSoftAssertions softly = new JUnitSoftAssertions();
    protected final String mapName = "map" + MAP_NAME_GEN.incrementAndGet();
    private IMap<Integer, ExpressionBiValue> map;
    private Map<Integer, ExpressionBiValue> localMap;
    private Class<? extends ExpressionBiValue> valueClass;
    private int runIdGen;

    @BeforeClass
    public static void beforeClass() {
        Config config = SqlIndexAbstractTest.smallInstanceConfig();
        MapConfig mapConfig = new MapConfig();
        mapConfig.setName("map*").setBackupCount(0);
        config.addMapConfig(mapConfig);
        SqlIndexAbstractTest.initialize((int)2, (Config)config);
    }

    @Before
    public void before() {
        this.valueClass = ExpressionBiValue.createBiClass(this.f1, this.f2);
        SqlIndexAbstractTest.createMapping(this.mapName, Integer.TYPE, this.valueClass);
        this.map = SqlIndexAbstractTest.instance().getMap(this.mapName);
        this.map.addIndex(this.getIndexConfig());
        this.fill();
    }

    @After
    public void after() {
        if (this.map != null) {
            this.map.clear();
            this.map.destroy();
            this.map = null;
        }
    }

    @Test
    public void test() {
        this.checkFirstColumn();
        this.checkSecondColumn();
        this.checkBothColumns();
    }

    @Test
    public void testDisjunctionSameValue() {
        this.check(this.query("(field1=? or field1=?)", this.f1.valueFrom(), this.f1.valueFrom()), this.c_notHashComposite(), ExpressionPredicates.eq(this.f1.valueFrom()));
        this.check(this.query("((field1=? and field2=?) or (field1=? and field2=?))", this.f1.valueFrom(), this.f2.valueFrom(), this.f1.valueFrom(), this.f2.valueFrom()), false, ExpressionPredicates.and(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq_2(this.f2.valueFrom())));
    }

    @Test
    public void testDisjunctionOverlappingRange() {
        this.check(this.query("field1=? or (field1>=? and field1<=?)", this.f1.valueFrom(), this.f1.valueFrom(), this.f1.valueTo()), false, ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lte(this.f1.valueTo())));
        this.check(this.query("field1>=? or field1<=?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.isNotNull());
    }

    @Test
    public void testConjunctionOfRanges() {
        this.check(this.query("field1>? and field1>?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.gt(this.f1.valueTo()));
        this.check(this.query("field1>=? and field1>=?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.gte(this.f1.valueTo()));
        this.check(this.query("field1<? and field1<?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.lt(this.f1.valueFrom()));
        this.check(this.query("field1<=? and field1<=?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.lte(this.f1.valueFrom()));
    }

    @Test
    public void testOrderBy() {
        this.check0(this.query("1=1 order by field1", new Object[0]), this.c_sorted(), v -> true);
        this.check0(this.query("1=1 order by field1 desc", new Object[0]), this.c_sorted(), v -> true);
        this.check0(this.query("1=1 order by field1, field2", new Object[0]), this.c_sorted() && this.c_composite(), v -> true);
        this.check0(this.query("1=1 order by field1 desc, field2 desc", new Object[0]), this.c_sorted() && this.c_composite(), v -> true);
        this.check0(this.query("1=1 order by field1 asc, field2 desc", new Object[0]), false, v -> true);
        this.check0(this.query("1=1 order by field1 desc, field2 asc", new Object[0]), false, v -> true);
        this.check0(this.query("1=1 order by field2", new Object[0]), false, v -> true);
        this.check0(this.query("1=1 order by field2 desc", new Object[0]), false, v -> true);
    }

    private void checkFirstColumn() {
        this.check(this.query("field1 IS NULL", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.isNull());
        this.check(this.query("field1 IS NOT NULL", new Object[0]), this.c_sorted(), false, ExpressionPredicates.isNotNull());
        this.check(this.query("field1=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()), new Object[0]), this.c_notHashComposite(), ExpressionPredicates.eq(this.f1.valueFrom()));
        this.check(this.query(SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + "=field1", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.eq(this.f1.valueFrom()));
        this.check(this.query("field1=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " or field1=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()), new Object[0]), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueTo())));
        this.check(this.query(SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + "=field1 or " + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()) + "=field1", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueTo())));
        this.check(this.query("field1=?", this.f1.valueFrom()), this.c_notHashComposite(), ExpressionPredicates.eq(this.f1.valueFrom()));
        this.check(this.query("?=field1", this.f1.valueFrom()), this.c_notHashComposite(), ExpressionPredicates.eq(this.f1.valueFrom()));
        this.check(this.query("field1=? or field1=?", this.f1.valueFrom(), this.f1.valueTo()), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueTo())));
        this.check(this.query("?=field1 or ?=field1", this.f1.valueFrom(), this.f1.valueTo()), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueTo())));
        this.check(this.query("field1=? and field1=?", this.f1.valueTo(), this.f1.valueFrom()), this.c_notHashComposite(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("?=field1 and ?=field1", this.f1.valueFrom(), this.f1.valueTo()), this.c_notHashComposite(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1=? or field1 is null", this.f1.valueFrom()), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.isNull()));
        this.check(this.query("field1 is null or field1=?", this.f1.valueFrom()), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.isNull()));
        this.check(this.query("field1=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " or field1 is null", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.isNull()));
        this.check(this.query("field1 is null or field1=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()), new Object[0]), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.isNull()));
        this.check(this.query("field1!=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()), new Object[0]), this.c_booleanComponent() && this.c_notHashComposite(), ExpressionPredicates.neq(this.f1.valueFrom()));
        this.check(this.query(SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + "!=field1", new Object[0]), this.c_booleanComponent() && this.c_notHashComposite(), ExpressionPredicates.neq(this.f1.valueFrom()));
        this.check(this.query("field1!=?", this.f1.valueFrom()), false, ExpressionPredicates.neq(this.f1.valueFrom()));
        this.check(this.query("?!=field1", this.f1.valueFrom()), false, ExpressionPredicates.neq(this.f1.valueFrom()));
        this.check(this.query("field1>" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()), new Object[0]), this.c_sorted() || this.c_booleanComponent() && this.c_notHashComposite(), ExpressionPredicates.gt(this.f1.valueFrom()));
        this.check(this.query(SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + "<field1", new Object[0]), this.c_sorted() || this.c_booleanComponent() && this.c_notHashComposite(), ExpressionPredicates.gt(this.f1.valueFrom()));
        this.check(this.query("field1>?", this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.gt(this.f1.valueFrom()));
        this.check(this.query("?<field1", this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.gt(this.f1.valueFrom()));
        this.check(this.query("field1>?", null), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("?<field1", null), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1>=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()), new Object[0]), this.c_sorted(), ExpressionPredicates.gte(this.f1.valueFrom()));
        this.check(this.query(SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + "<=field1", new Object[0]), this.c_sorted(), ExpressionPredicates.gte(this.f1.valueFrom()));
        this.check(this.query("field1>=?", this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.gte(this.f1.valueFrom()));
        this.check(this.query("?<=field1", this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.gte(this.f1.valueFrom()));
        this.check(this.query("field1>=?", null), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("?<=field1", null), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1<" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()), new Object[0]), this.c_sorted(), ExpressionPredicates.lt(this.f1.valueFrom()));
        this.check(this.query(SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + ">field1", new Object[0]), this.c_sorted(), ExpressionPredicates.lt(this.f1.valueFrom()));
        this.check(this.query("field1<?", this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.lt(this.f1.valueFrom()));
        this.check(this.query("?>field1", this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.lt(this.f1.valueFrom()));
        this.check(this.query("field1<?", null), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("?<field1", null), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1<=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()), new Object[0]), this.c_sorted() || this.c_booleanComponent() && this.c_notHashComposite(), ExpressionPredicates.lte(this.f1.valueFrom()));
        this.check(this.query(SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + ">=field1", new Object[0]), this.c_sorted() || this.c_booleanComponent() && this.c_notHashComposite(), ExpressionPredicates.lte(this.f1.valueFrom()));
        this.check(this.query("field1<=?", this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.lte(this.f1.valueFrom()));
        this.check(this.query("?>=field1", this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.lte(this.f1.valueFrom()));
        this.check(this.query("field1<=?", null), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("?>=field1", null), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        if (!(this.f1 instanceof ExpressionType.BooleanType)) {
            this.check(this.query("field1>" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " AND field1<" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()), new Object[0]), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueTo())));
            this.check(this.query("field1>" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " AND field1<=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()), new Object[0]), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueFrom()), ExpressionPredicates.lte(this.f1.valueTo())));
            this.check(this.query("field1>=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " AND field1<" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()), new Object[0]), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueTo())));
        }
        this.check(this.query("field1>=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " AND field1<=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()), new Object[0]), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lte(this.f1.valueTo())));
        this.check(this.query("field1>? AND field1<?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueTo())));
        this.check(this.query("field1>? AND field1<?", this.f1.valueTo(), this.f1.valueFrom()), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1>? AND field1<?", this.f1.valueFrom(), this.f1.valueFrom()), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1>? AND field1<=?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueFrom()), ExpressionPredicates.lte(this.f1.valueTo())));
        this.check(this.query("field1>? AND field1<=?", this.f1.valueTo(), this.f1.valueFrom()), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1>? AND field1<=?", this.f1.valueFrom(), this.f1.valueFrom()), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1>=? AND field1<?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueTo())));
        this.check(this.query("field1>=? AND field1<?", this.f1.valueTo(), this.f1.valueFrom()), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1>=? AND field1<?", this.f1.valueFrom(), this.f1.valueFrom()), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1>=? AND field1<=?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lte(this.f1.valueTo())));
        this.check(this.query("field1>=? AND field1<=?", this.f1.valueTo(), this.f1.valueFrom()), this.c_sorted(), (Predicate<ExpressionValue>)Predicates.alwaysFalse());
        this.check(this.query("field1>=? AND field1<=?", this.f1.valueFrom(), this.f1.valueFrom()), this.c_sorted(), ExpressionPredicates.eq(this.f1.valueFrom()));
        this.check(this.query("field1<" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " OR field1>" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()), new Object[0]), this.c_sorted(), ExpressionPredicates.or(ExpressionPredicates.lt(this.f1.valueFrom()), ExpressionPredicates.gt(this.f1.valueTo())));
        this.check(this.query("field1<? OR field1>?", this.f1.valueFrom(), this.f1.valueTo()), this.c_sorted(), ExpressionPredicates.or(ExpressionPredicates.lt(this.f1.valueFrom()), ExpressionPredicates.gt(this.f1.valueTo())));
        if (!(this.f1 instanceof ExpressionType.BooleanType)) {
            this.check(this.query("(field1>=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " AND field1<=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueMiddle()) + ") OR field1=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()), new Object[0]), this.c_sorted(), ExpressionPredicates.or(ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lte(this.f1.valueMiddle())), ExpressionPredicates.eq(this.f1.valueTo())));
            this.check(this.query("(field1>=? AND field1<=?) OR field1=?", this.f1.valueFrom(), this.f1.valueMiddle(), this.f1.valueTo()), false, ExpressionPredicates.or(ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lte(this.f1.valueMiddle())), ExpressionPredicates.eq(this.f1.valueTo())));
            this.check(this.query("(field1>=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " AND field1<" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueMiddle()) + ") OR (field1>" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueMiddle()) + " AND field1<=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()) + ")", new Object[0]), this.c_sorted(), ExpressionPredicates.or(ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueMiddle())), ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueMiddle()), ExpressionPredicates.lte(this.f1.valueTo()))));
            this.check(this.query("(field1>=? AND field1<?) OR (field1>? AND field1<=?)", this.f1.valueFrom(), this.f1.valueMiddle(), this.f1.valueMiddle(), this.f1.valueTo()), false, ExpressionPredicates.or(ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueMiddle())), ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueMiddle()), ExpressionPredicates.lte(this.f1.valueTo()))));
            this.check(this.query("(field1>" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueMiddle()) + " AND field1<=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueTo()) + ") OR (field1>=" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueFrom()) + " AND field1<" + SqlIndexAbstractTest.toLiteral(this.f1, this.f1.valueMiddle()) + ")", new Object[0]), this.c_sorted(), ExpressionPredicates.or(ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueMiddle())), ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueMiddle()), ExpressionPredicates.lte(this.f1.valueTo()))));
            this.check(this.query("(field1>? AND field1<=?) OR (field1>=? AND field1<?)", this.f1.valueMiddle(), this.f1.valueTo(), this.f1.valueFrom(), this.f1.valueMiddle()), false, ExpressionPredicates.or(ExpressionPredicates.and(ExpressionPredicates.gte(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueMiddle())), ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueMiddle()), ExpressionPredicates.lte(this.f1.valueTo()))));
        }
        this.check(this.query("field1=? OR field1=?", this.f1.valueFrom(), this.f1.valueTo()), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueTo())));
        if (this.f1 instanceof ExpressionType.BooleanType) {
            this.check(this.query("field1", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.eq(true));
            this.check(this.query("field1 IS TRUE", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.eq(true));
            this.check(this.query("field1 IS FALSE", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.eq(false));
            this.check(this.query("field1 IS NOT TRUE", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(false), ExpressionPredicates.isNull()));
            this.check(this.query("field1 IS NOT FALSE", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.or(ExpressionPredicates.eq(true), ExpressionPredicates.isNull()));
        }
    }

    private void checkSecondColumn() {
        this.check(this.query("field2 IS NULL", new Object[0]), false, ExpressionPredicates.isNull_2());
        this.check(this.query("field2 IS NOT NULL", new Object[0]), false, ExpressionPredicates.isNotNull_2());
        this.check(this.query("field2=?", this.f2.valueFrom()), false, ExpressionPredicates.eq_2(this.f2.valueFrom()));
        this.check(this.query("field2!=?", this.f2.valueFrom()), false, ExpressionPredicates.neq_2(this.f2.valueFrom()));
        this.check(this.query("field2>?", this.f2.valueFrom()), false, ExpressionPredicates.gt_2(this.f2.valueFrom()));
        this.check(this.query("field2>=?", this.f2.valueFrom()), false, ExpressionPredicates.gte_2(this.f2.valueFrom()));
        this.check(this.query("field2<?", this.f2.valueFrom()), false, ExpressionPredicates.lt_2(this.f2.valueFrom()));
        this.check(this.query("field2<=?", this.f2.valueFrom()), false, ExpressionPredicates.lte_2(this.f2.valueFrom()));
        this.check(this.query("field2>? AND field2<?", this.f2.valueFrom(), this.f2.valueTo()), false, ExpressionPredicates.and(ExpressionPredicates.gt_2(this.f2.valueFrom()), ExpressionPredicates.lt_2(this.f2.valueTo())));
        this.check(this.query("field2>? AND field2<=?", this.f2.valueFrom(), this.f2.valueTo()), false, ExpressionPredicates.and(ExpressionPredicates.gt_2(this.f2.valueFrom()), ExpressionPredicates.lte_2(this.f2.valueTo())));
        this.check(this.query("field2>=? AND field2<?", this.f2.valueFrom(), this.f2.valueTo()), false, ExpressionPredicates.and(ExpressionPredicates.gte_2(this.f2.valueFrom()), ExpressionPredicates.lt_2(this.f2.valueTo())));
        this.check(this.query("field2>=? AND field2<=?", this.f2.valueFrom(), this.f2.valueTo()), false, ExpressionPredicates.and(ExpressionPredicates.gte_2(this.f2.valueFrom()), ExpressionPredicates.lte_2(this.f2.valueTo())));
        if (this.f2 instanceof ExpressionType.BooleanType) {
            this.check(this.query("field2", new Object[0]), false, ExpressionPredicates.eq_2(true));
            this.check(this.query("field2 IS TRUE", new Object[0]), false, ExpressionPredicates.eq_2(true));
            this.check(this.query("field2 IS FALSE", new Object[0]), false, ExpressionPredicates.eq_2(false));
            this.check(this.query("field2 IS NOT TRUE", new Object[0]), false, ExpressionPredicates.or(ExpressionPredicates.eq_2(false), ExpressionPredicates.isNull_2()));
            this.check(this.query("field2 IS NOT FALSE", new Object[0]), false, ExpressionPredicates.or(ExpressionPredicates.eq_2(true), ExpressionPredicates.isNull_2()));
        }
    }

    private void checkBothColumns() {
        this.check(this.query("field1=? AND field2=?", this.f1.valueFrom(), this.f2.valueFrom()), this.c_always(), ExpressionPredicates.and(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq_2(this.f2.valueFrom())));
        this.check(this.query("field1=? AND (field2=? OR field2=?)", this.f1.valueFrom(), this.f2.valueFrom(), this.f2.valueTo()), this.c_always(), ExpressionPredicates.and(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.or(ExpressionPredicates.eq_2(this.f2.valueFrom()), ExpressionPredicates.eq_2(this.f2.valueTo()))));
        this.check(this.query("field1=? AND field2>? AND field2<?", this.f1.valueFrom(), this.f2.valueFrom(), this.f2.valueTo()), this.c_sorted() || this.c_notComposite(), ExpressionPredicates.and(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.and(ExpressionPredicates.gt_2(this.f2.valueFrom()), ExpressionPredicates.lt_2(this.f2.valueTo()))));
        this.check(this.query("(field1=? OR field1=?) AND field2=?", this.f1.valueFrom(), this.f1.valueTo(), this.f2.valueFrom()), this.c_sorted() || this.c_notComposite(), ExpressionPredicates.and(ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueTo())), ExpressionPredicates.eq_2(this.f2.valueFrom())));
        this.check(this.query("(field1=? OR field1=?) AND (field2=? OR field2=?)", this.f1.valueFrom(), this.f1.valueTo(), this.f2.valueFrom(), this.f2.valueTo()), this.c_sorted() || this.c_notComposite(), ExpressionPredicates.and(ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueTo())), ExpressionPredicates.or(ExpressionPredicates.eq_2(this.f2.valueFrom()), ExpressionPredicates.eq_2(this.f2.valueTo()))));
        this.check(this.query("(field1=? OR field1=?) AND (field2>? AND field2<?)", this.f1.valueFrom(), this.f1.valueTo(), this.f2.valueFrom(), this.f2.valueTo()), this.c_sorted() || this.c_notComposite(), ExpressionPredicates.and(ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueTo())), ExpressionPredicates.and(ExpressionPredicates.gt_2(this.f2.valueFrom()), ExpressionPredicates.lt_2(this.f2.valueTo()))));
        this.check(this.query("(field1=? OR field1=?) AND (field2>? AND field2<?)", this.f1.valueFrom(), this.f1.valueFrom(), this.f2.valueFrom(), this.f2.valueTo()), this.c_sorted() || this.c_notComposite(), ExpressionPredicates.and(ExpressionPredicates.or(ExpressionPredicates.eq(this.f1.valueFrom()), ExpressionPredicates.eq(this.f1.valueFrom())), ExpressionPredicates.and(ExpressionPredicates.gt_2(this.f2.valueFrom()), ExpressionPredicates.lt_2(this.f2.valueTo()))));
        this.check(this.query("(field1>? AND field1<?) AND field2=?", this.f1.valueFrom(), this.f1.valueTo(), this.f2.valueFrom()), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueTo())), ExpressionPredicates.eq_2(this.f2.valueFrom())));
        this.check(this.query("(field1>? AND field1<?) AND (field2=? AND field2=?)", this.f1.valueFrom(), this.f1.valueTo(), this.f2.valueFrom(), this.f2.valueTo()), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueTo())), ExpressionPredicates.and(ExpressionPredicates.eq_2(this.f2.valueFrom()), ExpressionPredicates.eq_2(this.f2.valueTo()))));
        this.check(this.query("(field1>? AND field1<?) AND (field2>? AND field2<?)", this.f1.valueFrom(), this.f1.valueTo(), this.f2.valueFrom(), this.f2.valueTo()), this.c_sorted(), ExpressionPredicates.and(ExpressionPredicates.and(ExpressionPredicates.gt(this.f1.valueFrom()), ExpressionPredicates.lt(this.f1.valueTo())), ExpressionPredicates.and(ExpressionPredicates.gt_2(this.f2.valueFrom()), ExpressionPredicates.lt_2(this.f2.valueTo()))));
        this.check(this.query("field1 IS NULL AND field2 IS NULL", new Object[0]), true, ExpressionPredicates.and(ExpressionPredicates.isNull(), ExpressionPredicates.isNull_2()));
        this.check(this.query("field1 IS NULL AND field2 IS NOT NULL", new Object[0]), this.c_notHashComposite(), ExpressionPredicates.and(ExpressionPredicates.isNull(), ExpressionPredicates.isNotNull_2()));
        this.check(this.query("field1 IS NOT NULL AND field2 IS NULL", new Object[0]), false, ExpressionPredicates.and(ExpressionPredicates.isNotNull(), ExpressionPredicates.isNull_2()));
        this.check(this.query("field1 IS NOT NULL AND field2 IS NOT NULL", new Object[0]), false, ExpressionPredicates.and(ExpressionPredicates.isNotNull(), ExpressionPredicates.isNotNull_2()));
    }

    private boolean c_always() {
        return true;
    }

    private boolean c_never() {
        return false;
    }

    private boolean c_sorted() {
        return this.indexType == IndexType.SORTED;
    }

    private boolean c_hash() {
        return this.indexType == IndexType.HASH;
    }

    private boolean c_composite() {
        return this.composite;
    }

    private boolean c_notComposite() {
        return !this.composite;
    }

    private boolean c_notHashComposite() {
        return this.c_sorted() || this.c_notComposite();
    }

    private boolean c_booleanComponent() {
        return this.f1 instanceof ExpressionType.BooleanType;
    }

    private boolean c_booleanComponentAndNotHashComposite() {
        return this.c_booleanComponent() && this.c_notHashComposite();
    }

    private void check(Query query, boolean expectedUseIndex, Predicate<ExpressionValue> expectedKeysPredicate) {
        this.check(query, expectedUseIndex, expectedUseIndex, expectedKeysPredicate);
    }

    private void check(Query query, boolean expectedUseIndex, boolean expectedUseIndexWithAndCondition, Predicate<ExpressionValue> expectedKeysPredicate) {
        String condition = "__key / 2 = 0";
        Query queryWithAnd = SqlIndexAbstractTest.addConditionToQuery(query, condition, true);
        Query queryWithOr = SqlIndexAbstractTest.addConditionToQuery(query, condition, false);
        Query queryWithOrderBy = new Query(query.sql + " ORDER BY field1", query.parameters);
        Query queryWithOrderByDesc = new Query(query.sql + " ORDER BY field1 DESC", query.parameters);
        Predicate<ExpressionValue> predicate = value -> value.key / 2 == 0;
        Predicate<ExpressionValue> expectedKeysPredicateWithAnd = ExpressionPredicates.and(expectedKeysPredicate, predicate);
        Predicate<ExpressionValue> expectedKeysPredicateWithOr = ExpressionPredicates.or(expectedKeysPredicate, predicate);
        this.check0(query, expectedUseIndex, expectedKeysPredicate);
        this.check0(queryWithAnd, expectedUseIndexWithAndCondition, expectedKeysPredicateWithAnd);
        this.check0(queryWithOr, false, expectedKeysPredicateWithOr);
        this.check0(queryWithOrderBy, expectedUseIndex || this.c_sorted(), expectedKeysPredicate);
        this.check0(queryWithOrderByDesc, expectedUseIndex || this.c_sorted(), expectedKeysPredicate);
    }

    private void check0(Query query, boolean expectedUseIndex, Predicate<ExpressionValue> expectedKeysPredicate) {
        this.check0(query.sql, query.parameters, expectedUseIndex, expectedKeysPredicate);
    }

    private void check0(String sql, List<Object> params, boolean expectedUseIndex, Predicate<ExpressionValue> expectedKeysPredicate) {
        ((AbstractThrowableAssert)this.softly.assertThatCode(() -> {
            int runId = this.runIdGen++;
            this.checkPlan(expectedUseIndex, sql);
            Multiset<Integer> sqlKeys = this.sqlKeys(expectedUseIndex, sql, params);
            Set<Integer> expectedMapKeys = this.expectedMapKeys(expectedKeysPredicate);
            if (!sqlKeys.equals((Object)HashMultiset.create(expectedMapKeys))) {
                this.failOnDifference(runId, sql, params, sqlKeys, expectedMapKeys, "actual SQL keys differ from expected map keys", "actual SQL keys", "expected map keys");
            }
        }).as("Test failed for query %s", new Object[]{sql})).doesNotThrowAnyException();
    }

    private void failOnDifference(int runId, String sql, List<Object> params, Multiset<Integer> first, Set<Integer> second, String mainMessage, String firstCaption, String secondCaption) {
        TreeSet<Integer> firstOnly = new TreeSet<Integer>((Collection<Integer>)first);
        TreeSet<Integer> secondOnly = new TreeSet<Integer>(second);
        firstOnly.removeAll(second);
        secondOnly.removeAll((Collection<?>)first);
        List duplicates = first.entrySet().stream().filter(e -> e.getCount() > 1).map(Multiset.Entry::getElement).collect(Collectors.toList());
        Assert.assertTrue((!firstOnly.isEmpty() || !secondOnly.isEmpty() || !duplicates.isEmpty() ? 1 : 0) != 0);
        StringBuilder message = new StringBuilder();
        message.append("\nRun " + runId + " failed: " + mainMessage + "\n\n");
        message.append("SQL: " + sql + "\n");
        message.append("Parameters: " + String.valueOf(params) + "\n\n");
        if (!firstOnly.isEmpty()) {
            message.append("\t" + firstCaption + ":\n");
            for (Integer key : firstOnly) {
                message.append("\t\t" + key + " -> " + String.valueOf(this.map.get((Object)key)) + "\n");
            }
        }
        if (!secondOnly.isEmpty()) {
            message.append("\t" + secondCaption + ":\n");
            for (Integer key : secondOnly) {
                message.append("\t\t" + key + " -> " + String.valueOf(this.map.get((Object)key)) + "\n");
            }
        }
        if (!duplicates.isEmpty()) {
            message.append("\tduplicated " + firstCaption + ":\n");
            for (Integer key : duplicates) {
                message.append("\t\t" + key + " -> " + String.valueOf(this.map.get((Object)key)) + " occurred " + first.count((Object)key) + " times\n");
            }
        }
        Assert.fail((String)message.toString());
    }

    private void checkPlan(boolean withIndex, String sql) {
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, this.f1.getFieldConverterType(), this.f2.getFieldConverterType());
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("field1", this.f1.getFieldConverterType(), false, new QueryPath("field1", false)), new MapTableField("field2", this.f2.getFieldConverterType(), false, new QueryPath("field2", false)));
        HazelcastTable table = SqlIndexAbstractTest.partitionedTable(this.mapName, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)SqlIndexAbstractTest.mapContainer(this.map), mapTableFields), this.map.size());
        OptimizerTestSupport.Result optimizationResult = this.optimizePhysical(sql, parameterTypes, table);
        if (sql.toLowerCase(Locale.ROOT).contains("order by")) {
            if (withIndex) {
                if (this.c_sorted()) {
                    SqlIndexAbstractTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlIndexAbstractTest.plan(SqlIndexAbstractTest.planRow(0, CalcPhysicalRel.class), SqlIndexAbstractTest.planRow(1, IndexScanMapPhysicalRel.class)));
                } else {
                    SqlIndexAbstractTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlIndexAbstractTest.plan(SqlIndexAbstractTest.planRow(0, CalcPhysicalRel.class), SqlIndexAbstractTest.planRow(1, SortPhysicalRel.class), SqlIndexAbstractTest.planRow(2, IndexScanMapPhysicalRel.class)));
                }
            } else {
                SqlIndexAbstractTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlIndexAbstractTest.plan(SqlIndexAbstractTest.planRow(0, CalcPhysicalRel.class), SqlIndexAbstractTest.planRow(1, SortPhysicalRel.class), SqlIndexAbstractTest.planRow(2, FullScanPhysicalRel.class)));
            }
        } else {
            SqlIndexAbstractTest.assertPlan((RelNode)optimizationResult.getLogical(), SqlIndexAbstractTest.plan(SqlIndexAbstractTest.planRow(0, FullScanLogicalRel.class)));
            SqlIndexAbstractTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlIndexAbstractTest.plan(SqlIndexAbstractTest.planRow(0, withIndex ? IndexScanMapPhysicalRel.class : FullScanPhysicalRel.class)));
        }
    }

    protected MapConfig getMapConfig() {
        return new MapConfig().setName(this.mapName).setBackupCount(0).addIndexConfig(this.getIndexConfig());
    }

    protected static Collection<Object[]> parametersQuick() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        for (IndexType indexType : Arrays.asList(IndexType.SORTED, IndexType.HASH)) {
            res.add(new Object[]{indexType, false, ExpressionTypes.INTEGER, ExpressionTypes.INTEGER});
            res.add(new Object[]{indexType, false, ExpressionTypes.STRING, ExpressionTypes.INTEGER});
        }
        return res;
    }

    protected static Collection<Object[]> parametersSlow() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        for (IndexType indexType : Arrays.asList(IndexType.SORTED, IndexType.HASH)) {
            for (boolean composite : Arrays.asList(true, false)) {
                for (ExpressionType<?> firstType : SqlIndexAbstractTest.slowTestTypes()) {
                    for (ExpressionType<?> secondType : SqlIndexAbstractTest.slowTestTypes()) {
                        res.add(new Object[]{indexType, composite, firstType, secondType});
                    }
                }
            }
        }
        return res;
    }

    private void fill() {
        for (int i = 0; i < SqlIndexAbstractTest.instances().length; ++i) {
            int key = SqlIndexAbstractTest.getLocalKeys(SqlIndexAbstractTest.instances()[i], 1, value -> value).get(0);
            Object value2 = ExpressionBiValue.createBiValue(this.valueClass, key, this.f1.valueFrom(), this.f2.valueFrom());
            this.map.put((Object)key, value2);
            this.map.remove((Object)key);
        }
        int keyCounter = 0;
        this.localMap = new HashMap<Integer, ExpressionBiValue>();
        for (Object firstField : this.f1.values()) {
            for (Object secondField : this.f2.values()) {
                for (int i = 0; i < 4; ++i) {
                    int key = keyCounter++;
                    Object value3 = ExpressionBiValue.createBiValue(this.valueClass, key, firstField, secondField);
                    this.localMap.put(key, (ExpressionBiValue)value3);
                }
            }
        }
        this.map.putAll(this.localMap);
    }

    private String sql(String condition) {
        return "SELECT __key FROM " + this.mapName + " WHERE " + condition;
    }

    private Multiset<Integer> sqlKeys(boolean withIndex, String sql, List<Object> params) {
        SqlStatement query = new SqlStatement(sql);
        query.setTimeoutMillis(60000L);
        query.setParameters(params);
        HashMultiset keys = HashMultiset.create();
        try (SqlResult result = SqlIndexAbstractTest.instance().getSql().execute(query);){
            for (SqlRow row : result) {
                keys.add((Object)((Integer)row.getObject(0)));
            }
        }
        return keys;
    }

    private Set<Integer> expectedMapKeys(Predicate<ExpressionValue> predicate) {
        HashSet<Integer> keys = new HashSet<Integer>();
        for (Map.Entry<Integer, ExpressionBiValue> entry : this.localMap.entrySet()) {
            Integer key = entry.getKey();
            ExpressionBiValue value = entry.getValue();
            if (!predicate.test(value)) continue;
            keys.add(key);
        }
        return keys;
    }

    protected IndexConfig getIndexConfig() {
        IndexConfig config = new IndexConfig().setName(INDEX_NAME).setType(this.indexType);
        config.addAttribute("field1");
        if (this.composite) {
            config.addAttribute("field2");
        }
        return config;
    }

    private static Query addConditionToQuery(Query query, String condition, boolean conjunction) {
        Object sql = query.sql;
        if (((String)sql).contains("WHERE")) {
            int openPosition = ((String)sql).indexOf("WHERE") + 6;
            sql = ((String)sql).substring(0, openPosition) + "(" + ((String)sql).substring(openPosition) + ")";
            sql = (String)sql + " " + (conjunction ? "AND" : "OR") + " " + condition;
        } else {
            sql = (String)sql + " WHERE " + condition;
        }
        return new Query((String)sql, query.parameters);
    }

    private Query query(String condition, Object ... parameters) {
        return new Query(this.sql(condition), parameters != null ? Arrays.asList(parameters) : Arrays.asList(new Object[]{null}));
    }

    private static class Query {
        private final String sql;
        private final List<Object> parameters;

        private Query(String sql, List<Object> parameters) {
            this.sql = sql;
            this.parameters = parameters;
        }
    }
}

