/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestAllTypesSqlConnector;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlService;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlPortableTest
extends SqlTestSupport {
    private static SqlService sqlService;
    private static final int PERSON_ID_FACTORY_ID = 1;
    private static final int PERSON_ID_CLASS_ID = 2;
    private static final int PERSON_ID_CLASS_VERSION = 3;
    private static final int PERSON_FACTORY_ID = 4;
    private static final int PERSON_CLASS_ID = 5;
    private static final int PERSON_CLASS_VERSION = 6;
    private static final int ALL_TYPES_FACTORY_ID = 7;
    private static final int ALL_TYPES_CLASS_ID = 8;
    private static final int ALL_TYPES_CLASS_VERSION = 9;
    private static final int EMPTY_TYPES_FACTORY_ID = 10;
    private static final int EMPTY_TYPES_CLASS_ID = 11;
    private static final int EMPTY_TYPES_CLASS_VERSION = 12;
    private static InternalSerializationService serializationService;
    private static ClassDefinition personIdClassDefinition;
    private static ClassDefinition personClassDefinition;
    private static ClassDefinition emptyClassDefinition;

    @BeforeClass
    public static void beforeClass() {
        SqlPortableTest.initialize((int)1, null);
        sqlService = SqlPortableTest.instance().getSql();
        serializationService = com.hazelcast.jet.impl.util.Util.getSerializationService((HazelcastInstance)SqlPortableTest.instance());
        personIdClassDefinition = new ClassDefinitionBuilder(1, 2, 3).addIntField("id").build();
        serializationService.getPortableContext().registerClassDefinition(personIdClassDefinition);
        personClassDefinition = new ClassDefinitionBuilder(4, 5, 6).addIntField("id").addStringField("name").build();
        serializationService.getPortableContext().registerClassDefinition(personClassDefinition);
        ClassDefinition evolvedPersonClassDefinition = new ClassDefinitionBuilder(4, 5, 7).addIntField("id").addStringField("name").addLongField("ssn").build();
        serializationService.getPortableContext().registerClassDefinition(evolvedPersonClassDefinition);
        ClassDefinition allTypesValueClassDefinition = new ClassDefinitionBuilder(7, 8, 9).addCharField("character").addStringField("string").addBooleanField("boolean").addByteField("byte").addShortField("short").addIntField("int").addLongField("long").addFloatField("float").addDoubleField("double").addDecimalField("decimal").addTimeField("time").addDateField("date").addTimestampField("timestamp").addTimestampWithTimezoneField("timestampTz").addPortableField("object", personClassDefinition).build();
        serializationService.getPortableContext().registerClassDefinition(allTypesValueClassDefinition);
        emptyClassDefinition = new ClassDefinitionBuilder(10, 11, 12).build();
        serializationService.getPortableContext().registerClassDefinition(emptyClassDefinition);
    }

    @Test
    public void test_nulls() throws IOException {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='6')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES (1, null)", new Object[0]);
        Map.Entry<Data, Data> entry = SqlPortableTest.randomEntryFrom(name);
        InternalGenericRecord keyRecord = serializationService.readAsInternalGenericRecord(entry.getKey());
        Assertions.assertThat((int)keyRecord.getInt32("id")).isEqualTo(1);
        InternalGenericRecord valueRecord = serializationService.readAsInternalGenericRecord(entry.getValue());
        Assertions.assertThat((int)valueRecord.getInt32("id")).isEqualTo(0);
        Assertions.assertThat((String)valueRecord.getString("name")).isNull();
        SqlPortableTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, null)));
    }

    @Test
    public void when_nullIntoPrimitive_then_fails() {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='6')", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + name + " VALUES (null, 'Alice')", new Object[0])).hasMessageContaining("Cannot set NULL to a primitive field");
    }

    @Test
    public void test_fieldsShadowing() throws IOException {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='6')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " (id, name) VALUES (1, 'Alice')", new Object[0]);
        Map.Entry<Data, Data> entry = SqlPortableTest.randomEntryFrom(name);
        InternalGenericRecord keyRecord = serializationService.readAsInternalGenericRecord(entry.getKey());
        Assertions.assertThat((int)keyRecord.getInt32("id")).isEqualTo(1);
        InternalGenericRecord valueRecord = serializationService.readAsInternalGenericRecord(entry.getValue());
        Assertions.assertThat((int)valueRecord.getInt32("id")).isEqualTo(0);
        Assertions.assertThat((String)valueRecord.getString("name")).isEqualTo("Alice");
        SqlPortableTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, "Alice")));
    }

    @Test
    public void test_fieldsMapping() throws IOException {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (key_id INT EXTERNAL NAME \"__key.id\", value_id INT EXTERNAL NAME \"this.id\") TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='6')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " (value_id, key_id) VALUES (2, 1)", new Object[0]);
        Map.Entry<Data, Data> entry = SqlPortableTest.randomEntryFrom(name);
        InternalGenericRecord keyRecord = serializationService.readAsInternalGenericRecord(entry.getKey());
        Assertions.assertThat((int)keyRecord.getInt32("id")).isEqualTo(1);
        InternalGenericRecord valueRecord = serializationService.readAsInternalGenericRecord(entry.getValue());
        Assertions.assertThat((int)valueRecord.getInt32("id")).isEqualTo(2);
        SqlPortableTest.assertRowsAnyOrder("SELECT key_id, value_id FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, 2)));
    }

    @Test
    public void test_schemaEvolution() {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='6')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES (1, 'Alice')", new Object[0]);
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='7')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES (2, 'Bob', 123456789)", new Object[0]);
        SqlPortableTest.assertRowsAnyOrder("SELECT * FROM " + name, Arrays.asList(new SqlTestSupport.Row(1, "Alice", null), new SqlTestSupport.Row(2, "Bob", 123456789L)));
    }

    @Test
    public void test_fieldsExtensions() {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + " TYPE IMap OPTIONS ( 'keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='7')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES (1, 'Alice', 123456789)", new Object[0]);
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + " (name VARCHAR, ssn BIGINT) TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='6')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES ('Bob', null)", new Object[0]);
        SqlPortableTest.assertRowsAnyOrder("SELECT * FROM " + name, Arrays.asList(new SqlTestSupport.Row("Alice", 123456789L), new SqlTestSupport.Row("Bob", null)));
    }

    @Test
    public void test_allTypes() throws IOException {
        String from = SqlPortableTest.randomName();
        TestAllTypesSqlConnector.create(sqlService, from);
        String to = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + to + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='7', 'valuePortableClassId'='8', 'valuePortableClassVersion'='9')", new Object[0]);
        sqlService.execute("SINK INTO " + to + " SELECT 13, 'a', string, \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"time\", \"date\", \"timestamp\", timestampTz, \"object\" FROM " + from + " f", new Object[0]);
        InternalGenericRecord valueRecord = serializationService.readAsInternalGenericRecord(SqlPortableTest.randomEntryFrom(to).getValue());
        Assertions.assertThat((String)valueRecord.getString("string")).isEqualTo("string");
        Assertions.assertThat((char)valueRecord.getChar("character")).isEqualTo('a');
        Assertions.assertThat((boolean)valueRecord.getBoolean("boolean")).isTrue();
        Assertions.assertThat((byte)valueRecord.getInt8("byte")).isEqualTo((byte)127);
        Assertions.assertThat((short)valueRecord.getInt16("short")).isEqualTo((short)Short.MAX_VALUE);
        Assertions.assertThat((int)valueRecord.getInt32("int")).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((long)valueRecord.getInt64("long")).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((float)valueRecord.getFloat32("float")).isEqualTo(1.234568E9f);
        Assertions.assertThat((double)valueRecord.getFloat64("double")).isEqualTo(1.234512345678901E14);
        Assertions.assertThat((BigDecimal)valueRecord.getDecimal("decimal")).isEqualTo((Object)new BigDecimal("9223372036854775.123"));
        Assertions.assertThat((LocalTime)valueRecord.getTime("time")).isEqualTo((Object)LocalTime.of(12, 23, 34));
        Assertions.assertThat((LocalDate)valueRecord.getDate("date")).isEqualTo((Object)LocalDate.of(2020, 4, 15));
        Assertions.assertThat((LocalDateTime)valueRecord.getTimestamp("timestamp")).isEqualTo((Object)LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000));
        Assertions.assertThat((OffsetDateTime)valueRecord.getTimestampWithTimezone("timestampTz")).isEqualTo((Object)OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC));
        Assertions.assertThat((Object)valueRecord.getGenericRecord("object")).isNull();
        SqlPortableTest.assertRowsAnyOrder("SELECT * FROM " + to, Collections.singletonList(new SqlTestSupport.Row(13, "a", "string", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), null)));
    }

    @Test
    public void test_writingToTopLevelWhileNestedFieldMapped_explicit() {
        this.test_writingToTopLevelWhileNestedFieldMapped(true);
    }

    @Test
    public void test_writingToTopLevelWhileNestedFieldMapped_implicit() {
        this.test_writingToTopLevelWhileNestedFieldMapped(false);
    }

    public void test_writingToTopLevelWhileNestedFieldMapped(boolean explicit) {
        String mapName = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + mapName + "(__key INT" + (explicit ? ", this OBJECT" : "") + ", name VARCHAR) TYPE IMap\nOPTIONS (\n'keyFormat'='java'\n, 'keyJavaClass'='" + Integer.class.getName() + "'\n, 'valueFormat'='portable'\n, 'valuePortableFactoryId'='4'\n, 'valuePortableClassId'='5'\n, 'valuePortableClassVersion'='6'\n)", new Object[0]);
        if (explicit) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + mapName + " VALUES(1, null, 'foo')", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Writing to top-level fields of type OBJECT not supported");
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + mapName + "(__key, this) VALUES(1, null)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Writing to top-level fields of type OBJECT not supported");
        sqlService.execute("SINK INTO " + mapName + (explicit ? "(__key, name)" : "") + " VALUES (1, 'foo')", new Object[0]);
        Iterator resultIter = sqlService.execute("SELECT __key, this, name FROM " + mapName, new Object[0]).iterator();
        SqlRow row = (SqlRow)resultIter.next();
        Assert.assertEquals((long)1L, (long)((Integer)row.getObject(0)).intValue());
        SqlPortableTest.assertInstanceOf(GenericRecord.class, (Object)row.getObject(1));
        Assert.assertEquals((Object)"foo", (Object)row.getObject(2));
        Assert.assertFalse((boolean)resultIter.hasNext());
    }

    @Test
    public void test_topLevelFieldExtraction() {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='4', 'valuePortableClassId'='5', 'valuePortableClassVersion'='6')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " (id, name) VALUES (1, 'Alice')", new Object[0]);
        Iterator rowIterator = sqlService.execute("SELECT __key, this FROM " + name, new Object[0]).iterator();
        SqlRow row = (SqlRow)rowIterator.next();
        Assert.assertFalse((boolean)rowIterator.hasNext());
        Assert.assertEquals((Object)new PortableGenericRecordBuilder(personIdClassDefinition).setInt32("id", 1).build(), (Object)row.getObject(0));
        Assert.assertEquals((Object)new PortableGenericRecordBuilder(personClassDefinition).setInt32("id", 0).setString("name", "Alice").build(), (Object)row.getObject(1));
    }

    @Test
    public void test_derivesClassDefinitionFromSchema() throws IOException {
        String from = SqlPortableTest.randomName();
        TestAllTypesSqlConnector.create(sqlService, from);
        String to = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + to + " (id INT EXTERNAL NAME \"__key.id\", string VARCHAR, \"boolean\" BOOLEAN, byte TINYINT, short SMALLINT, \"int\" INT, long BIGINT, \"float\" REAL, \"double\" DOUBLE, \"decimal\" DECIMAL, \"time\" TIME, \"date\" DATE, \"timestamp\" TIMESTAMP, timestampTz TIMESTAMP WITH TIME ZONE) TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1', 'keyPortableClassId'='2', 'keyPortableClassVersion'='3', 'valueFormat'='portable', 'valuePortableFactoryId'='997', 'valuePortableClassId'='998', 'valuePortableClassVersion'='999')", new Object[0]);
        sqlService.execute("SINK INTO " + to + " SELECT 13, string , \"boolean\" , byte , short , \"int\" , long , \"float\" , \"double\" , \"decimal\" , \"time\" , \"date\" , \"timestamp\" , timestampTz FROM " + from, new Object[0]);
        InternalGenericRecord valueRecord = serializationService.readAsInternalGenericRecord(SqlPortableTest.randomEntryFrom(to).getValue());
        Assertions.assertThat((String)valueRecord.getString("string")).isEqualTo("string");
        Assertions.assertThat((boolean)valueRecord.getBoolean("boolean")).isTrue();
        Assertions.assertThat((byte)valueRecord.getInt8("byte")).isEqualTo((byte)127);
        Assertions.assertThat((short)valueRecord.getInt16("short")).isEqualTo((short)Short.MAX_VALUE);
        Assertions.assertThat((int)valueRecord.getInt32("int")).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((long)valueRecord.getInt64("long")).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((float)valueRecord.getFloat32("float")).isEqualTo(1.234568E9f);
        Assertions.assertThat((double)valueRecord.getFloat64("double")).isEqualTo(1.234512345678901E14);
        Assertions.assertThat((BigDecimal)valueRecord.getDecimal("decimal")).isEqualTo((Object)new BigDecimal("9223372036854775.123"));
        Assertions.assertThat((LocalTime)valueRecord.getTime("time")).isEqualTo((Object)LocalTime.of(12, 23, 34));
        Assertions.assertThat((LocalDate)valueRecord.getDate("date")).isEqualTo((Object)LocalDate.of(2020, 4, 15));
        Assertions.assertThat((LocalDateTime)valueRecord.getTimestamp("timestamp")).isEqualTo((Object)LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000));
        Assertions.assertThat((OffsetDateTime)valueRecord.getTimestampWithTimezone("timestampTz")).isEqualTo((Object)OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC));
        SqlPortableTest.assertRowsAnyOrder("SELECT * FROM " + to, Collections.singletonList(new SqlTestSupport.Row(13, "string", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC))));
    }

    @Test
    public void when_noFieldsResolved_then_wholeValueMapped() {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='10', 'keyPortableClassId'='11', 'keyPortableClassVersion'='12', 'valueFormat'='portable', 'valuePortableFactoryId'='10', 'valuePortableClassId'='11', 'valuePortableClassVersion'='12')", new Object[0]);
        GenericRecord record = new PortableGenericRecordBuilder(emptyClassDefinition).build();
        SqlPortableTest.instance().getMap(name).put((Object)record, (Object)record);
        SqlPortableTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, Collections.singletonList(new SqlTestSupport.Row(record, record)));
    }

    @Test
    public void test_classDefMappingMismatch() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING " + SqlPortableTest.randomName() + " (id VARCHAR) TYPE IMap OPTIONS ('keyFormat'='int','valueFormat'='portable','valuePortableFactoryId'='1', 'valuePortableClassId'='2', 'valuePortableClassVersion'='3' )", new Object[0])).hasMessage("Mismatch between declared and resolved type: id");
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (foo INT) TYPE IMap OPTIONS ('keyFormat'='int','valueFormat'='portable','valuePortableFactoryId'='1', 'valuePortableClassId'='2', 'valuePortableClassVersion'='3' )", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("insert into " + name + "(__key, foo) values(1, 1)", new Object[0])).hasMessage("Field \"foo\" doesn't exist in Portable Class Definition");
        sqlService.execute("insert into " + name + "(__key, foo) values(1, null)", new Object[0]);
        sqlService.execute("insert into " + name + "(__key) values(2)", new Object[0]);
        SqlPortableTest.assertRowsAnyOrder("select __key, foo from " + name, SqlPortableTest.rows(2, 1, null, 2, null));
    }

    @Test
    public void when_unknownClassDef_then_wholeValueMapped() {
        String name = SqlPortableTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='9999', 'keyPortableClassId'='9999', 'keyPortableClassVersion'='9999', 'valueFormat'='portable', 'valuePortableFactoryId'='9998', 'valuePortableClassId'='9998', 'valuePortableClassVersion'='9998')", new Object[0]);
        SqlPortableTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, Collections.emptyList());
    }

    private static Map.Entry<Data, Data> randomEntryFrom(String mapName) {
        NodeEngineImpl engine = com.hazelcast.jet.impl.util.Util.getNodeEngine((HazelcastInstance)SqlPortableTest.instance());
        MapService service = (MapService)engine.getService("hz:impl:mapService");
        MapServiceContext context = service.getMapServiceContext();
        return Arrays.stream(context.getPartitionContainers()).map(partitionContainer -> partitionContainer.getExistingRecordStore(mapName)).filter(Objects::nonNull).flatMap(store -> {
            Iterator iterator = store.iterator();
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        }).map(entry -> Util.entry((Object)((Data)entry.getKey()), (Object)((Data)((Record)entry.getValue()).getValue()))).findFirst().get();
    }
}

