/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlService;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlMappingTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlMappingTest.initialize((int)1, null);
        sqlService = SqlMappingTest.instance().getSql();
    }

    @Test
    public void testExternalNameShouldNotHaveMoreComponents() {
        String query = "CREATE MAPPING map EXTERNAL NAME \"schema1\".\"mapName\" (__key INT,this VARCHAR) TYPE IMap OPTIONS ('keyFormat'='java', 'keyJavaClass'='" + Integer.class.getName() + "', 'valueFormat'='java', 'valueJavaClass'='" + String.class.getName() + "')";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(query, new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Invalid external name \"schema1\".\"mapName\"");
    }

    @Test
    public void testSqlCatalogCannotBeMapped() {
        this.testInternalMapCannotBeMapped("__sql.catalog");
    }

    @Test
    public void testJetImapsCannotBeMapped() {
        this.testInternalMapCannotBeMapped("__jet.records");
        this.testInternalMapCannotBeMapped("__jet.executionRecords");
        this.testInternalMapCannotBeMapped("__jet.results");
        this.testInternalMapCannotBeMapped("__jet.results.metrics");
    }

    private void testInternalMapCannotBeMapped(String name) {
        String query = "CREATE MAPPING map EXTERNAL NAME \"" + name + "\" TYPE IMap OPTIONS ('keyFormat'='java', 'keyJavaClass'='" + Object.class.getName() + "', 'valueFormat'='java', 'valueJavaClass'='" + Object.class.getName() + "')";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(query, new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Mapping of internal IMaps is not allowed");
    }
}

